/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.util.Calendar;

import javax.mail.internet.InternetAddress;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationVeloCityCreater;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;

public class ProgressBarDialog extends JDialog implements ActionListener {

	private static final long serialVersionUID = 332545922334445010L;

	private JProgressBar overallProgressBar;
	private JProgressBar fileProgressBar;
	private JLabel overallProgressLabel = new JLabel("overall process:");
	private JLabel fileProgressLabel = new JLabel("file process:");

	private JButton sendButton = new JButton("Send");
	private JButton cancelButton = new JButton("Cancel");

	private JEditorPane htmlPanel = new JEditorPane();

	private Path files;
	private MetaData metaData;
	private ClientPrimaryDataDirectory userDirectory;
	private InternetAddress loggedUser;
	private Calendar embargoDate;

	private int returnValue = 0;

	public ProgressBarDialog(Frame parent, int numberOfFiles, Path files, MetaData metaData, ClientPrimaryDataDirectory userDirectory, InternetAddress loggedUser, Calendar embargoDate) {

		super(parent, "Upload : '" + files.getFileName().toString() + "'", true);

		this.setFocusable(true);
		this.setIconImage(PropertyLoader.EDAL_ICON);
		this.files = files;
		this.sendButton.addActionListener(this);
		this.cancelButton.addActionListener(this);

		this.overallProgressBar = new JProgressBar(0, Math.max(1, numberOfFiles));
		this.overallProgressBar.setValue(0);
		this.overallProgressBar.setStringPainted(true);

		this.fileProgressBar = new JProgressBar();
		this.fileProgressBar.setValue(0);
		this.fileProgressBar.setString("0%");
		this.fileProgressBar.setStringPainted(true);
		this.metaData = metaData;
		this.userDirectory = userDirectory;
		this.loggedUser = loggedUser;
		this.embargoDate = embargoDate;

		GridBagLayout gridBagLayout = new GridBagLayout();
		final JPanel barPanel = new JPanel(gridBagLayout);

		barPanel.setMaximumSize(new Dimension(600, 80));

		Utils.addComponent(barPanel, gridBagLayout, this.overallProgressLabel, 0, 0, 1, 1, 0.05, 1, 1, 1, new Insets(5, 5, 5, 5));
		Utils.addComponent(barPanel, gridBagLayout, this.fileProgressLabel, 0, 1, 1, 1, 0.05, 1, 1, 1, new Insets(5, 5, 5, 5));
		Utils.addComponent(barPanel, gridBagLayout, this.overallProgressBar, 1, 0, 1, 1, 1, 1, 1, 1, new Insets(5, 5, 5, 5));
		Utils.addComponent(barPanel, gridBagLayout, this.fileProgressBar, 1, 1, 1, 1, 1, 1, 1, 1, new Insets(5, 5, 5, 5));

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.Y_AXIS));

		this.htmlPanel.setContentType("text/html");

		try {
			htmlPanel.setText(PublicationVeloCityCreater.generateHtmnlForProcessDialog());
		} catch (EdalException e) {
			e.printStackTrace();
		}

		this.htmlPanel.setEditable(false);
		this.htmlPanel.setBorder(BorderFactory.createEmptyBorder());

		mainPanel.add(this.htmlPanel);
		mainPanel.add(barPanel);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));

		buttonPanel.add(this.sendButton);
		buttonPanel.add(this.cancelButton);
		mainPanel.add(buttonPanel);

		this.setContentPane(mainPanel);
		this.setResizable(false);
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setPreferredSize(new Dimension(600, 400));
		this.pack();

		this.setLocationRelativeTo(null);

	}

	@Override
	public void actionPerformed(ActionEvent actionEvent) {

		if (actionEvent.getSource().equals(this.sendButton)) {

			this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);

			this.sendButton.setEnabled(false);
			this.cancelButton.setEnabled(false);

			ProgressSwingWorker worker = new ProgressSwingWorker(this.overallProgressBar, this.fileProgressBar, this.sendButton, this.cancelButton, this.htmlPanel, this.files, this.metaData, this.userDirectory, this.loggedUser, this.embargoDate);

			worker.execute();

			this.returnValue = 1;
		}

		else if (actionEvent.getSource().equals(this.cancelButton)) {
			this.dispose();
		}

	}

	public void showDialog() {
		if (this.overallProgressBar != null) {
			this.setVisible(true);
		} else {
			this.dispose();
		}
	}

	public int getReturnValue() {
		return this.returnValue;
	}

}