/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;

import org.apache.commons.io.IOUtils;

import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataFileRmiInterface;

/**
 * SampleClient version of {@link PrimaryDataFile} to use eDAL system like the
 * stand-alone implementation.
 * 
 * @author arendd
 */
public class ClientPrimaryDataFile extends ClientPrimaryDataEntity {

	/**
	 * Constructor for ClientPrimaryDataFile.
	 * 
	 * @param file
	 *            a {@link PrimaryDataFileRmiInterface} object.
	 * @param client
	 *            the {@link ClientDataManager}
	 */
	public ClientPrimaryDataFile(PrimaryDataFileRmiInterface file, ClientDataManager client) {
		super(file, client);
	}

	// /**
	// * {@link PrimaryDataFile#read(OutputStream)}
	// *
	// * @param dataOutputStream
	// * the loaded data.
	// * @throws PrimaryDataFileException
	// * if no data is stored.
	// * @see PrimaryDataFileRmiInterface#read(RemoteOutputStream, Subject)
	// * @throws RemoteException
	// * if unable to call remote function.
	// */
	// public void read(OutputStream dataOutputStream) throws RemoteException,
	// PrimaryDataFileException {
	//
	// /** Java 7 version */
	//
	// DefaultRemoteStreamExporter exporter = new
	// DefaultRemoteStreamExporter(clientDataManager.getDataPort());
	//
	// try (RemoteOutputStreamServer ostream = new
	// SimpleRemoteOutputStream(dataOutputStream)) {
	// ((PrimaryDataFileRmiInterface)
	// myEntityRMI).read(exporter.export(ostream),
	// this.getCurrentVersion().getRevision(), clientDataManager.getSubject());
	// }
	//
	// }

	public void read(OutputStream outputStream) throws RemoteException, PrimaryDataFileException {

		try {
			InputStream inStream = RemoteInputStreamClient.wrap(((PrimaryDataFileRmiInterface) myEntityRMI)
					.sendFileToClient(this.getCurrentVersion().getRevision(), clientDataManager.getSubject()));

			IOUtils.copy(inStream, outputStream);

			inStream.close();

			outputStream.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	// /**
	// * {@link PrimaryDataFile#store(InputStream)}
	// *
	// * @param dataInputStream
	// * the date to store in this {@link PrimaryDataEntityVersion}.
	// * @throws PrimaryDataFileException
	// * if storing of data fails.
	// * @throws PrimaryDataEntityVersionException
	// * if provided version conflicts with existing versions.
	// * @see PrimaryDataFileRmiInterface#store(RemoteInputStream, Subject)
	// * @throws RemoteException
	// * if unable to call remote function.
	// */
	// public void store(InputStream dataInputStream) throws RemoteException,
	// PrimaryDataFileException, PrimaryDataEntityVersionException {
	//
	// if (dataInputStream == null) {
	// throw new
	// PrimaryDataFileException("can not store inputstream: stream is null ");
	// }
	//
	// /** Java 7 Version */
	//
	// DefaultRemoteStreamExporter exporter = new
	// DefaultRemoteStreamExporter(clientDataManager.getDataPort());
	//
	// try (RemoteInputStreamServer istream = new
	// SimpleRemoteInputStream(dataInputStream)) {
	//
	// ((PrimaryDataFileRmiInterface)
	// myEntityRMI).store(exporter.export(istream),
	// clientDataManager.getSubject());
	// }
	//
	// /** Java 6 Version */
	// // RemoteInputStreamServer istream = new SimpleRemoteInputStream(
	// // dataInputStream);
	// // ((PrimaryDataFileRmiInterface) myEntityRMI).store(istream.export(),
	// // clientDataManager.getSubject());
	// //
	// // istream.close();
	//
	// this.currentVersion = this.getVersions().last();
	//
	// }

	public void store(InputStream inputStream)
			throws RemoteException, PrimaryDataFileException, PrimaryDataEntityVersionException {
		ClientPrimaryDataEntityVersion version = this.getCurrentVersion();
		try {
			OutputStream outStream = RemoteOutputStreamClient.wrap(((PrimaryDataFileRmiInterface) myEntityRMI)
					.sendOutputStreamToFillFromClient(clientDataManager.getSubject()));

			IOUtils.copy(inputStream, outStream);

			inputStream.close();

			outStream.close();

			while (version.getRevision() == this.getVersions().size() - 1) {

				// System.out.println("WAIT WAIT WAIT");
				try {
					Thread.sleep(0, 1);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/** {@inheritDoc} */
	public void setMetaData(MetaData new_metadata)
			throws RemoteException, PrimaryDataEntityVersionException, MetaDataException {
		((PrimaryDataFileRmiInterface) myEntityRMI).setMetaData(new_metadata, clientDataManager.getSubject());
		this.currentVersion = this.getVersions().last();
	}

}