/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/**
 * Main class to start a client application from
 * "java -jar ***-jar-with-dependencies.jar"
 * 
 * @author arendd
 */

public class ClientStarter {

	private static int DEFAULT_EDAL_PORT = 2000;
	private static String DEFAULT_EDAL_HOST = "localhost";
	private static int WEBDAV_PORT = 8080;

	public static void main(String[] args) {

		final Options options = new Options();

		System.out
				.println("e!DAL client application\nIPK-Gatersleben.\nAll rights reserved.\n");

		options.addOption("h", "help", false, "print help");
		options.addOption("w", "webdav", false, "start WebDAV ");
		options.addOption("g", "gui", false, "start FileChooser GUI ");

		options.addOption("p", "server_port", true,
				"set port for e!DAL server (default=" + DEFAULT_EDAL_PORT + ")");
		options.addOption("d", "webdav_port", true,
				"set port for WebDAV server (default=" + WEBDAV_PORT + ")");
		options.addOption("s", "server_host", true,
				"set host for e!DAL server (default=" + DEFAULT_EDAL_HOST + ")");

		final HelpFormatter form = new HelpFormatter();

		final CommandLineParser parser = new PosixParser();
		CommandLine cmd = null;
		try {
			cmd = parser.parse(options, args);
		} catch (final ParseException e) {
			e.printStackTrace();
		}
		if (cmd.hasOption("h")) {
			form.printHelp("-h", options);
			System.exit(0);
		}

		if (cmd.hasOption("s")) {
			DEFAULT_EDAL_HOST = cmd.getOptionValue("s");
		}
		if (cmd.hasOption("p")) {
			try {
				DEFAULT_EDAL_PORT = Integer.parseInt(cmd.getOptionValue("p"));
			} catch (NumberFormatException e) {
				System.out
						.println("Please enter a number for e!DAL server port");
				System.exit(0);
			}
		}
		if (cmd.hasOption("d")) {
			try {
				WEBDAV_PORT = Integer.parseInt(cmd.getOptionValue("d"));
			} catch (NumberFormatException e) {
				System.out.println("Please enter a number for WebDAV port");
				System.exit(0);
			}
		}

		/* start WebDAV application */
		if (cmd.hasOption("w")) {
			String[] argm = { "-p" + String.valueOf(DEFAULT_EDAL_PORT),
					"-s" + DEFAULT_EDAL_HOST, "-d" + String.valueOf(WEBDAV_PORT) };

			de.ipk_gatersleben.bit.bi.edal.webdav.sample.Main.main(argm);
		}
		/* start GUI application */
		else if (cmd.hasOption("g")) {
			String[] argm = { DEFAULT_EDAL_HOST, String.valueOf(DEFAULT_EDAL_PORT) };

			de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui.Main.main(argm);
		}
		/* stop program if no application is select */
		else {
			System.out
					.println("Please set -w to start WebDAV or -g to start FileChooser GUI");
			System.exit(-0);
		}
	}
}