/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
public class ServerStartStopActionListner implements ActionListener{
	private final WebdavServer jettyServer;

	public ServerStartStopActionListner(WebdavServer jettyServer) {
		this.jettyServer = jettyServer;
	}

	public void actionPerformed(ActionEvent actionEvent) {
		 JButton btnStartStop =  (JButton) actionEvent.getSource();
		 if(jettyServer.isStarted()){
			 btnStartStop.setText("Stopping...");
			 btnStartStop.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			 try {
				jettyServer.stop();
			} catch (Exception exception) {
				exception.printStackTrace();
			}
			 btnStartStop.setText("Start");
			 btnStartStop.setCursor
				(new Cursor(Cursor.DEFAULT_CURSOR));
		 }
		 else if(jettyServer.isStopped()){
			 btnStartStop.setText("Starting...");
			 btnStartStop.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			 try {
				jettyServer.start();
			} catch (Exception exception) {
				exception.printStackTrace();
			}
			 btnStartStop.setText("Stop");
			 btnStartStop.setCursor
				(new Cursor(Cursor.DEFAULT_CURSOR));
		 }
	}
}
