/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;

import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemCache;

public class WebdavServer {
	private Server server;
	private static int WEBDAV_SSLPORT = 8443;

	public WebdavServer() {
		final Properties prop = new Properties();

		/* load default webDAV-Properties */
		try {
			prop.load(Main.class.getResourceAsStream("/eDALwebDAV.properties"));
			WEBDAV_SSLPORT = Integer.parseInt(prop.getProperty("browser.sslport"));
		} catch (final IOException e) {
			ClientDataManager.logger.fatal("error loading default WebDAV properties", e);
			System.exit(-1);
		}
		server = new Server(WEBDAV_SSLPORT);
		SslContextFactory sslContextFactory = new SslContextFactory();

		KeyStore keystore = null;
		try {
			keystore = KeyStore.getInstance("JKS");

			keystore.load(EdalConfiguration.KEY_STORE_PATH.openStream(), EdalConfiguration.KEYSTORE_PASSWORD.toString().toCharArray());
		} catch (KeyStoreException | NoSuchAlgorithmException | CertificateException | IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		sslContextFactory.setKeyStorePassword(EdalConfiguration.KEYSTORE_PASSWORD);
		sslContextFactory.setKeyStore(keystore);

		ServerConnector sslConnector = new ServerConnector(server, sslContextFactory);

		// SslSocketConnector sslConnector = new SslSocketConnector(
		// sslContextFactory);
		sslConnector.setPort(WEBDAV_SSLPORT);
		server.setConnectors(new Connector[] { sslConnector });

		ContextHandlerCollection contexts = new ContextHandlerCollection();

		contexts.setHandlers(new Handler[] { new AppContextBuilder().buildWebAppContext() });

		server.setHandler(contexts);
	}

	public void start() throws Exception {
		FileSystemCache.init();
		server.start();
	}

	public void stop() throws Exception {
		server.stop();
		server.join();
	}

	public boolean isStarted() {
		return server.isStarted();
	}

	public boolean isStopped() {
		return server.isStopped();
	}
}
