/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import io.milton.http.HttpManager;

public interface EdalInitListener {
	/**
	 * Called just before init on HttpManagerBuilder
	 * 
	 * @param b
	 *            builder
	 */
	void beforeInit(EdalHttpManagerBuilder b);

	/**
	 * Called just after init, and before building the HttpManager instance
	 * 
	 * @param b
	 *            builder
	 */
	void afterInit(EdalHttpManagerBuilder b);

	/**
	 * Called immediately after bulding the http manager
	 * 
	 * @param b
	 *            builder
	 * @param m
	 *            manager
	 */
	void afterBuild(EdalHttpManagerBuilder b, HttpManager m);

}
