/*
 * Copyright (c) 2016 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Creative Commons Attribution-NoDerivatives 4.0 International (CC BY-ND 4.0)
 * which accompanies this distribution, and is available at http://creativecommons.org/licenses/by-nd/4.0/
 *
 * Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - RMI Client, FileChooser and WebDAV
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class NaturalPersonWrapper extends PersonWrapper{
	@XmlAttribute private String given_name;
	@XmlAttribute private String sure_name;
	
	public NaturalPersonWrapper()
	{
	}

	public NaturalPersonWrapper(de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson p) {
		super(p);
		this.given_name = p.getGivenName();
		this.sure_name = p.getSureName();
	}

	public String getGiven_name() {
		return given_name;
	}
	
	public void setGiven_name(String givenName) {
		this.given_name = givenName;
	}
	

	public String getSure_name() {
		return sure_name;
	}
	
	public void setSure_name(String sureName) {
		this.sure_name = sureName;
	}
	
	public de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson getPerson() {
		return new de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson(this.sure_name, this.given_name, this.getAddress_line(), this.getZip(), this.getCountry());
	}
}
