/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationHtmlTextPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.ShutdownWindowsListener;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JFrame;

public class PublicationFrame
extends JFrame {
    private static final long serialVersionUID = 3152855359717852975L;
    private static PublicationMainPanel mainPanel;
    private static PublicationHtmlTextPanel headPanel;
    private static PublicationButtonLinePanel buttonPanel;
    public static ClientPrimaryDataDirectory rootDirectory;
    public static String loggedUser;

    public static PublicationButtonLinePanel getButtonPanel() {
        return buttonPanel;
    }

    public static void updateUI() {
        mainPanel.revalidate();
        mainPanel.repaint();
        buttonPanel.revalidate();
        buttonPanel.repaint();
        headPanel.updateHtml();
    }

    public PublicationFrame(String loggedUser, ClientDataManager clientDataManager) throws Exception {
        this.setTitle("IPK Data Publication System");
        this.setIconImage(PropertyLoader.EDAL_ICON);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ShutdownWindowsListener());
        mainPanel = new PublicationMainPanel();
        headPanel = new PublicationHtmlTextPanel();
        buttonPanel = new PublicationButtonLinePanel(clientDataManager);
        PublicationFrame.loggedUser = loggedUser;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)headPanel, "North");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setMinimumSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);
        this.setPreferredSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static ClientPrimaryDataDirectory getUserDirectory() {
        ClientPrimaryDataDirectory userDirectory = null;
        try {
            userDirectory = (ClientPrimaryDataDirectory)rootDirectory.getPrimaryDataEntity(loggedUser);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (PrimaryDataDirectoryException e) {
            try {
                userDirectory = rootDirectory.createPrimaryDataDirectory(loggedUser);
            }
            catch (PrimaryDataDirectoryException | RemoteException e1) {
                e1.printStackTrace();
            }
        }
        return userDirectory;
    }

    static {
        rootDirectory = null;
        loggedUser = "";
    }
}

