/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.publication.IpkAuthenticationProcess;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.ServerErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.EdalServer;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.rmi.ConnectException;
import javax.security.auth.Subject;

public class PublicationModulMain {
    private static final String SERVER = "localhost";
    private static final int REGISTRY_PORT = 2000;
    private static PublicationFrame frame;
    public static ClientDataManager clientDataManager;

    public static PublicationFrame getFrame() {
        return frame;
    }

    private static void setCurrentFrame(PublicationFrame frame) {
        PublicationModulMain.frame = frame;
    }

    public static void main(String[] args) throws Exception {
        PropertyLoader.initialize();
        Boolean retry = true;
        while (retry.booleanValue()) {
            try {
                Authentication testAuthentication = new Authentication(EdalHelpers.authenticateSampleUser());
                clientDataManager = new ClientDataManager(SERVER, 2000, testAuthentication);
                clientDataManager.getRootDirectory();
                retry = false;
            }
            catch (ConnectException e) {
                ServerErrorDialog dialog = new ServerErrorDialog(null, e.getMessage());
                dialog.showDialog();
                if (dialog.getReturnValue() == 1) {
                    retry = true;
                    continue;
                }
                System.exit(0);
            }
        }
        Subject ipkSubject = new IpkAuthenticationProcess().getSubject();
        if (ipkSubject != null) {
            Authentication authentication = new Authentication(ipkSubject);
            retry = true;
            while (retry.booleanValue()) {
                try {
                    clientDataManager = new ClientDataManager(SERVER, 2000, authentication);
                    PublicationFrame.rootDirectory = clientDataManager.getRootDirectory();
                    retry = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ServerErrorDialog dialog = new ServerErrorDialog(null, e.getMessage());
                    dialog.showDialog();
                    if (dialog.getReturnValue() == 1) {
                        retry = true;
                        continue;
                    }
                    EdalServer.stopServer((String)SERVER, (int)2000);
                    System.exit(0);
                }
            }
            PublicationModulMain.setCurrentFrame(new PublicationFrame(authentication.getName(), clientDataManager));
        } else {
            System.exit(0);
        }
    }
}

