/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class PublicationVeloCityCreater {
    private static final String CODING_UTF_8 = "UTF-8";
    private static final String RESOURCES = "de/ipk_gatersleben/bit/bi/edal/publication/";
    private static final String HEAD_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/head.html";
    private static final String PROCESS_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/process.html";
    private static final String FINISH_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/finish.html";
    private static final String SERVER_ERROR_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/server_error.html";

    protected static String generateHtmlForHeadPage() throws EdalException {
        VelocityContext context = new VelocityContext();
        URL edalLogoUrl = PublicationFrame.class.getResource("edal_scaled.png");
        URL ipkLogoUrl = PublicationFrame.class.getResource("ipk_scaled.png");
        context.put("edal", (Object)edalLogoUrl);
        context.put("ipk", (Object)ipkLogoUrl);
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)HEAD_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateHtmnlForProcessDialog() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)PROCESS_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateFinishUploadPage() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)FINISH_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateServerErrorDialog(String errorMessage) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("errorMessage", (Object)errorMessage);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)SERVER_ERROR_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    static {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        Velocity.init();
    }
}

