/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationVeloCityCreater;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;

public class ServerErrorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2288426728436421340L;
    private JButton retryButton = new JButton("RETRY");
    private JButton cancelButton = new JButton("CANCEL");
    private int returnValue = 0;

    public ServerErrorDialog(Frame parent, String errorMessage) {
        super(parent, "IPK Data Publication System", true);
        this.setFocusable(true);
        this.setIconImage(PropertyLoader.EDAL_LOGO);
        JEditorPane textPane = new JEditorPane();
        textPane.setContentType("text/html");
        try {
            textPane.setText(PublicationVeloCityCreater.generateServerErrorDialog(errorMessage));
        }
        catch (EdalException e) {
            e.printStackTrace();
        }
        textPane.setEditable(false);
        textPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.retryButton);
        buttonPanel.add(this.cancelButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(textPane);
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(500, 200));
        this.setDefaultCloseOperation(2);
        this.retryButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.retryButton)) {
            this.returnValue = 1;
            this.dispose();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.returnValue = 0;
            this.dispose();
        }
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public Object showDialog() {
        this.setVisible(true);
        return this;
    }
}

