/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeTablePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.SmallButton;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel.AuthorCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class AuthorsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8109825692298261311L;
    private static final AttributeLabel AUTHORS_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("AUTHORS_LABEL"), PropertyLoader.props.getProperty("AUTHORS_TOOLTIP"));
    private static final SmallButton OKAY_BUTTON = new SmallButton("OK");
    private static final SmallButton ADD_BUTTON = new SmallButton("ADD AUTHOR");
    private static final SmallButton REMOVE_BUTTON = new SmallButton("REMOVE AUTHOR");
    private static final String CORRESPONDING_AUTOR = "Corresponding author";
    private static final String CONTRIBUTOR = "Contributor";
    private static final String[] roles = new String[]{"Corresponding author", "Contributor"};
    private static final String[] DEFAULT_AUTHOR_VALUE = new String[]{roles[0], "", "", "", "Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), OT Gatersleben, Corrensstra\u00dfe 3, Stadt Seeland", "06466", "Germany"};
    private static final String[] COL_NAMES = new String[]{"Role", "Given Name", "Surname", "Group Authors", "Address", "Zip", "Country"};
    private DefaultTableModel model = new AuthorTableModel();
    private JTable table = new JTable(this.model);
    private final DefaultComboBoxModel<String> comboModel;
    private final JScrollPane scrollPane;

    public AuthorsPanel() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ((DefaultCellEditor)this.table.getDefaultEditor(this.table.getColumnClass(i))).setClickCountToStart(1);
        }
        this.table.setFillsViewportHeight(true);
        this.table.setFont(PropertyLoader.DEFAULT_FONT);
        this.table.setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.table.getTableHeader().setFont(PropertyLoader.DEFAULT_FONT);
        this.table.getTableHeader().setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(120);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(90);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(60);
        this.comboModel = new DefaultComboBoxModel<String>(roles);
        JComboBox<String> comboRow = new JComboBox<String>();
        comboRow.setModel(this.comboModel);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setCellEditor(new DefaultCellEditor(comboRow));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new AuthorCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new AuthorCellRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new AuthorCellRenderer());
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        buttonPanel.add(OKAY_BUTTON);
        buttonPanel.add(ADD_BUTTON);
        buttonPanel.add(REMOVE_BUTTON);
        OKAY_BUTTON.addActionListener(this);
        ADD_BUTTON.addActionListener(this);
        REMOVE_BUTTON.addActionListener(this);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(680, 130));
        GridBagLayout grid = new GridBagLayout();
        JPanel tablePanel = new JPanel(grid);
        tablePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        tablePanel.setPreferredSize(new Dimension(680, 130));
        EmptyBorder inBorder = new EmptyBorder(5, 5, 0, 5);
        EmptyBorder outBorder = new EmptyBorder(5, 5, 0, 5);
        tablePanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        Utils.add(tablePanel, grid, this.scrollPane, 0, 0, 1, 1, 1.0, 0.95, 1, 1);
        Utils.add(tablePanel, grid, buttonPanel, 0, 1, 1, 1, 1.0, 0.05, 1, 1);
        JPanel attributePanel = new JPanel(new GridLayout());
        AUTHORS_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
        attributePanel.add(AUTHORS_LABEL);
        attributePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        attributePanel.setPreferredSize(new Dimension(120, 130));
        this.setLayout(new BorderLayout());
        this.add((Component)attributePanel, "West");
        this.add((Component)tablePanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(OKAY_BUTTON)) {
            int i;
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null && cellEditor.getCellEditorValue() == null) {
                cellEditor.stopCellEditing();
            }
            this.table.clearSelection();
            this.comboModel.setSelectedItem(this.comboModel.getSelectedItem());
            ArrayList<Integer> emptyLines = new ArrayList<Integer>();
            for (i = 0; i < this.table.getRowCount(); ++i) {
                if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString()) || !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) || !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
                emptyLines.add(i);
            }
            for (i = emptyLines.size() - 1; i >= 0; --i) {
                this.model.removeRow((Integer)emptyLines.get(i));
            }
            PublicationMainPanel.authorPanel = this;
            PublicationMainPanel.authorsField.setText(this.getTableContent());
            PublicationMainPanel.releaseAllBlockedFields();
            PublicationMainPanel.titleAuthorSplitPanel.setRightComponent(null);
            PropertyLoader.AUTHORS_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
            PublicationMainPanel.titleAuthorSplitPanel.setRightComponent(new AttributeTablePanel(PropertyLoader.AUTHORS_LABEL, PublicationMainPanel.authorsField, 130));
            PublicationFrame.updateUI();
            PublicationButtonLinePanel.getSubmitButton().requestFocus();
            this.saveUserValues();
        } else if (actionEvent.getSource().equals(ADD_BUTTON)) {
            boolean correspondingAuthorSetted = false;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!this.table.getValueAt(i, 0).toString().equals(roles[0].toString())) continue;
                correspondingAuthorSetted = true;
                break;
            }
            if (this.table.getSelectedRow() != -1) {
                if (correspondingAuthorSetted) {
                    this.model.insertRow(this.table.getSelectedRow() + 1, new String[]{roles[1], "", "", "", this.table.getValueAt(this.table.getSelectedRow(), 4).toString(), this.table.getValueAt(this.table.getSelectedRow(), 5).toString(), this.table.getValueAt(this.table.getSelectedRow(), 6).toString()});
                } else {
                    this.model.insertRow(this.table.getSelectedRow() + 1, new String[]{roles[0], "", "", "", this.table.getValueAt(this.table.getSelectedRow(), 4).toString(), this.table.getValueAt(this.table.getSelectedRow(), 5).toString(), this.table.getValueAt(this.table.getSelectedRow(), 6).toString()});
                }
            } else {
                if (correspondingAuthorSetted) {
                    this.model.addRow(new String[]{roles[1], "", "", "", this.table.getValueAt(this.table.getRowCount() - 1, 4).toString(), this.table.getValueAt(this.table.getRowCount() - 1, 5).toString(), this.table.getValueAt(this.table.getRowCount() - 1, 6).toString()});
                } else if (this.table.getRowCount() != 0) {
                    this.model.addRow(new String[]{roles[0], "", "", "", this.table.getValueAt(this.table.getRowCount() - 1, 4).toString(), this.table.getValueAt(this.table.getRowCount() - 1, 5).toString(), this.table.getValueAt(this.table.getRowCount() - 1, 6).toString()});
                } else {
                    this.model.addRow(DEFAULT_AUTHOR_VALUE);
                }
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            }
        } else if (actionEvent.getSource().equals(REMOVE_BUTTON)) {
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null && cellEditor.getCellEditorValue() == null) {
                cellEditor.stopCellEditing();
            }
            if (this.model.getRowCount() != 0) {
                if (this.table.getSelectedRow() == -1) {
                    this.model.removeRow(this.model.getRowCount() - 1);
                    this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
                } else {
                    this.model.removeRow(this.table.getSelectedRow());
                }
            }
        }
    }

    public String getAuthors() {
        String authorSeperator = new String("; ");
        String nameSeperator = new String(", ");
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.model.getValueAt(i, 0).equals(roles[0])) continue;
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) && !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                buffer.append(this.model.getValueAt(i, 2).toString());
                buffer.append(nameSeperator);
                buffer.append(this.model.getValueAt(i, 1).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                buffer.append(this.model.getValueAt(i, 1).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString())) {
                buffer.append(this.model.getValueAt(i, 2).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
            buffer.append(this.model.getValueAt(i, 3).toString());
            buffer.append(authorSeperator);
        }
        if (buffer.toString().lastIndexOf(authorSeperator) != -1) {
            return buffer.toString().substring(0, buffer.toString().lastIndexOf(authorSeperator));
        }
        return PropertyLoader.props.getProperty("DEFAULT_AUTHORS_STRING");
    }

    public Persons getContributors() {
        Persons contributors = new Persons();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.model.getValueAt(i, 0).toString().equals(CONTRIBUTOR)) continue;
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) || !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                contributors.add((Person)new NaturalPerson(this.model.getValueAt(i, 1).toString(), this.model.getValueAt(i, 2).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString()));
                continue;
            }
            if (Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
            contributors.add((Person)new LegalPerson(this.model.getValueAt(i, 3).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString()));
        }
        return contributors;
    }

    public Persons getCreators() {
        Persons creators = new Persons();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!this.model.getValueAt(i, 0).toString().equals(CORRESPONDING_AUTOR)) continue;
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) || !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                creators.add((Person)new NaturalPerson(this.model.getValueAt(i, 1).toString(), this.model.getValueAt(i, 2).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString()));
                continue;
            }
            if (Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
            creators.add((Person)new LegalPerson(this.model.getValueAt(i, 3).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString()));
        }
        return creators;
    }

    private String getTableContent() {
        if (this.getCreators().size() == 0) {
            return PropertyLoader.props.getProperty("DEFAULT_AUTHORS_STRING");
        }
        String authorSeperator = new String("; ");
        String nameSeperator = new String(", ");
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) && !Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                buffer.append(this.model.getValueAt(i, 2).toString());
                buffer.append(nameSeperator);
                buffer.append(this.model.getValueAt(i, 1).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) {
                buffer.append(this.model.getValueAt(i, 1).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString())) {
                buffer.append(this.model.getValueAt(i, 2).toString());
                buffer.append(authorSeperator);
                continue;
            }
            if (Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
            buffer.append(this.model.getValueAt(i, 3).toString());
            buffer.append(authorSeperator);
        }
        if (buffer.toString().lastIndexOf(authorSeperator) == -1) {
            return PropertyLoader.props.getProperty("DEFAULT_AUTHORS_STRING");
        }
        return buffer.toString().substring(0, buffer.toString().lastIndexOf(authorSeperator));
    }

    public void reset() {
        this.model = new AuthorTableModel();
        this.table = new JTable(this.model);
    }

    private void saveUserValues() {
        String authorSeperator = new String(";");
        String nameSeperator = new String("@");
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if ((Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 2).toString()) || Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 1).toString())) && Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 3).toString())) continue;
            buffer.append(this.model.getValueAt(i, 0).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 1).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 2).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 3).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 4).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 5).toString());
            buffer.append(nameSeperator);
            buffer.append(this.model.getValueAt(i, 6).toString());
            buffer.append(authorSeperator);
        }
        PropertyLoader.setUserValue("AUTHORS", buffer.toString());
    }

    private class AuthorTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8557354261856948625L;

        public AuthorTableModel() {
            this.setDataVector(this.loadUserValues(), COL_NAMES);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 3) {
                return this.getValueAt(row, 1).toString().isEmpty() && this.getValueAt(row, 2).toString().isEmpty();
            }
            if (column == 1 || column == 2) {
                return this.getValueAt(row, 3).toString().isEmpty();
            }
            return true;
        }

        private Object[][] loadUserValues() {
            String string = PropertyLoader.userValues.getProperty("AUTHORS");
            if (string == null || string.isEmpty()) {
                return new Objects[0][0];
            }
            String[] authors = string.split(";");
            Object[][] data = new Object[authors.length][7];
            for (int i = 0; i < authors.length; ++i) {
                if (authors[i] == null || authors[i].isEmpty()) {
                    return data;
                }
                String[] author = authors[i].split("@");
                for (int j = 0; j < author.length; ++j) {
                    data[i][j] = author[j];
                }
            }
            return data;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            super.setValueAt(value, row, column);
            AuthorsPanel.this.updateUI();
        }
    }
}

