/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeTablePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.SmallButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class LicensePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8109825692298261311L;
    private static AttributeLabel LICENSE_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("LICENSE_LABEL"), PropertyLoader.props.getProperty("LICENSE_TOOLTIP"));
    private static SmallButton OKAY_BUTTON = new SmallButton("OK");
    private static JComboBox<String> comboBox;

    public LicensePanel() {
        JPanel mainPanel = new JPanel(new FlowLayout(0, 10, 0));
        mainPanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        mainPanel.setPreferredSize(new Dimension(120, 26));
        EmptyBorder inBorder = new EmptyBorder(1, 2, 0, 2);
        EmptyBorder outBorder = new EmptyBorder(1, 2, 0, 2);
        mainPanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        comboBox.setSelectedItem(PublicationMainPanel.DEFAULT_LICENSE_STRING);
        OKAY_BUTTON.addActionListener(this);
        mainPanel.add(comboBox);
        mainPanel.add(OKAY_BUTTON);
        JPanel attributePanel = new JPanel(new GridLayout());
        attributePanel.add(LICENSE_LABEL);
        attributePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        attributePanel.setPreferredSize(new Dimension(120, 26));
        this.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        this.setBorder(new MatteBorder(1, 0, 0, 0, Color.GRAY));
        this.setPreferredSize(new Dimension(680, 26));
        this.setLayout(new BorderLayout());
        this.add((Component)attributePanel, "West");
        this.add((Component)mainPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(OKAY_BUTTON)) {
            PublicationMainPanel.licensePanel = this;
            PublicationMainPanel.licenseField.setText(this.getTableContent());
            PublicationMainPanel.releaseAllBlockedFields();
            PublicationMainPanel.embargoLanguageLicensePanel.remove(((BorderLayout)PublicationMainPanel.embargoLanguageLicensePanel.getLayout()).getLayoutComponent("Center"));
            PropertyLoader.LICENSE_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
            AttributeTablePanel newLicensePanel = new AttributeTablePanel(PropertyLoader.LICENSE_LABEL, PublicationMainPanel.licenseField, 26);
            newLicensePanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            PublicationMainPanel.embargoLanguageLicensePanel.add((Component)newLicensePanel, "Center");
            PublicationFrame.updateUI();
            PublicationButtonLinePanel.getSubmitButton().requestFocus();
            this.saveUserValues();
        }
    }

    private void saveUserValues() {
        PropertyLoader.setUserValue("LICENSE", comboBox.getSelectedItem().toString());
    }

    private String getTableContent() {
        return comboBox.getSelectedItem().toString();
    }

    public String getLicense() {
        return (String)comboBox.getSelectedItem();
    }

    static {
        String[] strings = PropertyLoader.SUPPORTED_LICENSES.toArray(new String[PropertyLoader.SUPPORTED_LICENSES.size()]);
        comboBox = new JComboBox<String>(strings);
        comboBox.setRenderer(new CustomComboBox());
        comboBox.setBorder(BorderFactory.createEmptyBorder());
        comboBox.setSelectedItem(PropertyLoader.loadLicenseString());
    }

    static class CustomComboBox
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 9120777908811491201L;
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private static final Dimension preferredSize = new Dimension(750, 14);

        CustomComboBox() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Color) {
                renderer.setBackground((Color)value);
            }
            renderer.setPreferredSize(preferredSize);
            return renderer;
        }
    }
}

