/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FileProgressMonitor {
    private JProgressBar fileProgressBar;
    private int max;

    public FileProgressMonitor(JProgressBar fileProgressBar, int max) {
        this.max = max;
        this.fileProgressBar = fileProgressBar;
    }

    public void setProgress(final int newValue) {
        if (newValue >= this.max) {
            this.close();
        } else if (this.fileProgressBar != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FileProgressMonitor.this.fileProgressBar.setValue((int)Math.ceil(100.0 / (double)FileProgressMonitor.this.max * (double)newValue));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this.fileProgressBar = null;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        if (this.fileProgressBar != null) {
            this.fileProgressBar.setMaximum(m);
        }
        this.max = m;
    }
}

