/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalLanguage;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Subjects;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import java.util.Calendar;
import java.util.Locale;

public class MetaDataCollector {
    private LegalPerson publisher = null;
    private UntypedData description = null;
    private UntypedData title = null;
    private EdalLanguage language = null;
    private UntypedData license = null;
    private Persons creators = new Persons();
    private Persons contributors = new Persons();
    private Subjects subjects = new Subjects();
    private Calendar embargoDate = null;

    public void collectAllMetaData() {
        this.collectTitle(PublicationMainPanel.titleField.getText());
        this.collectDescription(PublicationMainPanel.descriptionField.getText());
        this.collectSubjects(PublicationMainPanel.subjectPanel.getSubjects());
        this.collectPublisher(PublicationMainPanel.publisherPanel.getPublisher());
        this.collectLanguage(PublicationMainPanel.languagePanel.getLanguage());
        this.collectLicense(PublicationMainPanel.licensePanel.getLicense());
        this.collectCreators(PublicationMainPanel.authorPanel.getCreators());
        this.collectContributors(PublicationMainPanel.authorPanel.getContributors());
        this.collectEmbargoDate(PublicationMainPanel.embargboPanel.getEmbargoDate());
    }

    private void collectEmbargoDate(Calendar embargoDate) {
        this.embargoDate = embargoDate;
    }

    private void collectContributors(Persons contributors) {
        this.contributors = contributors;
    }

    private void collectCreators(Persons creators) {
        this.creators = creators;
    }

    private void collectDescription(String description) {
        this.description = new UntypedData(description);
    }

    private void collectLanguage(Locale language) {
        this.language = new EdalLanguage(language);
    }

    private void collectLicense(String license) {
        this.license = new UntypedData(license);
    }

    private void collectPublisher(LegalPerson publisher) {
        this.publisher = publisher;
    }

    private void collectSubjects(String[] subjects) {
        for (String string : subjects) {
            this.subjects.add(new UntypedData(string));
        }
    }

    private void collectTitle(String title) {
        this.title = new UntypedData(title);
    }

    public Persons getContributors() {
        return this.contributors;
    }

    public Persons getCreators() {
        return this.creators;
    }

    public UntypedData getDescription() {
        return this.description;
    }

    public EdalLanguage getLanguage() {
        return this.language;
    }

    public UntypedData getLicense() {
        return this.license;
    }

    public LegalPerson getPublisher() {
        return this.publisher;
    }

    public Subjects getSubjects() {
        return this.subjects;
    }

    public UntypedData getTitle() {
        return this.title;
    }

    public Calendar getEmbargoDate() {
        return this.embargoDate;
    }

    public String toString() {
        return "MetaDataCollector [\n subjects=" + this.subjects + ",\n publisher=" + this.publisher + ",\n description=" + this.description + ",\n title=" + this.title + ",\n language=" + this.language + ",\n license=" + this.license + ",\n creators=" + this.creators + ",\n contributors=" + this.contributors + "\n]";
    }
}

