/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PublicReferenceException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.reference.PersistentIdentifier;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationVeloCityCreater;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.FileStoreSwingWorker;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.ProgressBarDialog;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.PublicationDirectoryVisitorWithMetaDataRmi;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import javax.mail.internet.InternetAddress;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class ProgressSwingWorker
extends SwingWorker<Object, Object> {
    private JProgressBar overallProgressBar;
    private JProgressBar fileProgressBar;
    private JButton sendButton;
    private JButton cancelButton;
    private JEditorPane htmlPanel;
    private final Path files;
    private MetaData metaData;
    private ClientPrimaryDataDirectory userDirectory;
    private InternetAddress loggedUser;
    private Calendar embargoDate = null;

    public ProgressSwingWorker(JProgressBar overAllProgressBar, JProgressBar fileProgressBar, JButton sendButton, JButton cancelButton, JEditorPane htmlPanel, Path files, MetaData metaData, ClientPrimaryDataDirectory userDirectory, InternetAddress loggedUser, Calendar embargoDate) {
        this.overallProgressBar = overAllProgressBar;
        this.fileProgressBar = fileProgressBar;
        this.sendButton = sendButton;
        this.cancelButton = cancelButton;
        this.htmlPanel = htmlPanel;
        this.files = files;
        this.metaData = metaData;
        this.userDirectory = userDirectory;
        this.loggedUser = loggedUser;
        this.embargoDate = embargoDate;
    }

    private void publishDirectory(ClientPrimaryDataDirectory directory) {
        try {
            directory.switchCurrentVersion(directory.getCurrentVersion());
            directory.addPublicReference(PersistentIdentifier.DOI);
            directory.getCurrentVersion().setAllReferencesPublic(this.loggedUser, this.embargoDate);
        }
        catch (PrimaryDataEntityException | PrimaryDataEntityVersionException | PublicReferenceException | RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.storeFiles();
        return null;
    }

    @Override
    protected void done() {
        try {
            this.htmlPanel.setText(PublicationVeloCityCreater.generateFinishUploadPage());
        }
        catch (EdalException e) {
            e.printStackTrace();
        }
        ((ProgressBarDialog)SwingUtilities.getRoot(this.sendButton)).setDefaultCloseOperation(2);
        this.sendButton.setEnabled(true);
        this.sendButton.setText("Submit another dataset");
        this.cancelButton.setEnabled(true);
        this.cancelButton.setText("Quit");
        this.sendButton.removeActionListener(this.sendButton.getActionListeners()[0]);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(ProgressSwingWorker.this.sendButton)) {
                    SwingUtilities.getWindowAncestor(ProgressSwingWorker.this.sendButton).dispose();
                }
            }
        });
        this.cancelButton.removeActionListener(this.cancelButton.getActionListeners()[0]);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(null, "Close IPK Data Publication System ?", "EXIT", 0);
                if (result == 0) {
                    System.exit(0);
                }
            }
        });
    }

    private void storeFiles() {
        if (Files.isDirectory(this.files, new LinkOption[0])) {
            try {
                CountDownLatch latch = new CountDownLatch(this.overallProgressBar.getMaximum());
                PublicationDirectoryVisitorWithMetaDataRmi edalVisitor = new PublicationDirectoryVisitorWithMetaDataRmi(this.overallProgressBar, this.fileProgressBar, this.userDirectory, this.files, this.metaData, PublicationButtonLinePanel.updatePublicationFlag, true, latch);
                Files.walkFileTree(this.files, edalVisitor);
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.fileProgressBar.setValue(100);
                this.fileProgressBar.setString("100%");
                this.publishDirectory(edalVisitor.getRootDirectoryToPublish());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (PublicationButtonLinePanel.updatePublicationFlag) {
            ClientPrimaryDataDirectory directory = null;
            ClientPrimaryDataFile file = null;
            try {
                directory = (ClientPrimaryDataDirectory)this.userDirectory.getPrimaryDataEntity(this.metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString());
                this.setNewMetaData(directory, this.metaData);
                directory.switchCurrentVersion(directory.getCurrentVersion());
                file = directory.exist(this.files.toFile().getName()) ? (ClientPrimaryDataFile)directory.getPrimaryDataEntity(this.files.toFile().getName()) : directory.createPrimaryDataFile(this.files.toFile().getName());
            }
            catch (PrimaryDataDirectoryException | PrimaryDataEntityVersionException | MetaDataException | RemoteException e) {
                e.printStackTrace();
            }
            this.setNewMetaData(file, this.metaData);
            CountDownLatch latch = new CountDownLatch(1);
            FileStoreSwingWorker worker = new FileStoreSwingWorker(this.fileProgressBar, this.overallProgressBar, this.files, file, latch);
            worker.execute();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.fileProgressBar.setValue(100);
            this.fileProgressBar.setString("100%");
            this.publishDirectory(directory);
        } else {
            try {
                ClientPrimaryDataDirectory directory = this.userDirectory.createPrimaryDataDirectory(this.metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString());
                this.setNewMetaData(directory, this.metaData);
                ClientPrimaryDataFile file = directory.createPrimaryDataFile(this.files.toFile().getName());
                CountDownLatch latch = new CountDownLatch(1);
                FileStoreSwingWorker worker = new FileStoreSwingWorker(this.fileProgressBar, this.overallProgressBar, this.files, file, latch);
                worker.execute();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.fileProgressBar.setValue(100);
                this.fileProgressBar.setString("100%");
                this.publishDirectory(directory);
            }
            catch (PrimaryDataDirectoryException | MetaDataException | RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private void setNewMetaData(ClientPrimaryDataEntity clientPrimaryDataEntity, MetaData newMetaData) {
        try {
            MetaData metaData = clientPrimaryDataEntity.getMetaData().clone();
            metaData.setElementValue(EnumDublinCoreElements.CREATOR, newMetaData.getElementValue((Enum)EnumDublinCoreElements.CREATOR));
            metaData.setElementValue(EnumDublinCoreElements.CONTRIBUTOR, newMetaData.getElementValue((Enum)EnumDublinCoreElements.CONTRIBUTOR));
            metaData.setElementValue(EnumDublinCoreElements.SUBJECT, newMetaData.getElementValue((Enum)EnumDublinCoreElements.SUBJECT));
            metaData.setElementValue(EnumDublinCoreElements.LANGUAGE, newMetaData.getElementValue((Enum)EnumDublinCoreElements.LANGUAGE));
            metaData.setElementValue(EnumDublinCoreElements.DESCRIPTION, newMetaData.getElementValue((Enum)EnumDublinCoreElements.DESCRIPTION));
            metaData.setElementValue(EnumDublinCoreElements.PUBLISHER, newMetaData.getElementValue((Enum)EnumDublinCoreElements.PUBLISHER));
            metaData.setElementValue(EnumDublinCoreElements.RIGHTS, newMetaData.getElementValue((Enum)EnumDublinCoreElements.RIGHTS));
            clientPrimaryDataEntity.setMetaData(metaData);
        }
        catch (PrimaryDataEntityVersionException | MetaDataException | CloneNotSupportedException | RemoteException e) {
            e.printStackTrace();
        }
    }
}

