/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.DataManagerRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.interfaces.PrimaryDataDirectoryRmiInterface;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.ssl.EdalSslRmiClientSocketFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ClientDataManager {
    public static Logger logger = null;
    private static Subject subject;
    private static DataManagerRmiInterface dataManager;
    private static Map<Principal, List<GrantableMethods.Methods>> userPermissions;
    public static Map<Principal, List<GrantableMethods.Methods>> DEFAULT_PERMISSIONS;
    private final String serverAddress;
    private final int registryPort;
    private final Authentication auth;

    public static void init() {
    }

    public ClientDataManager(String serverAddress, int registryPort, Authentication authentication) throws EdalAuthenticateException {
        this.serverAddress = serverAddress;
        this.registryPort = registryPort;
        this.auth = authentication;
    }

    public MetaData createMetadataInstance() {
        MetaData metadata = null;
        try {
            metadata = dataManager.createMetaDataInstance();
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
        }
        return metadata;
    }

    public Authentication getAuthentication() {
        return this.auth;
    }

    public Long getAvailableStorageSpace() throws RemoteException, EdalException {
        return dataManager.getAvailableStorageSpace();
    }

    public Map<Principal, List<GrantableMethods.Methods>> getDefaultPermissions() {
        return userPermissions;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public ClientPrimaryDataDirectory getRootDirectory() throws RemoteException, NotBoundException, PrimaryDataDirectoryException, EdalException, EdalAuthenticateException {
        PropertyConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.properties"));
        logger = Logger.getLogger((String)"eDAL-Client");
        Registry registry = null;
        try {
            logger.info((Object)("Trying unsecure connection to '" + this.serverAddress + "'..."));
            registry = LocateRegistry.getRegistry(this.serverAddress, this.registryPort);
            dataManager = (DataManagerRmiInterface)registry.lookup("DataManager");
            PropertyConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.properties"));
            logger = Logger.getLogger((String)"eDAL-Client");
            logger.info((Object)"Unsecure connection successful !");
        }
        catch (ConnectException | ConnectIOException e) {
            logger.info((Object)"Unsecure Connection failed !");
            logger.info((Object)("Trying SSL Connection to '" + this.serverAddress + "'..."));
            registry = LocateRegistry.getRegistry(this.serverAddress, this.registryPort, (RMIClientSocketFactory)new EdalSslRmiClientSocketFactory(EdalConfiguration.KEY_STORE_PATH));
            dataManager = (DataManagerRmiInterface)registry.lookup("DataManager");
            PropertyConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.properties"));
            logger = Logger.getLogger((String)"eDAL-Client");
            logger.info((Object)"Secure connection successful !");
        }
        subject = dataManager.authenticate(this.auth);
        PrimaryDataDirectoryRmiInterface rootDirectory = dataManager.getRootDirectory(subject);
        userPermissions = dataManager.getDefaultPermissions();
        DEFAULT_PERMISSIONS = dataManager.getDefaultPermissions();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String testString = "E!DAL";
        try {
            this.testReadingFromServer(testString, byteArrayOutputStream);
        }
        catch (IOException e) {
            logger.info((Object)"Test Reading from Server : failed");
        }
        if (byteArrayOutputStream.toString().equals(testString)) {
            logger.info((Object)"Test Reading from Server : successful");
        } else {
            logger.info((Object)"Test Storing to Server : successful");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(testString.getBytes());
        try {
            this.testStoringOnServer("test.txt", byteArrayInputStream);
        }
        catch (IOException e) {
            logger.info((Object)"Test Storing to Server : failed");
        }
        if (byteArrayInputStream.read() == -1) {
            logger.info((Object)"Test Storing to Server : successful");
        } else {
            logger.info((Object)"Test Storing to Server : successful");
        }
        return new ClientPrimaryDataDirectory(rootDirectory, this);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    protected Subject getSubject() {
        Subject ret = subject;
        if (ret == null) {
            logger.error((Object)"current subject is null");
        }
        return ret;
    }

    public List<Class<? extends Principal>> getSupportedPrincipals() throws RemoteException, EdalException {
        return dataManager.getSupportedPrincipals();
    }

    public Long getUsedStorageSpace() throws RemoteException, EdalException {
        return dataManager.getUsedStorageSpace();
    }

    public void resetDefaultPermissions() {
        userPermissions = DEFAULT_PERMISSIONS;
    }

    public void setDefaultPermissions(Map<Principal, List<GrantableMethods.Methods>> permissions) {
        userPermissions = permissions;
    }

    public void testReadingFromServer(String fileName, OutputStream outputStream) throws IOException {
        InputStream inStream = RemoteInputStreamClient.wrap((RemoteInputStream)dataManager.sendFileToClient(fileName));
        IOUtils.copy((InputStream)inStream, (OutputStream)outputStream);
        inStream.close();
        outputStream.close();
    }

    public void testStoringOnServer(String fileName, InputStream inputStream) throws IOException {
        OutputStream outStream = RemoteOutputStreamClient.wrap((RemoteOutputStream)dataManager.sendOutputStreamToFillFromClient(fileName));
        IOUtils.copy((InputStream)inputStream, (OutputStream)outStream);
        inputStream.close();
        outStream.close();
    }

    static {
        PropertyConfigurator.configure((URL)ClientDataManager.class.getResource("log4j.properties"));
        logger = Logger.getLogger((String)"eDAL-Client");
        subject = null;
        dataManager = null;
        DEFAULT_PERMISSIONS = new HashMap<Principal, List<GrantableMethods.Methods>>();
    }
}

