/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class EdalConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public int returnvalue;
    public static ClientDataManager client;
    public static ClientPrimaryDataDirectory rootDirectory;
    private boolean islogin = false;
    private JPanel detialpanel = new JPanel();
    private JButton savebtn;
    private JButton cancelbtn;
    private JLabel infolabel;
    private Action okAction = new AbstractAction("Save"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalConfigDialog.this.infolabel.setText("");
            if (!EdalConfigDialog.this.checkerror()) {
                return;
            }
            if (EdalConfigDialog.this.loginremoteserver(EdalConfigDialog.this.getServeraddress(), EdalConfigDialog.this.getServerport(), EdalConfigDialog.this.getUsername(), EdalConfigDialog.this.getPassword())) {
                EdalConfigDialog.this.returnvalue = 0;
                EdalConfigDialog.this.dispose();
            }
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalConfigDialog.this.returnvalue = 1;
            EdalConfigDialog.this.dispose();
        }
    };
    private JLabel serveraddresslabel;
    private JTextField serveraddresstxt;
    private JLabel serverportlabel;
    private JLabel serverdatgaportlabel;
    private JTextField serverporttxt;
    private JTextField serverdataporttxt;
    private JLabel serverusernamelabel;
    private JTextField serverusernametxt;
    private JLabel serverpasswordlabel;
    private JTextField serverpasswordtxt;

    public EdalConfigDialog() {
        this.addWindowListener(this.createAppCloser());
        this.setTitle(" Configuration");
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        this.detialpanel.setLayout((LayoutManager)new MigLayout("", "[100!][90%!]", ""));
        this.serveraddresslabel = new JLabel("Server Address:");
        this.detialpanel.add(this.serveraddresslabel);
        this.serveraddresstxt = new JTextField();
        this.detialpanel.add((Component)this.serveraddresstxt, "wrap,width max(70%, 70%)");
        this.serverportlabel = new JLabel("Server Port:");
        this.detialpanel.add(this.serverportlabel);
        this.serverporttxt = new JTextField();
        this.detialpanel.add((Component)this.serverporttxt, "wrap,width max(70%, 70%)");
        this.serverdatgaportlabel = new JLabel("Server Dataport:");
        this.detialpanel.add(this.serverdatgaportlabel);
        this.serverdataporttxt = new JTextField();
        this.detialpanel.add((Component)this.serverdataporttxt, "wrap,width max(70%, 70%)");
        this.serverusernamelabel = new JLabel("User Name:");
        this.detialpanel.add(this.serverusernamelabel);
        this.serverusernametxt = new JTextField();
        this.detialpanel.add((Component)this.serverusernametxt, "wrap,width max(70%, 70%)");
        this.serverpasswordlabel = new JLabel("Password:");
        this.detialpanel.add(this.serverpasswordlabel);
        this.serverpasswordtxt = new JPasswordField();
        this.detialpanel.add((Component)this.serverpasswordtxt, "wrap,width max(70%, 70%)");
        this.infolabel = new JLabel("");
        this.infolabel.setForeground(Color.RED);
        this.detialpanel.add((Component)this.infolabel, "width max(80%, 80%)");
        contents.add((Component)this.detialpanel, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(400, 247));
        this.setMinimumSize(new Dimension(400, 247));
    }

    private boolean checkerror() {
        String serveraddresstxtText = this.serveraddresstxt.getText();
        if (serveraddresstxtText.trim().length() == 0) {
            this.mustfill(this.serveraddresslabel);
            JOptionPane.showMessageDialog(null, "Please input Server Address!", " Configuration", 0);
            return false;
        }
        this.resetfill(this.serveraddresslabel);
        String serverporttxtText = this.serverporttxt.getText();
        if (serverporttxtText.trim().length() == 0) {
            this.mustfill(this.serverportlabel);
            JOptionPane.showMessageDialog(null, "Please input Server Port!", " Configuration", 0);
            return false;
        }
        this.resetfill(this.serverportlabel);
        try {
            Integer.parseInt(serverporttxtText.trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Server Port should be Integer!", " Configuration", 0);
            return false;
        }
        String serverusernametxtText = this.serverusernametxt.getText();
        if (serverusernametxtText.trim().length() == 0) {
            this.mustfill(this.serverusernamelabel);
            JOptionPane.showMessageDialog(null, "Please input User Name!", " Configuration", 0);
            return false;
        }
        this.resetfill(this.serverusernamelabel);
        String serverpasswordtxtText = this.serverpasswordtxt.getText();
        if (serverpasswordtxtText.trim().length() == 0) {
            this.mustfill(this.serverpasswordlabel);
            JOptionPane.showMessageDialog(null, "Please input Password!", " Configuration", 0);
            return false;
        }
        this.resetfill(this.serverpasswordlabel);
        return true;
    }

    private WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                EdalConfigDialog.this.returnvalue = 1;
                EdalConfigDialog.this.dispose();
            }
        };
    }

    private JPanel createbuttonpanel() {
        this.savebtn = new JButton(this.okAction);
        this.cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(this.savebtn);
        buttonPane.add(this.cancelbtn);
        this.getRootPane().setDefaultButton(this.savebtn);
        return buttonPane;
    }

    public String getPassword() {
        return this.serverpasswordtxt.getText().trim();
    }

    public String getServeraddress() {
        return this.serveraddresstxt.getText().trim();
    }

    public int getServerport() {
        return Integer.parseInt(this.serverporttxt.getText().trim());
    }

    public String getUsername() {
        return this.serverusernametxt.getText().trim();
    }

    private boolean loginremoteserver(String serveraddress, int serverport, String username, String password) {
        try {
            Authentication auth = new Authentication(EdalHelpers.authenticateUser((String)username, (String)password));
            client = new ClientDataManager(serveraddress, serverport, auth);
            rootDirectory = client.getRootDirectory();
            this.islogin = true;
        }
        catch (Exception e) {
            this.islogin = false;
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            this.infolabel.setText(e.getMessage());
        }
        return this.islogin;
    }

    private void mustfill(JLabel label) {
        label.setForeground(Color.RED);
        label.setText("*" + label.getText());
    }

    private void resetfill(JLabel label) {
        label.setForeground(Color.BLACK);
        String originaltext = label.getText();
        if (originaltext.startsWith("*")) {
            originaltext = originaltext.substring(1);
        }
        label.setText(originaltext);
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }
}

