/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ErrorDialog
extends JDialog {
    private static final long serialVersionUID = -4967851274829031411L;
    private static final String SHOW_DETAILS_TEXT = "Show Details ...";
    private static final String HIDE_DETAILS_TEXT = "Hide Details";
    private JButton jButtonClose;
    private JButton jButtonShowHideDetails;
    private JPanel jPanelBottom;
    private JPanel jPanelCenter;
    private JPanel jPanelTop;
    private JScrollPane jScrollPaneErrorMsg;
    private JTextPane jTextPaneErrorMsg;
    private JScrollPane jScrollPaneException;
    private JTextArea jTextAreaException;

    public ErrorDialog(String errorMessage) {
        this(errorMessage, null);
    }

    private static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public ErrorDialog(String errorMessage, Throwable exception) {
        this.setIconImage(ErrorDialog.iconToImage(UIManager.getLookAndFeel().getDefaults().getIcon("OptionPane.errorIcon")));
        this.setTitle("Error");
        this.setModal(true);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 200));
        this.jPanelTop = new JPanel();
        this.jPanelTop.setLayout(new BorderLayout());
        this.jPanelTop.setPreferredSize(new Dimension(500, 80));
        this.jPanelTop.setBorder(null);
        this.jTextPaneErrorMsg = new JTextPane();
        this.jTextPaneErrorMsg.setEditable(false);
        this.jTextPaneErrorMsg.setContentType("text/html");
        this.jTextPaneErrorMsg.setBorder(null);
        this.jScrollPaneErrorMsg = new JScrollPane(this.jTextPaneErrorMsg);
        this.jScrollPaneErrorMsg.setBorder(null);
        this.jPanelTop.add((Component)this.jScrollPaneErrorMsg, "Center");
        this.jPanelCenter = new JPanel(new BorderLayout());
        this.jPanelCenter.setPreferredSize(new Dimension(500, 120));
        this.jTextAreaException = new JTextArea();
        this.jScrollPaneException = new JScrollPane(this.jTextAreaException);
        this.jPanelCenter.add(this.jScrollPaneException);
        this.jPanelBottom = new JPanel(new FlowLayout(1));
        this.jButtonShowHideDetails = new JButton();
        this.jButtonClose = new JButton("Close");
        this.jButtonShowHideDetails.setText(SHOW_DETAILS_TEXT);
        this.jButtonShowHideDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.showHideExceptionDetails();
            }
        });
        this.jPanelBottom.add(this.jButtonShowHideDetails);
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorDialog.this.dispose();
            }
        });
        this.jPanelBottom.add(this.jButtonClose);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanelTop, "North");
        this.add((Component)this.jPanelCenter, "Center");
        this.add((Component)this.jPanelBottom, "South");
        Color color = UIManager.getColor("Panel.background");
        this.jTextPaneErrorMsg.setText("<html><body bgcolor='rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")'><p/><div style='text-align:center;font-family:Arial'>" + errorMessage + "</div></body></html>");
        this.jPanelCenter.setVisible(false);
        if (exception != null) {
            String exceptionText = this.getStackTraceAsString(exception);
            this.jTextAreaException.setText(exceptionText);
            this.jTextAreaException.setEditable(false);
            this.jTextAreaException.setCaretPosition(0);
        } else {
            this.jButtonShowHideDetails.setVisible(false);
        }
        this.registerEscapeKey();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.pack();
        this.centerDialogOnTheScreen();
    }

    private void centerDialogOnTheScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        int centerPosX = (screenSize.width - dialogSize.width) / 2;
        int centerPosY = (screenSize.height - dialogSize.height) / 2;
        this.setLocation(centerPosX, centerPosY);
    }

    private void showHideExceptionDetails() {
        if (this.jPanelCenter.isVisible()) {
            this.jButtonShowHideDetails.setText(SHOW_DETAILS_TEXT);
            this.jPanelCenter.setVisible(false);
            this.pack();
            this.centerDialogOnTheScreen();
        } else {
            this.jButtonShowHideDetails.setText(HIDE_DETAILS_TEXT);
            this.jPanelCenter.setVisible(true);
            this.pack();
            this.centerDialogOnTheScreen();
        }
    }

    private String getStackTraceAsString(Throwable exception) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public void registerEscapeKey() {
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.jButtonClose.doClick();
            }
        };
        this.rootPane.getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", escapeAction);
    }

    public void hideAndDisposeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private static void showError(String errorMessage, Throwable throwable) {
        ErrorDialog errorDialog = new ErrorDialog(errorMessage, throwable);
        errorDialog.setVisible(true);
    }

    private static void showError(String errorMessage) {
        ErrorDialog.showError(errorMessage, null);
    }

    public static void showError(Exception exception) {
        ErrorDialog.showError(exception.getMessage(), exception);
    }

    public static void main(String[] args) {
        ErrorDialog.showError("This is an error message.", new Exception());
    }
}

