/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalMutableTreeModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalNode;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalFileHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;

public class TreeWillExpandListenerAction
implements TreeWillExpandListener {
    private final JTree tree;
    private final ClientPrimaryDataDirectory rootDirectory;

    public TreeWillExpandListenerAction(JTree tree, ClientPrimaryDataDirectory rootDirectory) {
        this.tree = tree;
        this.rootDirectory = rootDirectory;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        this.tree.scrollPathToVisible(e.getPath());
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        EdalNode mynodeobj = (EdalNode)node.getUserObject();
        try {
            node.removeAllChildren();
            ClientPrimaryDataDirectory curdir = (ClientPrimaryDataDirectory)EdalFileHelper.getEntity(mynodeobj.getPath(), this.rootDirectory);
            HashMap<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();
            if (curdir.isDirectory()) {
                List<ClientPrimaryDataEntity> dirlist = curdir.listPrimaryDataEntities();
                ArrayList<String> dirnamelist = new ArrayList<String>();
                if (dirlist != null) {
                    for (ClientPrimaryDataEntity dir : dirlist) {
                        if (!dir.isDirectory() || dir.getCurrentVersion().isDeleted()) continue;
                        dirnamelist.add(dir.getName());
                        dirnamemap.put(dir.getName(), dir);
                    }
                }
                Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);
                for (String dirname : dirnamelist) {
                    EdalMutableTreeModel child = new EdalMutableTreeModel(new EdalNode(dirname, ((ClientPrimaryDataDirectory)dirnamemap.get(dirname)).getPath()));
                    node.add(child);
                }
            }
            this.tree.scrollPathToVisible(e.getPath());
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        catch (PrimaryDataDirectoryException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError((Exception)((Object)e1));
        }
        catch (NotBoundException e1) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        catch (AccessControlException e1) {
            ErrorDialog.showError(e1);
        }
    }
}

