/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.aspectj.security.GrantableMethods;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PrincipalUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PermissionNewuserDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private JButton savebtn;
    private JButton cancelbtn;
    public int returnvalue;
    private ClientPrimaryDataEntity dataentry = null;
    private ClientDataManager client;
    private List<GrantableMethods.Methods> allavailablemethods = new ArrayList<GrantableMethods.Methods>();
    private List<String> principals = new ArrayList<String>();
    private List<Class<? extends Principal>> supportedprincipals;
    private JTextField usertext = new JTextField();
    private JComboBox<String> principalcomboBox;
    private Principal principal;
    private Action okAction = new AbstractAction("Ok"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionNewuserDialog.this.assignpermission();
            PermissionNewuserDialog.this.returnvalue = 0;
            PermissionNewuserDialog.this.dispose();
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionNewuserDialog.this.returnvalue = 1;
            PermissionNewuserDialog.this.dispose();
        }
    };

    public PermissionNewuserDialog(ClientPrimaryDataEntity dataentry, ClientDataManager client) {
        this.dataentry = dataentry;
        this.client = client;
        this.loadconstants();
        this.setTitle("Add NewUser");
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel userselectpanel = new JPanel();
        userselectpanel.setLayout(new FlowLayout(1, 10, 15));
        JLabel principallabel = new JLabel("UserName:", 0);
        userselectpanel.add(principallabel);
        this.usertext.setPreferredSize(new Dimension(240, 28));
        userselectpanel.add(this.usertext);
        this.principalcomboBox = new JComboBox();
        this.principalcomboBox.setName("principal");
        for (Class<? extends Principal> obj : this.supportedprincipals) {
            this.principalcomboBox.addItem(obj.getSimpleName());
            this.principals.add(obj.getName());
        }
        this.principalcomboBox.addItemListener(new ItemChangeListener());
        userselectpanel.add(this.principalcomboBox);
        JPanel editPane = new JPanel();
        editPane.setLayout(new BorderLayout());
        editPane.add((Component)userselectpanel, "North");
        contents.add((Component)editPane, "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setSize(new Dimension(600, 120));
        this.setResizable(false);
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    private void loadconstants() {
        try {
            if (this.dataentry != null) {
                List keysets;
                List commonskeysets = GrantableMethods.ENTITY_METHODS;
                for (GrantableMethods.Methods m : commonskeysets) {
                    this.allavailablemethods.add(m);
                }
                if (this.dataentry.isDirectory()) {
                    keysets = GrantableMethods.DIRECTORY_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                } else {
                    keysets = GrantableMethods.FILE_METHODS;
                    for (GrantableMethods.Methods m : keysets) {
                        this.allavailablemethods.add(m);
                    }
                }
            }
            this.supportedprincipals = this.client.getSupportedPrincipals();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        catch (EdalException e) {
            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError((Exception)((Object)e));
        }
    }

    private JPanel createbuttonpanel() {
        this.savebtn = new JButton(this.okAction);
        this.cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(this.savebtn);
        buttonPane.add(this.cancelbtn);
        return buttonPane;
    }

    private void assignpermission() {
        String currentuser = this.usertext.getText().trim();
        if (currentuser.length() == 0) {
            JOptionPane.showMessageDialog(null, "Please Input UserName!", "EdalFileChooser", 0);
            return;
        }
        String currentprincipalname = this.principals.get(this.principalcomboBox.getSelectedIndex());
        this.principal = PrincipalUtil.getInstance(currentprincipalname, currentuser);
        JOptionPane.showMessageDialog(null, "we created a new user:" + currentuser + "!", "EdalFileChooser", 1);
    }

    private class ItemChangeListener
    implements ItemListener {
        private ItemChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                Object item = event.getItem();
                if ("ALLPrincipal".equals(item.toString())) {
                    PermissionNewuserDialog.this.usertext.setText("ALL");
                    PermissionNewuserDialog.this.usertext.setEditable(false);
                } else {
                    PermissionNewuserDialog.this.usertext.setText("");
                    PermissionNewuserDialog.this.usertext.setEditable(true);
                }
            }
        }
    }
}

