/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalFileChooser;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataSaveDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MetadataModify {
    public static JFrame frame;
    private static ClientPrimaryDataEntity[] files;
    private static Map<EnumDublinCoreElements, UntypedData> metadatavalue;
    private static String serveraddress;
    private static int serverport;
    static Action openfileAction;
    static Action openmetadataAction;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:    de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui.Main option(s)");
            System.out.println("Options:    the first parameter is servername, the second parametr is serverport");
            System.exit(-1);
        } else {
            serveraddress = args[0].trim();
            UIManager.LookAndFeelInfo[] sport = args[1].trim();
            try {
                serverport = Integer.parseInt((String)sport);
            }
            catch (Exception e) {
                System.out.println("Usage:    de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui.Main option(s)");
                System.out.println("Options:    the first parameter is servername, the second parametr is serverport");
                System.exit(-1);
            }
        }
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!laf.getName().equals("Nimbus")) continue;
            try {
                UIManager.setLookAndFeel(laf.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
        frame = new JFrame("MetadataDemo");
        JPanel pane = new JPanel();
        pane.add(new JButton(openfileAction));
        pane.add(new JButton(openmetadataAction));
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)pane, "Center");
        frame.setSize(600, 300);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    static /* synthetic */ ClientPrimaryDataEntity[] access$202(ClientPrimaryDataEntity[] x0) {
        files = x0;
        return x0;
    }

    static {
        serveraddress = null;
        serverport = 0;
        openfileAction = new AbstractAction("Open EDAL File"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = frame.getContentPane() instanceof Window ? (Window)frame.getContentPane() : SwingUtilities.getWindowAncestor(frame.getContentPane());
                try {
                    Authentication auth = new Authentication(EdalHelpers.authenticateSampleUser());
                    ClientDataManager client = new ClientDataManager(serveraddress, serverport, auth);
                    EdalFileChooser dlg = window instanceof Frame ? new EdalFileChooser((Frame)window, client) : new EdalFileChooser((Dialog)window, client);
                    dlg.setMultiSelectionEnabled(false);
                    dlg.setFileSelectionMode(2);
                    int returnVal = dlg.showOpenDialog();
                    if (returnVal == 0) {
                        MetadataModify.access$202(dlg.getSelectedFiles());
                    }
                }
                catch (EdalAuthenticateException e1) {
                    ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                    ErrorDialog.showError((Exception)((Object)e1));
                }
            }
        };
        openmetadataAction = new AbstractAction("Show Metadata"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (files != null) {
                    for (ClientPrimaryDataEntity file : files) {
                        try {
                            if (file.isDirectory()) {
                                continue;
                            }
                        }
                        catch (RemoteException e1) {
                            ClientDataManager.logger.error((Object)StackTraceUtil.getStackTrace(e1));
                            ErrorDialog.showError(e1);
                        }
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(file);
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal != 0) continue;
                        metadatavalue = metadlg.getMetaDataValues();
                        System.out.println(metadatavalue);
                    }
                }
            }
        };
    }
}

