/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.sample;

import de.ipk_gatersleben.bit.bi.edal.webdav.sample.Main;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ClientStarter {
    private static int DEFAULT_EDAL_PORT = 2000;
    private static String DEFAULT_EDAL_HOST = "localhost";
    private static int WEBDAV_PORT = 8080;

    public static void main(String[] args) {
        String[] argm;
        Options options = new Options();
        System.out.println("e!DAL client application\nIPK-Gatersleben.\nAll rights reserved.\n");
        options.addOption("h", "help", false, "print help");
        options.addOption("w", "webdav", false, "start WebDAV ");
        options.addOption("g", "gui", false, "start FileChooser GUI ");
        options.addOption("p", "server_port", true, "set port for e!DAL server (default=" + DEFAULT_EDAL_PORT + ")");
        options.addOption("d", "webdav_port", true, "set port for WebDAV server (default=" + WEBDAV_PORT + ")");
        options.addOption("s", "server_host", true, "set host for e!DAL server (default=" + DEFAULT_EDAL_HOST + ")");
        HelpFormatter form = new HelpFormatter();
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (cmd.hasOption("h")) {
            form.printHelp("-h", options);
            System.exit(0);
        }
        if (cmd.hasOption("s")) {
            DEFAULT_EDAL_HOST = cmd.getOptionValue("s");
        }
        if (cmd.hasOption("p")) {
            try {
                DEFAULT_EDAL_PORT = Integer.parseInt(cmd.getOptionValue("p"));
            }
            catch (NumberFormatException e) {
                System.out.println("Please enter a number for e!DAL server port");
                System.exit(0);
            }
        }
        if (cmd.hasOption("d")) {
            try {
                WEBDAV_PORT = Integer.parseInt(cmd.getOptionValue("d"));
            }
            catch (NumberFormatException e) {
                System.out.println("Please enter a number for WebDAV port");
                System.exit(0);
            }
        }
        if (cmd.hasOption("w")) {
            argm = new String[]{"-p" + String.valueOf(DEFAULT_EDAL_PORT), "-s" + DEFAULT_EDAL_HOST, "-d" + String.valueOf(WEBDAV_PORT)};
            Main.main(argm);
        } else if (cmd.hasOption("g")) {
            argm = new String[]{DEFAULT_EDAL_HOST, String.valueOf(DEFAULT_EDAL_PORT)};
            de.ipk_gatersleben.bit.bi.edal.rmi.sample.gui.Main.main(argm);
        } else {
            System.out.println("Please set -w to start WebDAV or -g to start FileChooser GUI");
            System.exit(0);
        }
    }
}

