/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FileSystemHandler {
    public static String VIRTUALVERSIONFOLDERPREFIX = ".versions";
    public static String VIRTUALFILEPREFIX = "!";
    public static String VIRTUALFOLDERPREFIX = "+";
    public static String HOST;
    public static int REGISTRY_PORT;
    public static int DATA_PORT;
    private ClientPrimaryDataDirectory rootDirectory;
    private Map<String, ClientPrimaryDataEntity> innermap = new HashMap<String, ClientPrimaryDataEntity>();

    public FileSystemHandler(ClientPrimaryDataDirectory rootDirectory) throws RemoteException, NotBoundException, PrimaryDataDirectoryException, EdalAuthenticateException, EdalException {
        this.rootDirectory = rootDirectory;
    }

    public void removecache(String path) {
        if (path != null && path.length() > 1) {
            this.innermap.remove(path.substring(1));
        }
    }

    public ClientPrimaryDataEntity getEntity(String path) throws RemoteException, PrimaryDataDirectoryException {
        if (path.equals("/")) {
            return this.rootDirectory;
        }
        String[] dirs = path.split("\\/");
        String tmpPath = "";
        ClientPrimaryDataDirectory dir = this.rootDirectory;
        ClientPrimaryDataEntity entity = dir;
        if (dirs.length > 1) {
            for (int i = 1; i < dirs.length; ++i) {
                if (dirs[i].isEmpty()) continue;
                ClientPrimaryDataEntity cacheobj = this.innermap.get(tmpPath = tmpPath + "/" + dirs[i]);
                if (cacheobj != null) {
                    entity = cacheobj;
                    if (entity.isDirectory()) {
                        dir = (ClientPrimaryDataDirectory)entity;
                        continue;
                    }
                    if (tmpPath.compareTo(path) != 0) continue;
                    return entity;
                }
                if (dir.exist(dirs[i])) {
                    entity = dir.getPrimaryDataEntity(dirs[i]);
                    if (entity.isDirectory()) {
                        this.innermap.put(tmpPath, entity);
                        dir = (ClientPrimaryDataDirectory)entity;
                        continue;
                    }
                    if (i == dirs.length - 2) {
                        if (dirs[i].equals(dirs[i + 1])) {
                            return entity;
                        }
                        return null;
                    }
                    return entity;
                }
                return null;
            }
            if (tmpPath.compareTo(path) == 0 || path.compareTo(entity.getPath()) == 0 || tmpPath.compareTo(entity.getPath().substring(1)) == 0) {
                return entity;
            }
            return null;
        }
        return dir;
    }

    public static ClientPrimaryDataEntityVersion getVersion(ClientPrimaryDataEntity entity, long version) throws RemoteException {
        for (ClientPrimaryDataEntityVersion curr : entity.getVersions()) {
            if (curr.getRevision() != version) continue;
            return curr;
        }
        return null;
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(FileSystemHandler.class.getResourceAsStream("/eDALwebDAV.properties"));
            if (System.getProperty("edalhost") == null) {
                HOST = prop.getProperty("server.host");
                ClientDataManager.logger.info((Object)("eDAL-Host = " + HOST));
            } else {
                HOST = System.getProperty("edalhost");
                ClientDataManager.logger.info((Object)("eDAL-Host = " + HOST));
            }
            if (System.getProperty("edalport") == null) {
                REGISTRY_PORT = Integer.parseInt(prop.getProperty("server.port"));
                ClientDataManager.logger.info((Object)("eDAL-Port = " + REGISTRY_PORT));
            } else {
                REGISTRY_PORT = Integer.parseInt(System.getProperty("edalport"));
                ClientDataManager.logger.info((Object)("eDAL-Port = " + REGISTRY_PORT));
            }
            if (System.getProperty("edaldport") == null) {
                DATA_PORT = Integer.parseInt(prop.getProperty("server.dport"));
                ClientDataManager.logger.info((Object)("eDAL-Data-Port = " + DATA_PORT));
            } else {
                DATA_PORT = Integer.parseInt(System.getProperty("edaldport"));
                ClientDataManager.logger.info((Object)("eDAL-Data-Port = " + DATA_PORT));
            }
        }
        catch (IOException e) {
            ClientDataManager.logger.fatal((Object)"error loading FileSystemHandler properties", (Throwable)e);
            System.exit(-1);
        }
    }
}

