/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;

public class ExtXMLConfig {
    private JAXBContext context;
    private Marshaller m;
    private Unmarshaller um;
    private Schema schema = null;

    public ExtXMLConfig(Class<?> rootClass) throws JAXBException {
        this.context = JAXBContext.newInstance((Class[])new Class[]{rootClass});
        this.init();
    }

    public ExtXMLConfig(String classPath) throws JAXBException {
        this.context = JAXBContext.newInstance((String)classPath);
        this.init();
    }

    public Object load(File xml) {
        this.um.setSchema(this.schema);
        if (xml.exists() && xml.isFile()) {
            try {
                return this.um.unmarshal(xml);
            }
            catch (JAXBException e) {
                ClientDataManager.logger.error((Object)("Failed to load file: " + xml + "\nReason: " + e.toString()));
            }
        } else {
            ClientDataManager.logger.error((Object)("Failed to open file: " + xml + "\nReason: " + "file doesn't exists or is not a file."));
        }
        return null;
    }

    public Object load(InputStream inputStream) {
        this.um.setSchema(this.schema);
        try {
            return this.um.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to load xml from stream: " + e.toString()));
            return null;
        }
    }

    public Object load(String fileInput) {
        this.um.setSchema(this.schema);
        try {
            return this.um.unmarshal((Reader)new StringReader(fileInput));
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to load xml from string: " + fileInput + "\nReason: " + e.toString()));
            return null;
        }
    }

    public void save(Object xml, String file) {
        this.save(xml, new File(file));
    }

    public void save(Object xml, File file) {
        this.m.setSchema(this.schema);
        try {
            this.m.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (PropertyException e1) {
            ClientDataManager.logger.error((Object)("Failed to set formated output property: \nReason: " + e1.toString()));
        }
        if (!file.isDirectory()) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                this.m.marshal(xml, file);
            }
            catch (JAXBException e) {
                ClientDataManager.logger.error((Object)("Failed to save file: " + file + "\nReason: " + e.toString()));
            }
            catch (IOException e) {
                ClientDataManager.logger.error((Object)("Failed to save file: " + file + "\nReason: " + e.toString()));
            }
        }
    }

    public String toString(Object xml) {
        StringWriter out = new StringWriter();
        try {
            this.m.setSchema(this.schema);
            this.m.marshal(xml, (Writer)out);
            return out.toString();
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to generate String representation for: " + xml + "\nReason: " + e.toString()));
            return null;
        }
    }

    private void init() throws JAXBException {
        this.m = this.context.createMarshaller();
        this.m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.m.setProperty("jaxb.encoding", (Object)"UTF-8");
        this.um = this.context.createUnmarshaller();
    }
}

