/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.publication.IpkAuthenticationProcess;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemCache;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.resource.PropFindableResource;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PrimaryDataEntityResource
implements PropFindableResource {
    protected ClientPrimaryDataEntity entity;
    protected FileSystemHandler fileSystemHandler;
    protected String path;
    protected String username = "";

    public PrimaryDataEntityResource(String path, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException {
        this.path = path;
        if (fileSystemHandler != null) {
            this.fileSystemHandler = fileSystemHandler;
            this.entity = fileSystemHandler.getEntity(path);
        }
    }

    public boolean exists() {
        return this.entity != null;
    }

    public boolean isDirectory() {
        try {
            return this.entity.isDirectory();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)e.toString());
            return false;
        }
    }

    public ClientPrimaryDataEntity getEntity() {
        return this.entity;
    }

    public Object authenticate(String user, String password) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("user", user);
        info.put("password", password);
        return info;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (auth == null || auth.getTag() == null) {
            return false;
        }
        Map info = (Map)auth.getTag();
        this.username = (String)info.get("user");
        if (FileSystemCache.get(this.username) != null) {
            return true;
        }
        try {
            Authentication authentication = new Authentication(new IpkAuthenticationProcess().getSubject());
            ClientDataManager myClient = new ClientDataManager(FileSystemHandler.HOST, FileSystemHandler.REGISTRY_PORT, authentication);
            ClientPrimaryDataDirectory rootDirectory = myClient.getRootDirectory();
            this.fileSystemHandler = new FileSystemHandler(rootDirectory);
            FileSystemCache.put(this.username, this.fileSystemHandler);
            this.entity = this.fileSystemHandler.getEntity(this.path);
            return true;
        }
        catch (RemoteException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        catch (EdalException e) {
            ClientDataManager.logger.fatal((Object)("Failed to load/initialize FileSystemHandler: " + e.getMessage()));
        }
        return false;
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public Date getModifiedDate() {
        try {
            return this.getEntity().getCurrentVersion().getRevisionDate().getTime();
        }
        catch (Exception e) {
            ClientDataManager.logger.error((Object)("Failed to get modified date :" + e.toString()));
            return null;
        }
    }

    public String getName() {
        if (this.getEntity() != null) {
            try {
                return this.getEntity().getName();
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to get name: " + e.toString()));
            }
        }
        return null;
    }

    public String getRealm() {
        if (this.getEntity() != null) {
            try {
                return this.getEntity().getID();
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to get ID: " + e.toString()));
            }
        }
        return null;
    }

    public String getUniqueId() {
        if (this.getEntity() != null) {
            try {
                return this.getEntity().getID();
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error((Object)("Failed to get ID: " + e.toString()));
            }
        }
        return null;
    }

    public Date getCreateDate() {
        try {
            return this.getEntity().getCurrentVersion().getCreationDate().getTime();
        }
        catch (Exception e) {
            ClientDataManager.logger.error((Object)("Failed to get create date: " + e.toString()));
            return null;
        }
    }
}

