/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.FileSystemHandler;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.ExtXMLConfig;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.metadata.Property;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataDirectoryResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataDirectoryVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityPropertyVirtualResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataEntityResource;
import de.ipk_gatersleben.bit.bi.edal.webdav.wrapper.primary_data.PrimaryDataFileDirectoryVirtualResource;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.PutableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class PrimaryDataVersionDirectoryVirtualResource
extends PrimaryDataEntityResource
implements CollectionResource,
PutableResource {
    private ClientPrimaryDataDirectory dir;

    public PrimaryDataVersionDirectoryVirtualResource(String path, FileSystemHandler fileSystemHandler) throws RemoteException, PrimaryDataDirectoryException, NotBoundException, EdalAuthenticateException {
        super(path, fileSystemHandler);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
    }

    public ClientPrimaryDataDirectory getDir() {
        return this.dir;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean b = super.authorise(request, method, auth);
        if (this.entity != null) {
            this.dir = (ClientPrimaryDataDirectory)this.entity;
        }
        return b;
    }

    @Override
    public String getName() {
        return FileSystemHandler.VIRTUALVERSIONFOLDERPREFIX;
    }

    public Resource child(String childName) {
        try {
            if (this.dir.exist(childName)) {
                PrimaryDataEntityResource child = new PrimaryDataEntityResource(this.dir.getPrimaryDataEntity(childName).getPath(), this.fileSystemHandler);
                if (child.isDirectory()) {
                    return (PrimaryDataDirectoryResource)child;
                }
                Pattern property = Pattern.compile(".*\\.v[0-9]+\\.?[^\\.]*\\.properties\\.xml$");
                Matcher pm = property.matcher(childName);
                if (!pm.matches()) {
                    return new PrimaryDataFileDirectoryVirtualResource(this.entity.getPath(), this.fileSystemHandler);
                }
                return new PrimaryDataEntityPropertyVirtualResource(this.entity.getCurrentVersion(), this.entity.getCurrentVersion().getRevision());
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to get resource for: " + childName + "\nReason: " + e.toString()));
        }
        return null;
    }

    public List<? extends Resource> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            List<ClientPrimaryDataEntity> lis = this.dir.listPrimaryDataEntities();
            for (ClientPrimaryDataEntity ent : lis) {
                if (!ent.isDirectory()) {
                    children.add(new PrimaryDataFileDirectoryVirtualResource(ent.getPath(), this.fileSystemHandler));
                    continue;
                }
                children.add(new PrimaryDataDirectoryVirtualResource(ent.getPath(), this.fileSystemHandler));
            }
            if (!this.dir.getPath().equals("/")) {
                SortedSet<ClientPrimaryDataEntityVersion> versions = this.dir.getVersions();
                for (ClientPrimaryDataEntityVersion v : versions) {
                    if (v.getRevision() <= -1L) continue;
                    children.add(new PrimaryDataEntityPropertyVirtualResource(v, v.getRevision()));
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (NotBoundException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (EdalAuthenticateException e) {
            ClientDataManager.logger.error((Object)("Failed to get children of: " + this.dir + "\n" + e.toString()));
        }
        catch (JAXBException e) {
            ClientDataManager.logger.error((Object)("Failed to create properties.xml of: " + this.dir + "\n" + e.toString()));
        }
        catch (MetaDataException e) {
            ClientDataManager.logger.error((Object)("Failed to create properties.xml of: " + this.dir + "\n: " + e.toString()));
        }
        return children;
    }

    public Resource createNew(String newName, InputStream inputStream, Long length, String contentType) throws IOException, ConflictException, NotAuthorizedException, BadRequestException {
        block10: {
            if (newName.contains("properties.xml")) {
                try {
                    ClientPrimaryDataEntity dirfile;
                    ExtXMLConfig conf = new ExtXMLConfig(Property.class);
                    Object rawData = conf.load(inputStream);
                    if (rawData == null) break block10;
                    Property metaData = (Property)rawData;
                    Pattern property = Pattern.compile("(.*)\\.v[0-9]+\\.?[^\\.]*\\.(properties?\\.?xml|.*)$");
                    Matcher pm = property.matcher(newName);
                    if (pm.matches() && (dirfile = this.fileSystemHandler.getEntity(this.dir.getPath())) != null) {
                        MetaData newMetaData = dirfile.getMetaData().clone();
                        metaData.updateMetaData(newMetaData);
                        dirfile.setMetaData(newMetaData);
                        this.fileSystemHandler.removecache(this.dir.getPath());
                        PrimaryDataEntityPropertyVirtualResource virtualxmlresouce = new PrimaryDataEntityPropertyVirtualResource(dirfile.getCurrentVersion(), dirfile.getCurrentVersion().getRevision());
                        return virtualxmlresouce;
                    }
                }
                catch (JAXBException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
                catch (CloneNotSupportedException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
                catch (PrimaryDataEntityVersionException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
                catch (MetaDataException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
                catch (PrimaryDataDirectoryException e) {
                    ClientDataManager.logger.error((Object)("Failed to save properties-file: " + newName + "\nReason: " + e.toString()));
                }
            } else {
                throw new NotAuthorizedException("don't support this operation!", (Resource)this);
            }
        }
        return null;
    }
}

