/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AttributeTextArea
extends JTextArea {
    private static final long serialVersionUID = -7407205597285624266L;
    private String defaultText;

    public AttributeTextArea(String defaultText, boolean editable, boolean onlyOneLineAllowed) {
        super(1, 1);
        this.setWrapStyleWord(true);
        this.setFont(new Font("SansSerif", 0, 12));
        this.setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        this.setDisabledTextColor(PropertyLoader.DISABLED_FONT_COLOR);
        this.setLineWrap(true);
        this.setEditable(editable);
        this.setToolTipText("please click to edit");
        EmptyBorder inBorder = new EmptyBorder(3, 5, 0, 0);
        EmptyBorder outBorder = new EmptyBorder(0, 0, 0, 0);
        this.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        if (onlyOneLineAllowed) {
            this.setDocument(new JTextFieldLimit(4000));
            this.getDocument().putProperty("filterNewlines", Boolean.TRUE);
        } else {
            this.setDocument(new JTextFieldLimit(4000));
        }
        this.defaultText = defaultText;
        this.setText(defaultText);
    }

    public void cleanTextArea() {
        this.setText(this.defaultText);
    }

    public class JTextFieldLimit
    extends PlainDocument {
        private static final long serialVersionUID = 8208493037022310906L;
        private int limit;

        JTextFieldLimit(int limit) {
            this.limit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (str.equals("\t")) {
                return;
            }
            if (this.getLength() + str.length() <= this.limit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

