/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalDateChooser;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalDateFormat;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateTimePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private EdalDateChooser dateChooser = null;
    private JTextField text;
    private JLabel label;

    public DateTimePicker(final EdalDate edaldate) {
        this.setBorder(null);
        this.setCursor(new Cursor(12));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.text = new JTextField();
        this.text.setHorizontalAlignment(0);
        this.text.setEditable(false);
        ImageIcon icon = ImageUtil.createImageIcon("dateIcon.gif", "choose new datetime");
        this.label = new JLabel(icon);
        this.label.setToolTipText("choose new datetime");
        DateTimePicker.addComponent(this, gridBagLayout, this.text, 0, 0, 1, 1, 0.95, 1.0, 1, 1);
        DateTimePicker.addComponent(this, gridBagLayout, this.label, 1, 0, 1, 1, 0.05, 1.0, 1, 1);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int returnVal;
                if (DateTimePicker.this.dateChooser == null) {
                    DateTimePicker.this.dateChooser = new EdalDateChooser(edaldate, false);
                }
                if ((returnVal = DateTimePicker.this.dateChooser.showDateChooser()) == 0) {
                    DateTimePicker.this.setDate(DateTimePicker.this.dateChooser.getCalendar().getTime());
                }
            }
        });
    }

    static void addComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int ipadx, int ipady) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(c, gbc);
        cont.add(c);
    }

    public void reset() {
        if (this.dateChooser != null) {
            this.dateChooser.reset();
        }
        this.text.setText("");
    }

    public Calendar getCalendar() {
        if (this.dateChooser != null) {
            return this.dateChooser.getCalendar();
        }
        return null;
    }

    public EdalDatePrecision getPrecision() {
        if (this.dateChooser != null) {
            return this.dateChooser.getPrecision();
        }
        return null;
    }

    private void setDate(Date date) {
        this.text.setText(EdalDateFormat.getDefaultDateFormat(this.getPrecision()).format(date));
    }
}

