/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.publication.AgreementPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationHeadPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.listener.ShutdownWindowsListener;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.apache.commons.codec.digest.DigestUtils;

public class PublicationFrame
extends JFrame {
    private static final long serialVersionUID = 3152855359717852975L;
    private static PublicationMainPanel mainPanel;
    private static PublicationHeadPanel headPanel;
    private static PublicationButtonLinePanel buttonPanel;
    public static ClientPrimaryDataDirectory rootDirectory;
    public static String loggedUser;

    public static PublicationButtonLinePanel getButtonPanel() {
        return buttonPanel;
    }

    public static PublicationMainPanel getMainPanel() {
        return mainPanel;
    }

    public static void updateUI(Color color) {
        mainPanel.revalidate();
        mainPanel.repaint();
        buttonPanel.revalidate();
        buttonPanel.repaint();
        headPanel.getHtmlPanel().updateHtml();
        headPanel.getCitationPanel().updateHtml(color);
    }

    public static void updateUI() {
        mainPanel.revalidate();
        mainPanel.repaint();
        buttonPanel.revalidate();
        buttonPanel.repaint();
        headPanel.getHtmlPanel().updateHtml();
        headPanel.getCitationPanel().updateHtml();
    }

    public PublicationFrame(ClientDataManager clientDataManager, boolean showPublisherField, boolean showResourceField) throws Exception {
        loggedUser = clientDataManager.getAuthentication().getName();
        this.checkLoggedUserForCorrectEmailAddress(loggedUser);
        this.setTitle("IPK Data Publication System");
        this.setIconImage(PropertyLoader.EDAL_ICON);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ShutdownWindowsListener());
        mainPanel = new PublicationMainPanel(showPublisherField, showResourceField);
        headPanel = new PublicationHeadPanel();
        buttonPanel = new PublicationButtonLinePanel(clientDataManager);
        this.checkLicenseProperty();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)headPanel, "North");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setMinimumSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);
        this.setPreferredSize(PropertyLoader.MINIMUM_DIM_PUBLICATION_FRAME);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void checkLicenseProperty() throws IOException {
        if (PropertyLoader.userValues.getProperty("AGREEMENT_PDF") != null) {
            String checkSumNew;
            String checkSumOld = PropertyLoader.userValues.getProperty("AGREEMENT_PDF");
            if (checkSumOld.equals(checkSumNew = DigestUtils.md5Hex((InputStream)PropertyLoader.PGP_CONTRACT_URL.openStream()))) {
                mainPanel.enableAll();
                PublicationButtonLinePanel.getNextButton().setEnabled(true);
            } else {
                mainPanel.disableAll();
                PublicationButtonLinePanel.getNextButton().setEnabled(false);
                PublicationButtonLinePanel.getNextButton().addMouseListener(PublicationMainPanel.blockedFieldMouseAdapter);
            }
        } else if (PropertyLoader.userValues.getProperty("AGREEMENT_PANEL") != null) {
            String hashCodeNew;
            String hashCodeOld = PropertyLoader.userValues.getProperty("AGREEMENT_PANEL");
            if (hashCodeOld.equals(hashCodeNew = new AgreementPanel().getContentHash())) {
                mainPanel.enableAll();
                PublicationButtonLinePanel.getNextButton().setEnabled(true);
            } else {
                mainPanel.disableAll();
                PublicationButtonLinePanel.getNextButton().setEnabled(false);
                PublicationButtonLinePanel.getNextButton().addMouseListener(PublicationMainPanel.blockedFieldMouseAdapter);
            }
        } else {
            mainPanel.disableAll();
            PublicationButtonLinePanel.getNextButton().setEnabled(false);
            PublicationButtonLinePanel.getNextButton().addMouseListener(PublicationMainPanel.blockedFieldMouseAdapter);
        }
    }

    private void checkLoggedUserForCorrectEmailAddress(String loggedUser) throws Exception {
        Pattern p = Pattern.compile(".+@.+\\.[a-zA-Z]+");
        Matcher m = p.matcher(loggedUser);
        boolean matchFound = m.matches();
        if (!matchFound) {
            throw new Exception("Unable to start Publication Tool. No correct email address found ");
        }
        ClientDataManager.logger.info("Publication-Tool initiated for user '" + loggedUser + "'");
    }

    public static ClientPrimaryDataDirectory getUserDirectory() {
        ClientPrimaryDataDirectory userDirectory = null;
        try {
            userDirectory = (ClientPrimaryDataDirectory)rootDirectory.getPrimaryDataEntity(loggedUser);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (PrimaryDataDirectoryException e) {
            try {
                userDirectory = rootDirectory.createPrimaryDataDirectory(loggedUser);
            }
            catch (PrimaryDataDirectoryException | RemoteException e1) {
                e1.printStackTrace();
            }
        }
        return userDirectory;
    }

    static {
        rootDirectory = null;
        loggedUser = "";
    }
}

