/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class PublicationVeloCityCreater {
    private static final String CODING_UTF_8 = "UTF-8";
    private static final String RESOURCES = "de/ipk_gatersleben/bit/bi/edal/publication/";
    private static final String HEAD_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/head.html";
    private static final String CITATION_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/citation.html";
    private static final String PROCESS_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/process.html";
    private static final String FINISH_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/finish.html";
    private static final String SERVER_ERROR_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/server_error.html";
    private static final String AGREEMENT_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/agreement.html";
    private static final String AGREEMENT_EMAIL_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/confirmation_mail.html";
    private static final String LICENSE_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/license.html";
    private static final String ORCID_SEARCH_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/orcid_search.html";
    private static final String ORCID_SEARCH_HEADER_TEMPLATE = "de/ipk_gatersleben/bit/bi/edal/publication/orcid_search_header.html";

    protected static String generateHtmlForHeadPage() throws EdalException {
        VelocityContext context = new VelocityContext();
        URL edalLogoUrl = PublicationFrame.class.getResource("edal_scaled.png");
        URL ipkLogoUrl = PublicationFrame.class.getResource("ipk_scaled.png");
        context.put("edal", (Object)edalLogoUrl);
        context.put("ipk", (Object)ipkLogoUrl);
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)HEAD_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    protected static String generateHtmlForHeadCitationPage(Color color) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("fgcolor", (Object)color);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)CITATION_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateHtmlForProcessDialog() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        context.put("license", (Object)PublicationMainPanel.licensePanel.getLicense());
        context.put("directories", (Object)Utils.NumberOfDirectories);
        context.put("files", (Object)Utils.NumberOfFiles);
        context.put("path", (Object)PublicationMainPanel.uploadPathField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)PROCESS_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateFinishUploadPage() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        context.put("license", (Object)PublicationMainPanel.licensePanel.getLicense());
        context.put("directories", (Object)Utils.NumberOfDirectories);
        context.put("files", (Object)Utils.NumberOfFiles);
        context.put("path", (Object)PublicationMainPanel.uploadPathField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)FINISH_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    protected static String generateServerErrorDialog(String errorMessage, String serverAddress, int registryPort) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("errorMessage", (Object)errorMessage);
        context.put("serverAddress", (Object)serverAddress);
        context.put("registryPort", (Object)registryPort);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)SERVER_ERROR_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    protected static String generateHtmlForAgreement() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)AGREEMENT_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create html page : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateEmailForAgreement(MetaData metadata, Calendar now) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("timepoint", (Object)now.getTime());
        context.put("authors", (Object)PublicationMainPanel.authorPanel.getAuthors());
        context.put("year", (Object)Calendar.getInstance().get(1));
        context.put("title", (Object)PublicationMainPanel.titleField.getText());
        context.put("publisher", (Object)PublicationMainPanel.publisherField.getText());
        context.put("license", (Object)PublicationMainPanel.licensePanel.getLicense());
        context.put("directories", (Object)Utils.NumberOfDirectories);
        context.put("files", (Object)Utils.NumberOfFiles);
        context.put("path", (Object)PublicationMainPanel.uploadPathField.getText());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)AGREEMENT_EMAIL_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create agreement email : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateHtmlForLicense(String legalCodeUrl, String humanReadableUrl) throws EdalException {
        StringWriter output = new StringWriter();
        VelocityContext context = new VelocityContext();
        context.put("legalcode", (Object)legalCodeUrl);
        context.put("humanreadable", (Object)humanReadableUrl);
        Velocity.mergeTemplate((String)LICENSE_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create license HTML : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateHtmlForOrcidSearch(String orcid, NaturalPerson naturalPerson) throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        context.put("orcid", (Object)orcid);
        context.put("givenname", (Object)naturalPerson.getGivenName());
        context.put("surename", (Object)naturalPerson.getSureName());
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)ORCID_SEARCH_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create license HTML : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    public static String generateHtmlForOrcidSearchHeader() throws EdalException {
        VelocityContext context = new VelocityContext();
        context.put("bgcolor", (Object)PropertyLoader.HEADER_FOOTER_COLOR);
        StringWriter output = new StringWriter();
        Velocity.mergeTemplate((String)ORCID_SEARCH_HEADER_TEMPLATE, (String)CODING_UTF_8, (Context)context, (Writer)output);
        try {
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new EdalException("unable to create license HTML : " + e.getMessage(), (Throwable)e);
        }
        return output.toString();
    }

    static {
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        Velocity.init();
    }
}

