/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class Utils {
    public static int NumberOfDirectories = 0;
    public static int NumberOfFiles = 0;

    public static boolean checkIfStringIsEmpty(String string) {
        String temp = string.replaceAll(" ", "");
        temp = temp.replaceAll("\t", "");
        temp = temp.replaceAll("\n", "");
        return temp.isEmpty();
    }

    public static int countObjects(Frame parent, Path srcDir) {
        ProgressPanel panel = new ProgressPanel(parent);
        FileVisitorCounter fileVisitorCounter = new FileVisitorCounter(panel, 0);
        ProgressPanelSwingWorker worker = new ProgressPanelSwingWorker(panel, srcDir, fileVisitorCounter);
        worker.execute();
        panel.setVisible(true);
        if (worker.isFinished()) {
            return fileVisitorCounter.getCounter();
        }
        worker.cancel(true);
        return 0;
    }

    public static int countObjectsWithErrorsAndWarnings(Frame parent, Path srcDir) {
        ProgressPanelWithInformation panel = new ProgressPanelWithInformation(parent);
        FileVisitorCounterWithErrorsAndWarnings fileVisitorCounter = new FileVisitorCounterWithErrorsAndWarnings(panel, 0);
        ProgressInformationPanelSwingWorker worker = new ProgressInformationPanelSwingWorker(panel, srcDir, fileVisitorCounter);
        worker.execute();
        panel.setVisible(true);
        if (worker.isFinished()) {
            ErrorPanel errorPanel = new ErrorPanel(parent, fileVisitorCounter.getFoundedSymbolicLinks(), fileVisitorCounter.getNullByteFiles());
            while (fileVisitorCounter.getFoundedSymbolicLinks().size() > 0 || fileVisitorCounter.getNullByteFiles().size() > 0 && errorPanel.getResult() == 0) {
                errorPanel.setVisible(true);
                if (errorPanel.getResult() == 0) {
                    panel = new ProgressPanelWithInformation(parent);
                    fileVisitorCounter = new FileVisitorCounterWithErrorsAndWarnings(panel, 0);
                    worker = new ProgressInformationPanelSwingWorker(panel, srcDir, fileVisitorCounter);
                    worker.execute();
                    panel.setVisible(true);
                    errorPanel = new ErrorPanel(parent, fileVisitorCounter.getFoundedSymbolicLinks(), fileVisitorCounter.getNullByteFiles());
                    continue;
                }
                if (errorPanel.getResult() == 1) break;
                if (errorPanel.getResult() != 2) continue;
                return 0;
            }
            return fileVisitorCounter.getCounter();
        }
        worker.cancel(true);
        return 0;
    }

    public static int countFilesAndDirectoriesInEdalDirectory(ClientPrimaryDataEntity srcDir) throws RemoteException, PrimaryDataDirectoryException {
        if (!srcDir.isDirectory()) {
            return 1;
        }
        ClientPrimaryDataDirectory directory = (ClientPrimaryDataDirectory)srcDir;
        int count = 0;
        for (ClientPrimaryDataEntity file : directory.listPrimaryDataEntities()) {
            ++count;
            if (!file.isDirectory()) continue;
            count += Utils.countFilesAndDirectoriesInEdalDirectory((ClientPrimaryDataDirectory)file);
        }
        return count;
    }

    public static void addComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int ipadx, int ipady, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(c, gbc);
        cont.add(c);
    }

    public static void add(Container container, GridBagLayout gridBagLayout, Component c, int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = new Insets(2, 5, 2, 5);
        gridBagLayout.setConstraints(c, gbc);
        container.add(c);
    }

    public static void add(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty, int ipadx, int ipady) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        cont.add(c);
    }

    public static void add(Container container, GridBagLayout gridBagLayout, Component c, int gridx, int gridy, int ipadx, int ipady) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.ipadx = ipadx;
        gbc.ipady = ipady;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gridBagLayout.setConstraints(c, gbc);
        container.add(c);
    }

    private static class FileVisitorCounterWithErrorsAndWarnings
    implements FileVisitor<Path> {
        private int counter = 0;
        private ProgressPanelWithInformation panel = null;
        private List<Path> symbolicLinks = new ArrayList<Path>();
        private int numberSymbolicLinks = 0;
        private List<Path> nullByteFiles = new ArrayList<Path>();
        private int numberNullByteFiles = 0;

        private FileVisitorCounterWithErrorsAndWarnings(ProgressPanelWithInformation panel, int counter) {
            NumberOfDirectories = 0;
            NumberOfFiles = 0;
            this.counter = counter;
            this.panel = panel;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            ++NumberOfDirectories;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String parent;
            ++NumberOfFiles;
            if (Files.isSymbolicLink(file) || file.toFile().getName().endsWith(".lnk")) {
                this.symbolicLinks.add(file);
                ++this.numberSymbolicLinks;
                this.panel.getErrorNumberLabel().setText(String.valueOf(this.numberSymbolicLinks));
            }
            if (Files.size(file) == 0L) {
                this.nullByteFiles.add(file);
                ++this.numberNullByteFiles;
                this.panel.getWarningNumberLabel().setText(String.valueOf(this.numberNullByteFiles));
            }
            if ((parent = file.getParent().toString()).toString().length() <= 20) {
                this.panel.getPendingBar().setString(file.toString());
            } else {
                String label = parent.substring(0, 19) + "..." + File.separatorChar + file.getFileName().toString();
                this.panel.getPendingBar().setString(label);
            }
            ++this.counter;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (Files.isSymbolicLink(dir) || dir.toFile().getName().endsWith(".lnk")) {
                this.symbolicLinks.add(dir);
                ++this.numberSymbolicLinks;
                this.panel.getErrorNumberLabel().setText(String.valueOf(this.numberSymbolicLinks));
            }
            this.panel.getPendingBar().setString(dir.getFileName().toString());
            ++this.counter;
            return FileVisitResult.CONTINUE;
        }

        public int getCounter() {
            return this.counter;
        }

        public List<Path> getFoundedSymbolicLinks() {
            return this.symbolicLinks;
        }

        public List<Path> getNullByteFiles() {
            return this.nullByteFiles;
        }
    }

    private static class FileVisitorCounter
    implements FileVisitor<Path> {
        private int counter = 0;
        private ProgressPanel panel = null;

        private FileVisitorCounter(ProgressPanel panel, int counter) {
            this.counter = counter;
            this.panel = panel;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isSymbolicLink(file) || file.toFile().getName().endsWith(".lnk")) {
                throw new IOException("Please remove or resolve symbolic link : " + file.toString());
            }
            this.panel.getPendingBar().setString(file.getFileName().toString());
            ++this.counter;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (Files.isSymbolicLink(dir) || dir.toFile().getName().endsWith(".lnk")) {
                throw new IOException("Please remove or resolve symbolic link : " + dir.toString());
            }
            this.panel.getPendingBar().setString(dir.getFileName().toString());
            ++this.counter;
            return FileVisitResult.CONTINUE;
        }

        public int getCounter() {
            return this.counter;
        }
    }

    private static class ErrorPanel
    extends JDialog
    implements ActionListener,
    WindowListener {
        private static final long serialVersionUID = 4135429680729049866L;
        private JButton retryButton = new JButton("Retry");
        private JButton ignoreButton = new JButton("Ignore");
        private JButton abortButton = new JButton("Abort");
        private int result = 0;
        private JEditorPane pane = new JEditorPane();
        private JScrollPane scrollPane = new JScrollPane();

        public ErrorPanel(Frame parent, List<Path> errorFiles, List<Path> nullByteFiles) {
            super(parent, "Errors/Warnings found, please correct to continue !");
            this.setIconImage(PropertyLoader.EDAL_ICON);
            this.setFocusable(true);
            this.setModal(true);
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel buttonPanel = new JPanel(new FlowLayout());
            this.retryButton.addActionListener(this);
            this.ignoreButton.addActionListener(this);
            this.abortButton.addActionListener(this);
            this.pane.setContentType("text/html");
            StringBuffer buffer = new StringBuffer();
            buffer.append("<HTML><BODY>");
            if (errorFiles.size() == 0) {
                this.ignoreButton.setEnabled(true);
            } else {
                this.ignoreButton.setEnabled(false);
                buffer.append("ERRORS -> Symbolic Links : <br>");
                for (Path path : errorFiles) {
                    buffer.append(path.toString() + "<br>");
                }
                buffer.append("\n");
            }
            if (nullByteFiles.size() > 0) {
                buffer.append("WARNING -> Null Byte Files : <br>");
                for (Path path : nullByteFiles) {
                    buffer.append(path.toString() + "<br>");
                }
            }
            buffer.append("</BODY></HTML>");
            this.pane.setText(buffer.toString());
            this.pane.setPreferredSize(new Dimension(600, 300));
            this.scrollPane = new JScrollPane(this.pane, 20, 30);
            this.scrollPane.setPreferredSize(new Dimension(600, 300));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scrollPane.getViewport().setViewPosition(new Point(0, 0));
                }
            });
            mainPanel.add((Component)this.scrollPane, "Center");
            buttonPanel.add(this.retryButton);
            buttonPanel.add(this.ignoreButton);
            buttonPanel.add(this.abortButton);
            mainPanel.add((Component)buttonPanel, "South");
            this.setContentPane(mainPanel);
            this.addWindowListener(this);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setPreferredSize(new Dimension(600, 400));
            this.pack();
            this.setLocationRelativeTo(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.retryButton)) {
                this.setResult(0);
                this.dispose();
            }
            if (e.getSource().equals(this.ignoreButton)) {
                this.setResult(1);
                this.dispose();
            }
            if (e.getSource().equals(this.abortButton)) {
                this.setResult(2);
                this.dispose();
            }
        }

        public int getResult() {
            return this.result;
        }

        private void setResult(int result) {
            this.result = result;
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.setResult(2);
            this.dispose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }

    private static class ProgressPanelWithInformation
    extends JDialog {
        private static final long serialVersionUID = 4135429680729049866L;
        private JProgressBar pendingBar;
        private JLabel errorLabel = new JLabel("Errors: ");
        private JLabel errorNumberLabel = new JLabel("0");
        private JLabel warningLabel = new JLabel("Warnings: ");
        private JLabel warningNumberLabel = new JLabel("0");

        public ProgressPanelWithInformation(Frame parent) {
            super(parent, "Validating Files...");
            this.setFocusable(true);
            this.setIconImage(PropertyLoader.EDAL_ICON);
            this.setModal(true);
            this.pendingBar = new JProgressBar();
            this.pendingBar.setIndeterminate(true);
            this.pendingBar.setStringPainted(true);
            JPanel barPanel = new JPanel(new BorderLayout());
            barPanel.setMaximumSize(new Dimension(400, 80));
            barPanel.add((Component)this.pendingBar, "Center");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)barPanel, "North");
            JPanel middlePanel = new JPanel(new GridLayout(1, 4));
            middlePanel.add(this.errorLabel);
            middlePanel.add(this.errorNumberLabel);
            middlePanel.add(this.warningLabel);
            middlePanel.add(this.warningNumberLabel);
            mainPanel.add((Component)middlePanel, "Center");
            this.setContentPane(mainPanel);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setPreferredSize(new Dimension(400, 80));
            this.pack();
            this.setLocationRelativeTo(null);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    int result = JOptionPane.showConfirmDialog(null, "Stop File Validation ?", "EXIT", 0);
                    if (result == 0) {
                        this.dispose();
                    }
                }
            });
        }

        public JProgressBar getPendingBar() {
            return this.pendingBar;
        }

        public JLabel getErrorNumberLabel() {
            return this.errorNumberLabel;
        }

        public JLabel getWarningNumberLabel() {
            return this.warningNumberLabel;
        }
    }

    private static class ProgressPanel
    extends JDialog {
        private static final long serialVersionUID = 4135429680729049866L;
        private JProgressBar pendingBar;

        public ProgressPanel(Frame parent) {
            super(parent, "Validating Files...");
            this.setFocusable(true);
            this.setModal(true);
            this.pendingBar = new JProgressBar();
            this.pendingBar.setIndeterminate(true);
            this.pendingBar.setStringPainted(true);
            JPanel barPanel = new JPanel(new BorderLayout());
            barPanel.setMaximumSize(new Dimension(400, 60));
            barPanel.add((Component)this.pendingBar, "Center");
            this.setContentPane(barPanel);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setPreferredSize(new Dimension(400, 60));
            this.pack();
            this.setLocationRelativeTo(null);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    int result = JOptionPane.showConfirmDialog(null, "Stop File Validation ?", "EXIT", 0);
                    if (result == 0) {
                        this.dispose();
                    }
                }
            });
        }

        public JProgressBar getPendingBar() {
            return this.pendingBar;
        }
    }

    private static class ProgressInformationPanelSwingWorker
    extends SwingWorker<Object, Object> {
        private Path srcDir = null;
        private FileVisitorCounterWithErrorsAndWarnings fileVisitorCounter = null;
        private ProgressPanelWithInformation panel = null;
        private boolean finished = false;

        public ProgressInformationPanelSwingWorker(ProgressPanelWithInformation panel, Path srcDir, FileVisitorCounterWithErrorsAndWarnings fileVisitorCounter) {
            this.srcDir = srcDir;
            this.fileVisitorCounter = fileVisitorCounter;
            this.panel = panel;
            this.finished = false;
        }

        @Override
        protected Object doInBackground() throws Exception {
            Files.walkFileTree(this.srcDir, this.fileVisitorCounter);
            return true;
        }

        @Override
        protected void done() {
            super.done();
            try {
                this.finished = (Boolean)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ErrorDialog.showError(e);
            }
            catch (CancellationException e) {
                this.finished = false;
            }
            this.panel.dispose();
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    private static class ProgressPanelSwingWorker
    extends SwingWorker<Object, Object> {
        private Path srcDir = null;
        private FileVisitorCounter fileVisitorCounter = null;
        private ProgressPanel panel = null;
        private boolean finished = false;

        public ProgressPanelSwingWorker(ProgressPanel panel, Path srcDir, FileVisitorCounter fileVisitorCounter) {
            this.srcDir = srcDir;
            this.fileVisitorCounter = fileVisitorCounter;
            this.panel = panel;
            this.finished = false;
        }

        @Override
        protected Object doInBackground() throws Exception {
            Files.walkFileTree(this.srcDir, this.fileVisitorCounter);
            return true;
        }

        @Override
        protected void done() {
            super.done();
            try {
                this.finished = (Boolean)this.get();
            }
            catch (InterruptedException | ExecutionException e) {
                ErrorDialog.showError(e);
            }
            catch (CancellationException e) {
                this.finished = false;
            }
            this.panel.dispose();
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

