/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLableAttributeTextAreaPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.SmallButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ResourcePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8109825692298261311L;
    private static AttributeLabel RESOURCE_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("RESOURCE_LABEL"), PropertyLoader.props.getProperty("RESOURCE_TOOLTIP"));
    private static SmallButton OKAY_BUTTON = new SmallButton("OK");
    private static JComboBox<String> comboBox;

    public ResourcePanel() {
        JPanel mainPanel = new JPanel(new FlowLayout(0, 10, 0));
        mainPanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        mainPanel.setPreferredSize(new Dimension(120, 24));
        EmptyBorder inBorder = new EmptyBorder(1, 2, 0, 2);
        EmptyBorder outBorder = new EmptyBorder(1, 2, 0, 2);
        mainPanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        comboBox.setSelectedItem(PublicationMainPanel.DEFAULT_RESOURCE_STRING);
        OKAY_BUTTON.addActionListener(this);
        mainPanel.add(comboBox);
        mainPanel.add(OKAY_BUTTON);
        JPanel attributePanel = new JPanel(new GridLayout());
        attributePanel.add(RESOURCE_LABEL);
        attributePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        attributePanel.setPreferredSize(new Dimension(120, 24));
        this.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        this.setBorder(new MatteBorder(1, 0, 0, 0, Color.GRAY));
        this.setPreferredSize(new Dimension(680, 24));
        this.setLayout(new BorderLayout());
        this.add((Component)attributePanel, "West");
        this.add((Component)mainPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(OKAY_BUTTON)) {
            PublicationMainPanel.resourceField.setText(this.getTableContent());
            PublicationMainPanel.releaseAllBlockedFields();
            PublicationMainPanel.languageResourcePanel.remove(((BorderLayout)PublicationMainPanel.languageResourcePanel.getLayout()).getLayoutComponent("South"));
            PropertyLoader.RESOURCE_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
            AttributeLableAttributeTextAreaPanel newLicensePanel = new AttributeLableAttributeTextAreaPanel(PropertyLoader.RESOURCE_LABEL, PublicationMainPanel.resourceField, 24);
            newLicensePanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            PublicationMainPanel.languageResourcePanel.add((Component)newLicensePanel, "South");
            PublicationFrame.updateUI();
            PublicationButtonLinePanel.getNextButton().requestFocus();
            this.saveUserValues();
        }
    }

    public String getResourceType() {
        return (String)comboBox.getSelectedItem();
    }

    private String getTableContent() {
        return comboBox.getSelectedItem().toString();
    }

    private void saveUserValues() {
        PropertyLoader.setUserValue("RESOURCE_TYPE", comboBox.getSelectedItem().toString());
    }

    static {
        String[] strings = PropertyLoader.RESOURCE_TYPES.toArray(new String[PropertyLoader.RESOURCE_TYPES.size()]);
        comboBox = new JComboBox<String>(strings);
        comboBox.setRenderer(new CustomComboBox());
        comboBox.setBorder(BorderFactory.createEmptyBorder());
        comboBox.setSelectedItem(PropertyLoader.loadResourceString());
    }

    private static class CustomComboBox
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 9120777908811491201L;
        private static final Dimension preferredSize = new Dimension(250, 14);
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private CustomComboBox() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Color) {
                renderer.setBackground((Color)value);
            }
            renderer.setPreferredSize(preferredSize);
            return renderer;
        }
    }
}

