/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLableAttributeTextAreaPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.SmallButton;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class SubjectPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8109825692298261311L;
    private static final AttributeLabel SUBJECTS_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("SUBJECTS_LABEL"), PropertyLoader.props.getProperty("SUBJECTS_TOOLTIP"));
    private static final SmallButton OKAY_BUTTON = new SmallButton("OK");
    private static final SmallButton ADD_BUTTON = new SmallButton("ADD KEYWORD");
    private static final SmallButton REMOVE_BUTTON = new SmallButton("REMOVE KEYWORD");
    private DefaultTableModel model;
    private JTable table;
    private JScrollPane scrollPane;
    private static final String[] DEFAULT_VALUE = new String[]{""};
    private static final String[] COL_NAMES = new String[]{"Keywords"};

    public SubjectPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel tablePanel = new JPanel(gridBagLayout);
        tablePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        tablePanel.setMinimumSize(new Dimension(680, 48));
        EmptyBorder inBorder = new EmptyBorder(2, 2, 0, 2);
        EmptyBorder outBorder = new EmptyBorder(2, 2, 0, 2);
        tablePanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ((DefaultCellEditor)this.table.getDefaultEditor(this.table.getColumnClass(i))).setClickCountToStart(1);
        }
        this.table.setFillsViewportHeight(true);
        this.table.setFont(PropertyLoader.DEFAULT_FONT);
        this.table.setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.table.setTableHeader(null);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CustomRenderer(this.model));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        buttonPanel.add(OKAY_BUTTON);
        buttonPanel.add(ADD_BUTTON);
        buttonPanel.add(REMOVE_BUTTON);
        OKAY_BUTTON.addActionListener(this);
        ADD_BUTTON.addActionListener(this);
        REMOVE_BUTTON.addActionListener(this);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(680, 48));
        Utils.add(tablePanel, gridBagLayout, this.scrollPane, 0, 0, 1, 1, 1.0, 1.0, 1, 1);
        Utils.add(tablePanel, gridBagLayout, buttonPanel, 0, 1, 1, 1, 1.0, 1.0, 1, 1);
        JPanel attributePanel = new JPanel(new GridLayout());
        SUBJECTS_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
        attributePanel.add(SUBJECTS_LABEL);
        attributePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        attributePanel.setPreferredSize(new Dimension(120, 48));
        this.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)attributePanel, "West");
        this.add((Component)tablePanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(OKAY_BUTTON)) {
            int i;
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null && cellEditor.getCellEditorValue() == null) {
                cellEditor.stopCellEditing();
            }
            this.table.clearSelection();
            ArrayList<Integer> emptyLines = new ArrayList<Integer>();
            for (i = 0; i < this.table.getRowCount(); ++i) {
                if (!Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 0).toString())) continue;
                emptyLines.add(i);
            }
            for (i = emptyLines.size() - 1; i >= 0; --i) {
                this.model.removeRow((Integer)emptyLines.get(i));
            }
            PublicationMainPanel.subjectPanel = this;
            PublicationMainPanel.subjectsField.setText(this.getTableContent());
            PublicationMainPanel.releaseAllBlockedFields();
            PublicationMainPanel.descriptionSubjectsSplitPanel.setRightComponent(null);
            PropertyLoader.SUBJECTS_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
            PublicationMainPanel.descriptionSubjectsSplitPanel.setRightComponent(new AttributeLableAttributeTextAreaPanel(PropertyLoader.SUBJECTS_LABEL, PublicationMainPanel.subjectsField, 48));
            PublicationFrame.updateUI();
            PublicationButtonLinePanel.getNextButton().requestFocus();
            this.saveUserValues();
        } else if (actionEvent.getSource().equals(ADD_BUTTON)) {
            if (this.table.getSelectedRow() == -1) {
                this.model.addRow(DEFAULT_VALUE);
            } else {
                this.model.insertRow(this.table.getSelectedRow() + 1, DEFAULT_VALUE);
            }
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        } else if (actionEvent.getSource().equals(REMOVE_BUTTON)) {
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null && cellEditor.getCellEditorValue() == null) {
                cellEditor.stopCellEditing();
            }
            if (this.model.getRowCount() > 0) {
                if (this.table.getSelectedRow() == -1) {
                    this.model.removeRow(this.table.getRowCount() - 1);
                } else {
                    this.model.removeRow(this.table.getSelectedRow());
                }
            }
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        }
    }

    private void saveUserValues() {
        StringBuffer buffer = new StringBuffer();
        String[] subjects = this.getSubjects();
        for (int i = 0; i < subjects.length; ++i) {
            buffer.append(subjects[i]);
            if (i == subjects.length - 1) continue;
            buffer.append(",");
        }
        PropertyLoader.setUserValue("SUBJECTS", buffer.toString());
    }

    private String getTableContent() {
        String nameSeperator = new String(", ");
        StringBuffer buffer = new StringBuffer("");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (Utils.checkIfStringIsEmpty(this.model.getValueAt(i, 0).toString())) continue;
            buffer.append(this.model.getValueAt(i, 0).toString());
            buffer.append(nameSeperator);
        }
        if (buffer.toString().lastIndexOf(nameSeperator) != -1) {
            return buffer.toString().substring(0, buffer.toString().lastIndexOf(nameSeperator));
        }
        return PropertyLoader.props.getProperty("DEFAULT_SUBJECTS_STRING");
    }

    public String[] getSubjects() {
        String[] subjects = new String[this.model.getRowCount()];
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            subjects[i] = this.model.getValueAt(i, 0).toString();
        }
        return subjects;
    }

    private static class CustomRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 8309932008829066343L;

        public CustomRenderer(DefaultTableModel model) {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                c.setBackground(PropertyLoader.TABLE_HAS_VALUE_BACKGROUND_COLOR);
            } else {
                c.setBackground(PropertyLoader.TABLE_HAS_VALUE_BACKGROUND_COLOR);
            }
            return c;
        }
    }

    private class MyTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8557354261856948625L;

        public MyTableModel() {
            this.setDataVector(this.loadUserValues(), COL_NAMES);
        }

        private Object[][] loadUserValues() {
            String string = PropertyLoader.userValues.getProperty("SUBJECTS");
            if (string == null || string.isEmpty()) {
                return new Objects[0][0];
            }
            String[] subjects = string.split(",");
            Object[][] data = new Object[subjects.length][1];
            for (int j = 0; j < subjects.length; ++j) {
                data[j][0] = subjects[j];
            }
            return data;
        }
    }
}

