/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EdalDatePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private int startYear = 1;
    private int lastYear = 5000;
    private static final Font FONT = new Font("Courier New", 0, 10);
    private Color palletTableColor = Color.white;
    private Color todayBackColor = Color.orange;
    private Color weekFontColor = Color.blue;
    private Color dateFontColor = Color.black;
    private Color weekendFontColor = Color.red;
    private Color controlLineColor = Color.pink;
    private Color controlTextColor = Color.white;
    private static final String CENTURY = "Century";
    private static final String DECADE = "Decade";
    private static final String YEAR = "Year";
    private static final String MONTH = "Month";
    private static final String DAY = "Day";
    private static final String HOUR = "Hour";
    private static final String MINUTE = "Minute";
    private static final String SECOND = "Second";
    private static final String MILLISECOND = "Millisecond";
    private JSpinner yearSpin;
    private JSpinner monthSpin;
    private JSpinner daySpin;
    private JSpinner hourSpin;
    private JSpinner minuteSpin;
    private JSpinner secondSpin;
    private JSpinner millisecondSpin;
    private JButton[][] daysButton = new JButton[6][7];
    private EdalDatePrecision showprecision;
    private Calendar showcalendar;

    public EdalDatePanel(EdalDate edaldate, boolean showprecision) {
        if (edaldate != null) {
            this.showcalendar = edaldate.getStartDate();
            this.showprecision = edaldate.getStartPrecision();
        } else {
            this.showcalendar = Calendar.getInstance();
            this.showprecision = EdalDatePrecision.SECOND;
        }
        this.setLayout(new BorderLayout());
        if (showprecision) {
            JPanel toppanel = this.createprecisionPanel();
            this.add((Component)toppanel, "North");
            JPanel controlpanel = this.createYearAndMonthPanel();
            this.add((Component)controlpanel, "Center");
            JPanel displaypanel = this.createWeekAndDayPanel();
            this.add((Component)displaypanel, "South");
        } else {
            JPanel controlpanel = this.createYearAndMonthPanel();
            this.add((Component)controlpanel, "North");
            JPanel displaypanel = this.createWeekAndDayPanel();
            this.add((Component)displaypanel, "Center");
        }
        this.flushWeekAndDay();
    }

    private JPanel createprecisionPanel() {
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout());
        ButtonGroup g = new ButtonGroup();
        JRadioButton centuryrb = new JRadioButton(CENTURY);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.CENTURY)) {
            centuryrb.setSelected(true);
        }
        centuryrb.addActionListener(this);
        g.add(centuryrb);
        result.add(centuryrb);
        JRadioButton decaderb = new JRadioButton(DECADE);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.DECADE)) {
            decaderb.setSelected(true);
        }
        decaderb.addActionListener(this);
        g.add(decaderb);
        result.add(decaderb);
        JRadioButton yearrb = new JRadioButton(YEAR);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.YEAR)) {
            yearrb.setSelected(true);
        }
        yearrb.addActionListener(this);
        g.add(yearrb);
        result.add(yearrb);
        JRadioButton monthrb = new JRadioButton(MONTH);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MONTH)) {
            monthrb.setSelected(true);
        }
        monthrb.addActionListener(this);
        g.add(monthrb);
        result.add(monthrb);
        JRadioButton dayrb = new JRadioButton(DAY);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.DAY)) {
            dayrb.setSelected(true);
        }
        dayrb.addActionListener(this);
        g.add(dayrb);
        result.add(dayrb);
        JRadioButton hourrb = new JRadioButton(HOUR);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.HOUR)) {
            hourrb.setSelected(true);
        }
        hourrb.addActionListener(this);
        g.add(hourrb);
        result.add(hourrb);
        JRadioButton minuterb = new JRadioButton(MINUTE);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MINUTE)) {
            minuterb.setSelected(true);
        }
        minuterb.addActionListener(this);
        g.add(minuterb);
        result.add(minuterb);
        JRadioButton secondrb = new JRadioButton(SECOND);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.SECOND)) {
            secondrb.setSelected(true);
        }
        secondrb.addActionListener(this);
        g.add(secondrb);
        result.add(secondrb);
        JRadioButton millisecondrb = new JRadioButton(MILLISECOND);
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MILLISECOND)) {
            millisecondrb.setSelected(true);
        }
        millisecondrb.addActionListener(this);
        g.add(millisecondrb);
        result.add(millisecondrb);
        if (this.showprecision == null) {
            secondrb.setSelected(true);
        }
        return result;
    }

    private JPanel createYearAndMonthPanel() {
        Calendar c = this.getCalendar();
        int currentYear = c.get(1);
        int currentMonth = c.get(2) + 1;
        int currentday = c.get(5);
        int currentHour = c.get(11);
        int currentMinute = c.get(12);
        int currentSecond = c.get(13);
        int currentMillisecond = c.get(14);
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout());
        result.setBackground(this.controlLineColor);
        JLabel yearLabel = new JLabel(YEAR);
        yearLabel.setForeground(this.controlTextColor);
        result.add(yearLabel);
        this.yearSpin = new JSpinner(new SpinnerNumberModel(currentYear, this.startYear, this.lastYear, 1));
        this.yearSpin.setPreferredSize(new Dimension(60, 20));
        this.yearSpin.setName(YEAR);
        this.yearSpin.setEditor(new JSpinner.NumberEditor(this.yearSpin, "####"));
        this.yearSpin.addChangeListener(this);
        result.add(this.yearSpin);
        JLabel monthLabel = new JLabel(MONTH);
        monthLabel.setForeground(this.controlTextColor);
        result.add(monthLabel);
        this.monthSpin = new JSpinner(new SpinnerNumberModel(currentMonth, 1, 12, 1));
        this.monthSpin.setPreferredSize(new Dimension(60, 20));
        this.monthSpin.setName(MONTH);
        this.monthSpin.addChangeListener(this);
        result.add(this.monthSpin);
        JLabel dayLabel = new JLabel(DAY);
        dayLabel.setForeground(this.controlTextColor);
        result.add(dayLabel);
        this.daySpin = new JSpinner(this.getdaymodel(currentYear, currentMonth, currentday));
        this.daySpin.setPreferredSize(new Dimension(60, 20));
        this.daySpin.setName(DAY);
        this.daySpin.addChangeListener(this);
        result.add(this.daySpin);
        JLabel hourLabel = new JLabel(HOUR);
        hourLabel.setForeground(this.controlTextColor);
        result.add(hourLabel);
        this.hourSpin = new JSpinner(new SpinnerNumberModel(currentHour, 0, 23, 1));
        this.hourSpin.setPreferredSize(new Dimension(60, 20));
        this.hourSpin.setName(HOUR);
        this.hourSpin.addChangeListener(this);
        result.add(this.hourSpin);
        JLabel minuteLabel = new JLabel(MINUTE);
        minuteLabel.setForeground(this.controlTextColor);
        result.add(minuteLabel);
        this.minuteSpin = new JSpinner(new SpinnerNumberModel(currentMinute, 0, 59, 1));
        this.minuteSpin.setPreferredSize(new Dimension(60, 20));
        this.minuteSpin.setName(MINUTE);
        this.minuteSpin.addChangeListener(this);
        result.add(this.minuteSpin);
        JLabel secondLabel = new JLabel(SECOND);
        secondLabel.setForeground(this.controlTextColor);
        result.add(secondLabel);
        this.secondSpin = new JSpinner(new SpinnerNumberModel(currentSecond, 0, 59, 1));
        this.secondSpin.setPreferredSize(new Dimension(60, 20));
        this.secondSpin.setName(SECOND);
        this.secondSpin.addChangeListener(this);
        result.add(this.secondSpin);
        JLabel millisecondLabel = new JLabel(MILLISECOND);
        millisecondLabel.setForeground(this.controlTextColor);
        result.add(millisecondLabel);
        this.millisecondSpin = new JSpinner(new SpinnerNumberModel(currentMillisecond, 0, 999, 1));
        this.millisecondSpin.setPreferredSize(new Dimension(60, 20));
        this.millisecondSpin.setName(MILLISECOND);
        this.millisecondSpin.addChangeListener(this);
        result.add(this.millisecondSpin);
        return result;
    }

    private JPanel createWeekAndDayPanel() {
        String[] colname = new String[]{"Sunday", "Monday", "Tuesday ", "Wednesday", "Thursday", "Friday", "Saturday "};
        JPanel result = new JPanel();
        result.setFont(FONT);
        result.setLayout(new GridLayout(7, 7));
        result.setBackground(Color.white);
        for (int i = 0; i < 7; ++i) {
            JLabel cell = new JLabel(colname[i]);
            cell.setHorizontalAlignment(0);
            if (i == 0 || i == 6) {
                cell.setForeground(this.weekendFontColor);
            } else {
                cell.setForeground(this.weekFontColor);
            }
            result.add(cell);
        }
        int actionCommandId = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                JButton numberButton = new JButton();
                numberButton.setBorder(null);
                numberButton.setHorizontalAlignment(0);
                numberButton.setActionCommand(String.valueOf(actionCommandId));
                numberButton.addActionListener(this);
                numberButton.setBackground(this.palletTableColor);
                numberButton.setForeground(this.dateFontColor);
                if (j == 0 || j == 6) {
                    numberButton.setForeground(this.weekendFontColor);
                } else {
                    numberButton.setForeground(this.dateFontColor);
                }
                this.daysButton[i][j] = numberButton;
                result.add(numberButton);
                ++actionCommandId;
            }
        }
        return result;
    }

    public Calendar getCalendar() {
        if (this.showcalendar == null) {
            this.showcalendar = Calendar.getInstance();
        }
        this.showcalendar.setTime(this.getDate());
        return this.showcalendar;
    }

    public EdalDatePrecision getPrecision() {
        return this.showprecision;
    }

    public void reset() {
        this.showcalendar = Calendar.getInstance();
        this.showprecision = EdalDatePrecision.SECOND;
    }

    private Date getDate() {
        return this.showcalendar.getTime();
    }

    private SpinnerNumberModel getdaymodel(int currentYear, int currentMonth, int currentday) {
        int minday = 1;
        int maxday = 30;
        if (currentMonth == 1 || currentMonth == 3 || currentMonth == 5 || currentMonth == 7 || currentMonth == 8 || currentMonth == 10 || currentMonth == 12) {
            maxday = 31;
        } else if (currentMonth == 2) {
            maxday = this.isleapyear(currentYear) ? 29 : 28;
        }
        return new SpinnerNumberModel(currentday, minday, maxday, 1);
    }

    private boolean isleapyear(int year) {
        return year % 100 == 0 ? year % 400 == 0 : year % 4 == 0;
    }

    private int getSelectedYear() {
        return (Integer)this.yearSpin.getValue();
    }

    private int getSelectedMonth() {
        return (Integer)this.monthSpin.getValue();
    }

    private int getSelectedDay() {
        return (Integer)this.daySpin.getValue();
    }

    private int getSelectedHour() {
        return (Integer)this.hourSpin.getValue();
    }

    private int getSelectedMinite() {
        return (Integer)this.minuteSpin.getValue();
    }

    private int getSelectedSecond() {
        return (Integer)this.secondSpin.getValue();
    }

    private int getSelectedMillisecond() {
        return (Integer)this.millisecondSpin.getValue();
    }

    private void refreshdayspin(int currentYear, int currentMonth, int currentday) {
        this.daySpin.setModel(this.getdaymodel(currentYear, currentMonth, currentday));
        this.daySpin.updateUI();
    }

    public void flushWeekAndDay() {
        Calendar c = this.getCalendar();
        int curday = c.get(5);
        c.set(5, 1);
        int maxDayNo = c.getActualMaximum(5);
        int dayNo = 2 - c.get(7);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                String s = "";
                if (dayNo >= 1 && dayNo <= maxDayNo) {
                    s = String.valueOf(dayNo);
                }
                this.daysButton[i][j].setText(s);
                ++dayNo;
                if (j == 0 || j == 6) {
                    this.daysButton[i][j].setForeground(this.weekendFontColor);
                    continue;
                }
                this.daysButton[i][j].setForeground(this.dateFontColor);
            }
        }
        c.set(5, curday);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner source = (JSpinner)e.getSource();
        Calendar c = this.getCalendar();
        if (source.getName().equals(DAY)) {
            c.set(5, this.getSelectedDay());
            return;
        }
        if (source.getName().equals(HOUR)) {
            c.set(11, this.getSelectedHour());
            return;
        }
        if (source.getName().equals(MINUTE)) {
            c.set(12, this.getSelectedMinite());
            return;
        }
        if (source.getName().equals(SECOND)) {
            c.set(13, this.getSelectedSecond());
            return;
        }
        if (source.getName().equals(MILLISECOND)) {
            c.set(14, this.getSelectedMillisecond());
            return;
        }
        if (source.getName().equals(YEAR)) {
            c.set(1, this.getSelectedYear());
            this.refreshdayspin(this.getSelectedYear(), this.getSelectedMonth(), this.getSelectedDay());
        } else if (source.getName().equals(MONTH)) {
            c.set(2, this.getSelectedMonth() - 1);
            this.refreshdayspin(this.getSelectedYear(), this.getSelectedMonth(), this.getSelectedDay());
        }
        this.flushWeekAndDay();
    }

    private void changeSpinnerStatus(boolean enableYearSpinner, boolean enableMonthSpinner, boolean enableDaySpinner, boolean enableHourSpinner, boolean enableMinuteSpinner, boolean enableSecondSpinner, boolean enableMillisecondSpinner, boolean enableDisplayButtons) {
        this.yearSpin.setEnabled(enableYearSpinner);
        this.monthSpin.setEnabled(enableMonthSpinner);
        this.daySpin.setEnabled(enableDaySpinner);
        this.hourSpin.setEnabled(enableHourSpinner);
        this.minuteSpin.setEnabled(enableMinuteSpinner);
        this.secondSpin.setEnabled(enableSecondSpinner);
        this.millisecondSpin.setEnabled(enableMillisecondSpinner);
        this.enabledisplaybuttons(enableDaySpinner);
    }

    private void enabledisplaybuttons(boolean enable) {
        for (int i = 0; i < this.daysButton.length; ++i) {
            for (int j = 0; j < this.daysButton[i].length; ++j) {
                this.daysButton[i][j].setEnabled(enable);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton source;
        String classname = e.getSource().getClass().getName();
        if (classname.equals("javax.swing.JButton")) {
            JButton source2 = (JButton)e.getSource();
            if (source2.getText().length() == 0) {
                return;
            }
            if (!source2.isEnabled()) {
                return;
            }
            source2.setForeground(this.todayBackColor);
            int newDay = Integer.parseInt(source2.getText());
            Calendar c = this.getCalendar();
            c.set(5, newDay);
            this.daySpin.setValue(newDay);
        } else if (classname.equals("javax.swing.JRadioButton") && (source = (JRadioButton)e.getSource()).isSelected()) {
            switch (source.getText()) {
                case "Century": {
                    this.showprecision = EdalDatePrecision.CENTURY;
                    this.changeSpinnerStatus(false, false, false, false, false, false, false, false);
                    break;
                }
                case "Decade": {
                    this.showprecision = EdalDatePrecision.DECADE;
                    this.changeSpinnerStatus(false, false, false, false, false, false, false, false);
                    break;
                }
                case "Year": {
                    this.showprecision = EdalDatePrecision.YEAR;
                    this.changeSpinnerStatus(true, false, false, false, false, false, false, false);
                    break;
                }
                case "Month": {
                    this.showprecision = EdalDatePrecision.MONTH;
                    this.changeSpinnerStatus(true, true, false, false, false, false, false, false);
                    break;
                }
                case "Day": {
                    this.showprecision = EdalDatePrecision.DAY;
                    this.changeSpinnerStatus(true, true, true, false, false, false, false, true);
                    break;
                }
                case "Hour": {
                    this.showprecision = EdalDatePrecision.HOUR;
                    this.changeSpinnerStatus(true, true, true, true, false, false, false, true);
                    break;
                }
                case "Minute": {
                    this.showprecision = EdalDatePrecision.MINUTE;
                    this.changeSpinnerStatus(true, true, true, true, true, false, false, true);
                    break;
                }
                case "Second": {
                    this.showprecision = EdalDatePrecision.SECOND;
                    this.changeSpinnerStatus(true, true, true, true, true, true, false, true);
                    break;
                }
                case "Millisecond": {
                    this.showprecision = EdalDatePrecision.MILLISECOND;
                    this.changeSpinnerStatus(true, true, true, true, true, true, true, true);
                    break;
                }
            }
        }
    }

    private int formatyeartocentury(int year) {
        if (year < 100) {
            return 0;
        }
        int century = year / 100;
        return century * 100;
    }

    private int formatyeartodecade(int year) {
        if (year < 10) {
            return 0;
        }
        int century = year / 10;
        return century * 10;
    }

    public void refreshtime() {
        if (this.showcalendar == null) {
            this.showcalendar = this.getCalendar();
        }
        if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.CENTURY)) {
            this.showcalendar.set(1, this.formatyeartocentury(this.getSelectedYear()));
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.DECADE)) {
            this.showcalendar.set(1, this.formatyeartodecade(this.getSelectedYear()));
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.YEAR)) {
            this.showcalendar.set(1, this.getSelectedYear());
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MONTH)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.DAY)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
            this.showcalendar.set(5, this.getSelectedDay());
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.HOUR)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
            this.showcalendar.set(5, this.getSelectedDay());
            this.showcalendar.set(10, this.getSelectedHour());
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MINUTE)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
            this.showcalendar.set(5, this.getSelectedDay());
            this.showcalendar.set(11, this.getSelectedHour());
            this.showcalendar.set(12, this.getSelectedMinite());
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.SECOND)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
            this.showcalendar.set(5, this.getSelectedDay());
            this.showcalendar.set(11, this.getSelectedHour());
            this.showcalendar.set(12, this.getSelectedMinite());
            this.showcalendar.set(13, this.getSelectedSecond());
        } else if (this.showprecision != null && this.showprecision.equals((Object)EdalDatePrecision.MILLISECOND)) {
            this.showcalendar.set(1, this.getSelectedYear());
            this.showcalendar.set(2, this.getSelectedMonth() - 1);
            this.showcalendar.set(5, this.getSelectedDay());
            this.showcalendar.set(11, this.getSelectedHour());
            this.showcalendar.set(12, this.getSelectedMinite());
            this.showcalendar.set(13, this.getSelectedSecond());
            this.showcalendar.set(14, this.getSelectedMillisecond());
        }
    }
}

