/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDatePrecision;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalDateChooser;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalDateFormat;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class EdalDateTimePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private EdalDateChooser dateChooser = null;
    private JTextField text;
    private JLabel label;

    public EdalDateTimePicker(final EdalDate edaldate) {
        this.setBorder(null);
        this.setCursor(new Cursor(12));
        this.setLayout((LayoutManager)new MigLayout("", "[20%!][20%!][20%!][20%!]1[20%!]", ""));
        this.text = new JTextField();
        this.text.setHorizontalAlignment(0);
        this.text.setEditable(true);
        this.add((Component)this.text, "cell 0 0 4 1,width max(80%, 80%)");
        ImageIcon icon = ImageUtil.createImageIcon("dateIcon.gif", "choose new datetime");
        this.label = new JLabel(icon);
        this.label.setToolTipText("choose new datetime");
        this.add((Component)this.label, "cell 4 0 1 1");
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int returnVal;
                if (EdalDateTimePicker.this.dateChooser == null) {
                    EdalDateTimePicker.this.dateChooser = new EdalDateChooser(edaldate, false);
                }
                if ((returnVal = EdalDateTimePicker.this.dateChooser.showDateChooser()) == 0) {
                    EdalDateTimePicker.this.setDate(EdalDateTimePicker.this.dateChooser.getCalendar().getTime());
                }
            }
        });
    }

    public void reset() {
        if (this.dateChooser != null) {
            this.dateChooser.reset();
        }
        this.text.setText("");
    }

    public Calendar getCalendar() {
        if (this.dateChooser != null) {
            return this.dateChooser.getCalendar();
        }
        return null;
    }

    public EdalDatePrecision getPrecision() {
        if (this.dateChooser != null) {
            return this.dateChooser.getPrecision();
        }
        return null;
    }

    private void setDate(Date date) {
        this.text.setText(EdalDateFormat.getDefaultDateFormat(this.getPrecision()).format(date));
    }
}

