/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.DateEvents;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EdalDate;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntityVersion;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalConfigDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalMutableTreeModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalNode;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.EdalTableModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.PermissionDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.TreeWillExpandListenerAction;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataSaveDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.CheckSumViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.DataFormatViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.DateEventsViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.IdentifierRelationViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.IdentifierViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.LanguageViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.LegalPersonInfoViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.MetadataViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.PersonInfoViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.SubjectViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.TextViewer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer.ViewerContainer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalAbstractFileFilter;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalFileHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTable;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTitleDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalTreeCellRenderer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.InfiniteProgressPanel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.JLinkLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.JVersionLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.LailapsJXTaskPane;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.MetaDescription;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PrincipalUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.UiUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusBar;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.XStatusSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTaskPaneContainer;

public class EdalFileChooser
extends EdalTitleDialog {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("Courier New", 0, 12);
    private DefaultTableModel defaultModel = null;
    private ClientPrimaryDataDirectory rootDirectory = null;
    private JTable filemetatable = null;
    private final List<String> metadatatoshow = new ArrayList<String>();
    private final List<ClientPrimaryDataEntity> filelist = new ArrayList<ClientPrimaryDataEntity>();
    private final List<ClientPrimaryDataEntityVersion> versionlist = new ArrayList<ClientPrimaryDataEntityVersion>();
    private ClientPrimaryDataEntityVersion currentversion;
    private final Map<String, ClientPrimaryDataEntityVersion> currentversionmap = new HashMap<String, ClientPrimaryDataEntityVersion>();
    private final Map<String, JTextField> detailmap = new HashMap<String, JTextField>();
    private boolean bindui = false;
    private final JLabel pathlabel = new JLabel("Path:", 2);
    protected final JTextField pathtext = new JTextField();
    protected ClientPrimaryDataEntity selectedFile = null;
    private final JTextField searchtext = new JTextField();
    protected ClientPrimaryDataDirectory currentdir;
    private DefaultMutableTreeNode currentnode;
    protected JButton okbutton;
    private int returnvalue = 1;
    private int[] selectrows;
    private EdalAbstractFileFilter fileFilter = null;
    private int fileSelectionMode = 0;
    private boolean savemodal = false;
    private int fileselectindex;
    private String username = null;
    private static final String CHANGEMETADATAMETHODNAME = "setMetaData";
    private static final String CHANGEPERMISSIONTHODNAME = "grantPermission";
    private JSplitPane dirshowpane;
    private JSplitPane tableshowpane;
    private JPanel detailpanelparent;
    private JScrollPane treepanelparent;
    private LailapsJXTaskPane versionpanel;
    private LailapsJXTaskPane detailpanel;
    private JTree tree;
    private JButton configbutton = new JButton("eDAL Configration");
    private JButton metadatabutton = new JButton("ChangeMetadata");
    private JButton permissionbutton = new JButton("ChangePermissions");
    private Color tablebackcolor = null;
    private XStatusBar statusbar = null;
    private boolean showconnbutton = false;
    private final JPanel centerPane = new JPanel();
    private boolean isSelected = false;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static final int TEXTLIMIT = 40;
    private static final int TOOLTIPSLEN = 20;
    private static final int METADATALEN = 80;
    private boolean multiSelectionEnabled = false;
    private final Map<String, String> tipsmap = new HashMap<String, String>();
    private int row;
    private int column;
    private ClientDataManager client = null;
    private final Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalFileChooser.this.selectedFile = null;
            EdalFileChooser.this.returnvalue = 1;
            EdalFileChooser.this.dispose();
        }
    };
    private final Action searchAction = new AbstractAction("Search"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            EdalFileChooser.this.search(EdalFileChooser.this.searchtext.getText().trim());
        }
    };
    private JXTaskPaneContainer metainfocontainer;

    public EdalFileChooser(Dialog owner, ClientDataManager client) {
        super((Window)owner);
        if (client != null) {
            this.client = client;
            try {
                this.rootDirectory = client.getRootDirectory();
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            catch (EdalAuthenticateException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            catch (NotBoundException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            catch (EdalException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            this.username = client.getAuthentication().getName();
            this.statusbar = new XStatusBar(client.getServerAddress(), client.getRegistryPort(), this.username);
        }
    }

    public EdalFileChooser(Frame owner, ClientDataManager client) {
        super((Window)owner);
        if (client != null) {
            this.client = client;
            try {
                this.rootDirectory = client.getRootDirectory();
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            catch (EdalAuthenticateException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            catch (NotBoundException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            catch (EdalException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            this.username = client.getAuthentication().getName();
            this.statusbar = new XStatusBar(client.getServerAddress(), client.getRegistryPort(), this.username);
        }
    }

    private DefaultMutableTreeNode addNodes(DefaultMutableTreeNode curTop, ClientPrimaryDataDirectory parentdir) {
        EdalMutableTreeModel curDir = null;
        try {
            curDir = new EdalMutableTreeModel(new EdalNode(parentdir.getName(), parentdir.getPath()));
            if (curTop != null) {
                curTop.add(curDir);
            }
            if (parentdir.isDirectory()) {
                List<ClientPrimaryDataEntity> dirlist = parentdir.listPrimaryDataEntities();
                ArrayList<String> dirnamelist = new ArrayList<String>();
                HashMap<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();
                if (dirlist != null) {
                    for (ClientPrimaryDataEntity dir : dirlist) {
                        ClientPrimaryDataEntityVersion version = null;
                        try {
                            version = dir.getCurrentVersion();
                            if (!dir.isDirectory() || version.isDeleted()) continue;
                            dirnamelist.add(dir.getName());
                            dirnamemap.put(dir.getName(), dir);
                        }
                        catch (Exception exception) {}
                    }
                }
                Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);
                for (String dirname : dirnamelist) {
                    EdalMutableTreeModel child = new EdalMutableTreeModel(new EdalNode(dirname, ((ClientPrimaryDataDirectory)dirnamemap.get(dirname)).getPath()));
                    curDir.add(child);
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError((Exception)((Object)e));
        }
        return curDir;
    }

    private void buidversionpanel(LailapsJXTaskPane versionpanel, ClientPrimaryDataEntityVersion[] versionarray) throws RemoteException {
        int iversionlen;
        int versioncolumnlen;
        versionpanel.setJSplitPane(this.tableshowpane);
        versionpanel.setFriendpanel(this.detailpanel);
        this.detailpanel.setFriendpanel(versionpanel);
        versionpanel.setName("Version Information");
        ((JComponent)versionpanel.getContentPane()).setBorder(BorderFactory.createEmptyBorder());
        versionpanel.setTitle("Version Information");
        if (!versionpanel.isCollapsed()) {
            versionpanel.setCollapsed(true);
            versionpanel.setScrollOnExpand(true);
        }
        if ((versioncolumnlen = (iversionlen = versionarray.length) / 2) * 2 < iversionlen) {
            ++versioncolumnlen;
        }
        ArrayList<JVersionLabel> versionbuttonlist = new ArrayList<JVersionLabel>();
        versionpanel.removeAll();
        versionpanel.setLayout((LayoutManager)new MigLayout("", "[45%!][10%!][45%!]", "[]0"));
        for (int i = 0; i < versioncolumnlen; ++i) {
            String strdate = null;
            SimpleDateFormat dataformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            if (versionarray[i * 2].getRevisionDate() != null) {
                strdate = dataformat.format(versionarray[i * 2].getRevisionDate().getTime());
            }
            JVersionLabel label1 = new JVersionLabel("Version " + versionarray[i * 2].getRevision() + " : " + strdate + (versionarray[i * 2].isDeleted() ? " - deleted." : ""));
            label1.setVerticalAlignment(0);
            label1.setFont(FONT);
            versionbuttonlist.add(label1);
            label1.addMouseListener(new LinkMouseListener(versionbuttonlist, i * 2, this.detailpanelparent));
            versionpanel.add(label1, "cell 0 " + i + " 1 1");
            this.versionlist.add(versionarray[i * 2]);
            if (i * 2 + 1 >= versionarray.length) continue;
            strdate = dataformat.format(versionarray[i * 2 + 1].getRevisionDate().getTime());
            JVersionLabel label2 = new JVersionLabel("Version " + versionarray[i * 2 + 1].getRevision() + " : " + strdate + (versionarray[i * 2 + 1].isDeleted() ? " - deleted." : ""));
            label2.setVerticalAlignment(0);
            label2.setFont(FONT);
            label2.addMouseListener(new LinkMouseListener(versionbuttonlist, i * 2 + 1, this.detailpanelparent));
            versionpanel.add(label2, "cell 2 " + i + " 1 1");
            this.versionlist.add(versionarray[i * 2 + 1]);
            versionbuttonlist.add(label2);
        }
        if (versionbuttonlist.size() > 0) {
            ((JVersionLabel)versionbuttonlist.get(versionbuttonlist.size() - 1)).setSelect(true);
            String strdate = null;
            SimpleDateFormat dataformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            if (this.versionlist.get(this.versionlist.size() - 1).getRevisionDate() != null) {
                strdate = dataformat.format(this.versionlist.get(this.versionlist.size() - 1).getRevisionDate().getTime());
            }
            this.versionpanel.setTitle("Version " + this.versionlist.get(this.versionlist.size() - 1).getRevision() + " :  " + strdate + (this.versionlist.get(this.versionlist.size() - 1).isDeleted() ? " - deleted." : ""));
        }
    }

    private void buildDetail(JPanel detailpanelparent, ClientPrimaryDataEntity dataentry, boolean refreshversion) {
        UntypedData data;
        String dataName;
        String metaabstract;
        this.showmetabutton(dataentry);
        this.showpermissionbutton(dataentry);
        ArrayList<String> columnlist = new ArrayList<String>();
        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
            try {
                String dataName2 = elem.toString();
                columnlist.add(dataName2);
            }
            catch (UnsupportedOperationException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
        }
        String[] columnNames = columnlist.toArray(new String[0]);
        int ilen = columnNames.length;
        int columnlen = ilen / 2;
        if (columnlen * 2 < ilen) {
            ++columnlen;
        }
        if (!this.bindui) {
            this.metainfocontainer = new JXTaskPaneContainer();
            this.metainfocontainer.setBackground(new Color(238, 238, 238));
            this.detailpanel = new LailapsJXTaskPane();
            this.detailpanel.setBackground(new Color(238, 238, 238));
            this.detailpanel.setJSplitPane(this.tableshowpane);
            this.detailpanel.setName("Metadata Information");
            ((JComponent)this.detailpanel.getContentPane()).setBorder(BorderFactory.createEmptyBorder());
            try {
                metaabstract = dataentry.getMetaData().toString();
                if (metaabstract.length() > 80) {
                    metaabstract = metaabstract.substring(0, 80) + "...";
                }
                this.detailpanel.setTitle("Metadata : " + metaabstract);
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            if (!this.detailpanel.isCollapsed()) {
                this.detailpanel.setCollapsed(true);
                this.detailpanel.setScrollOnExpand(true);
            }
            this.detailpanel.removeAll();
            this.detailpanel.setLayout((LayoutManager)new MigLayout("", "[80][50%][80][50%]", "[]0"));
            for (int i = 0; i < columnlen; ++i) {
                JLinkLabel label1 = new JLinkLabel(columnNames[i * 2].toString() + ":", 2);
                label1.setVerticalAlignment(0);
                label1.setFont(FONT);
                label1.setToolTipText("<html>" + MetaDescription.getDescription(columnNames[i * 2].toString()) + "</html>");
                this.detailpanel.add(label1, "cell 0 " + i + " 1 1");
                JTextField text1 = new JTextField();
                text1.setFont(FONT);
                this.detailpanel.add(text1, "cell 1 " + i + " 1 1,growx");
                this.detailmap.put(columnNames[i * 2].toString(), text1);
                if (i * 2 + 1 >= columnNames.length) continue;
                JLinkLabel label2 = new JLinkLabel(columnNames[i * 2 + 1].toString() + ":", 2);
                label2.setVerticalAlignment(0);
                label2.setFont(FONT);
                label2.setToolTipText("<html>" + MetaDescription.getDescription(columnNames[i * 2 + 1].toString()) + "</html>");
                this.detailpanel.add(label2, "cell 2 " + i + " 1 1");
                JTextField text2 = new JTextField();
                text2.setFont(FONT);
                this.detailpanel.add(text2, "cell 3 " + i + " 1 1,growx");
                this.detailmap.put(columnNames[i * 2 + 1].toString(), text2);
            }
            this.metainfocontainer.add((Component)((Object)this.detailpanel));
            try {
                SortedSet<ClientPrimaryDataEntityVersion> versions = dataentry.getVersions();
                if (versions != null) {
                    ClientPrimaryDataEntityVersion[] versionarray = versions.toArray(new ClientPrimaryDataEntityVersion[0]);
                    this.versionpanel = new LailapsJXTaskPane();
                    this.buidversionpanel(this.versionpanel, versionarray);
                    this.metainfocontainer.add((Component)((Object)this.versionpanel));
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
            detailpanelparent.add((Component)new JScrollPane((Component)this.metainfocontainer), "Center");
            this.bindui = true;
        }
        try {
            metaabstract = dataentry.getMetaData().toString();
            if (metaabstract.length() > 80) {
                metaabstract = metaabstract.substring(0, 80) + "...";
            }
            this.detailpanel.setTitle("Metadata : " + metaabstract);
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        try {
            MetaData filemetadata = this.currentversionmap.containsKey(dataentry.getPath()) ? this.getEntityVersionMetaData(dataentry, this.currentversionmap.get(dataentry.getPath())) : dataentry.getCurrentVersion().getMetaData();
            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                dataName = elem.toString();
                try {
                    data = filemetadata.getElementValue((Enum)elem);
                    if (!this.detailmap.containsKey(dataName)) continue;
                    final MetadataViewer viewer = ViewerContainer.getViewer(EnumDublinCoreElements.valueOf((String)dataName));
                    if (viewer != null) {
                        for (MouseListener al : this.detailmap.get(dataName).getMouseListeners()) {
                            this.detailmap.get(dataName).removeMouseListener(al);
                        }
                        this.detailmap.get(dataName).addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() == 2) {
                                    viewer.setValue(data);
                                    viewer.setTitle(dataName);
                                    viewer.showOpenDialog();
                                }
                            }
                        });
                        continue;
                    }
                    this.detailmap.get(dataName).setEditable(false);
                }
                catch (MetaDataException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError((Exception)((Object)e));
                }
            }
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        try {
            MetaData filemetadata = this.currentversionmap.containsKey(dataentry.getPath()) ? this.getEntityVersionMetaData(dataentry, this.currentversionmap.get(dataentry.getPath())) : dataentry.getCurrentVersion().getMetaData();
            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                dataName = elem.toString();
                try {
                    data = filemetadata.getElementValue((Enum)elem);
                    String value = data.toString();
                    if (!this.detailmap.containsKey(dataName)) continue;
                    this.detailmap.get(dataName).setText(value);
                    this.detailmap.get(dataName).setCaretPosition(0);
                    if (value.trim().length() <= 0) continue;
                    this.detailmap.get(dataName).setToolTipText(this.formattooltips(value));
                }
                catch (MetaDataException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError((Exception)((Object)e));
                }
            }
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        this.selectedFile = dataentry;
        if (refreshversion) {
            try {
                SortedSet<ClientPrimaryDataEntityVersion> versions = dataentry.getVersions();
                this.versionlist.clear();
                if (versions != null) {
                    ClientPrimaryDataEntityVersion[] versionarray = versions.toArray(new ClientPrimaryDataEntityVersion[0]);
                    this.buidversionpanel(this.versionpanel, versionarray);
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
        }
    }

    private EdalTableModel buildtable(List<ClientPrimaryDataEntity> dirlist) {
        ArrayList<String> rowlist;
        this.tipsmap.clear();
        this.row = 0;
        this.column = 0;
        ArrayList<String> columnlist = new ArrayList<String>();
        columnlist.add("TITLE");
        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
            String dataName = elem.toString();
            if (!this.metadatatoshow.contains(dataName)) continue;
            columnlist.add(dataName);
        }
        Object[] columnNames = columnlist.toArray(new String[0]);
        ArrayList datalist = new ArrayList();
        if (dirlist != null) {
            Collections.sort(dirlist);
            for (ClientPrimaryDataEntity dataentry : dirlist) {
                String value;
                String tvalue;
                String dataName;
                MetaData filemetadata;
                try {
                    try {
                        dataentry.getCurrentVersion();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (dataentry.getCurrentVersion().isDeleted()) {
                        continue;
                    }
                }
                catch (RemoteException e1) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                    ErrorDialog.showError(e1);
                }
                if (this.fileSelectionMode == 2) {
                    try {
                        if (!dataentry.isDirectory() && (this.fileFilter == null || this.fileFilter.accept((ClientPrimaryDataFile)dataentry))) {
                            rowlist = new ArrayList<String>();
                            rowlist.add(dataentry.getName());
                            filemetadata = dataentry.getCurrentVersion().getMetaData();
                            for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                                dataName = elem.toString();
                                try {
                                    if (!this.metadatatoshow.contains(dataName)) continue;
                                    if ("DATE".equals(dataName)) {
                                        tvalue = null;
                                        DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                        Set dataset = tdataevents.getSet();
                                        for (EdalDate edaldate : dataset) {
                                            if (!"UPDATED".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                        if (tvalue == null) {
                                            for (EdalDate edaldate : dataset) {
                                                if (!"CREATED".equals(edaldate.getEvent())) continue;
                                                tvalue = edaldate.toString();
                                                break;
                                            }
                                        }
                                        rowlist.add(tvalue);
                                        continue;
                                    }
                                    value = filemetadata.getElementValue((Enum)elem).toString();
                                    if (value != null && value.length() > 40) {
                                        int itemprow = datalist.size() + 1;
                                        int itempcol = rowlist.size() + 1;
                                        this.tipsmap.put(itemprow + "," + itempcol, value);
                                        rowlist.add(value.substring(0, 40) + "...");
                                        continue;
                                    }
                                    rowlist.add(value);
                                }
                                catch (MetaDataException e) {
                                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                                    ErrorDialog.showError((Exception)((Object)e));
                                }
                            }
                            datalist.add(rowlist);
                            this.filelist.add(dataentry);
                            continue;
                        }
                        if (!dataentry.isDirectory()) continue;
                        rowlist = new ArrayList();
                        rowlist.add(dataentry.getName());
                        filemetadata = dataentry.getCurrentVersion().getMetaData();
                        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                            dataName = elem.toString();
                            try {
                                if (!this.metadatatoshow.contains(dataName)) continue;
                                if ("DATE".equals(dataName)) {
                                    tvalue = null;
                                    DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                    Set dataset = tdataevents.getSet();
                                    for (EdalDate edaldate : dataset) {
                                        if (!"UPDATED".equals(edaldate.getEvent())) continue;
                                        tvalue = edaldate.toString();
                                        break;
                                    }
                                    if (tvalue == null) {
                                        for (EdalDate edaldate : dataset) {
                                            if (!"CREATED".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                    }
                                    rowlist.add(tvalue);
                                    continue;
                                }
                                value = filemetadata.getElementValue((Enum)elem).toString();
                                if (value != null && value.length() > 40) {
                                    int itemprow = datalist.size() + 1;
                                    int itempcol = rowlist.size() + 1;
                                    this.tipsmap.put(itemprow + "," + itempcol, value);
                                    rowlist.add(value.substring(0, 40) + "...");
                                    continue;
                                }
                                rowlist.add(value);
                            }
                            catch (MetaDataException e) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                                ErrorDialog.showError((Exception)((Object)e));
                            }
                        }
                        datalist.add(rowlist);
                        this.filelist.add(dataentry);
                    }
                    catch (RemoteException e) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                        ErrorDialog.showError(e);
                    }
                    continue;
                }
                if (this.fileSelectionMode == 1) {
                    try {
                        if (!dataentry.isDirectory()) continue;
                        rowlist = new ArrayList();
                        rowlist.add(dataentry.getName());
                        filemetadata = dataentry.getCurrentVersion().getMetaData();
                        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                            dataName = elem.toString();
                            try {
                                if (!this.metadatatoshow.contains(dataName)) continue;
                                if ("DATE".equals(dataName)) {
                                    tvalue = null;
                                    DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                    Set dataset = tdataevents.getSet();
                                    for (EdalDate edaldate : dataset) {
                                        if (!"UPDATED".equals(edaldate.getEvent())) continue;
                                        tvalue = edaldate.toString();
                                        break;
                                    }
                                    if (tvalue == null) {
                                        for (EdalDate edaldate : dataset) {
                                            if (!"CREATED".equals(edaldate.getEvent())) continue;
                                            tvalue = edaldate.toString();
                                            break;
                                        }
                                    }
                                    rowlist.add(tvalue);
                                    continue;
                                }
                                value = filemetadata.getElementValue((Enum)elem).toString();
                                if (value != null && value.length() > 40) {
                                    int itemprow = datalist.size() + 1;
                                    int itempcol = rowlist.size() + 1;
                                    this.tipsmap.put(itemprow + "," + itempcol, value);
                                    rowlist.add(value.substring(0, 40) + "...");
                                    continue;
                                }
                                rowlist.add(value);
                            }
                            catch (MetaDataException e) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                                ErrorDialog.showError((Exception)((Object)e));
                            }
                        }
                        datalist.add(rowlist);
                        this.filelist.add(dataentry);
                    }
                    catch (RemoteException e) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                        ErrorDialog.showError(e);
                    }
                    continue;
                }
                if (this.fileSelectionMode != 0) continue;
                try {
                    if (dataentry.isDirectory() || this.fileFilter != null && !this.fileFilter.accept((ClientPrimaryDataFile)dataentry)) continue;
                    rowlist = new ArrayList();
                    rowlist.add(dataentry.getName());
                    filemetadata = dataentry.getCurrentVersion().getMetaData();
                    for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                        try {
                            dataName = elem.toString();
                            if (!this.metadatatoshow.contains(dataName)) continue;
                            value = filemetadata.getElementValue((Enum)elem).toString();
                            if ("DATE".equals(dataName)) {
                                String tvalue2 = null;
                                DateEvents tdataevents = (DateEvents)filemetadata.getElementValue((Enum)elem);
                                Set dataset = tdataevents.getSet();
                                for (EdalDate edaldate : dataset) {
                                    if (!"UPDATED".equals(edaldate.getEvent())) continue;
                                    tvalue2 = edaldate.toString();
                                    break;
                                }
                                if (tvalue2 == null) {
                                    for (EdalDate edaldate : dataset) {
                                        if (!"CREATED".equals(edaldate.getEvent())) continue;
                                        tvalue2 = edaldate.toString();
                                        break;
                                    }
                                }
                                rowlist.add(tvalue2);
                                continue;
                            }
                            if (value != null && value.length() > 40) {
                                int itemprow = datalist.size() + 1;
                                int itempcol = rowlist.size() + 1;
                                this.tipsmap.put(itemprow + "," + itempcol, value);
                                rowlist.add(value.substring(0, 40) + "...");
                                continue;
                            }
                            rowlist.add(value);
                        }
                        catch (MetaDataException e) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                            ErrorDialog.showError((Exception)((Object)e));
                        }
                    }
                    datalist.add(rowlist);
                    this.filelist.add(dataentry);
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError(e);
                }
            }
        }
        Object[][] rowData = new Object[datalist.size()][columnNames.length];
        for (int i = 0; i < datalist.size(); ++i) {
            rowlist = (ArrayList<String>)datalist.get(i);
            for (int j = 0; j < rowlist.size(); ++j) {
                rowData[i][j] = rowlist.get(j);
            }
        }
        return new EdalTableModel(rowData, columnNames);
    }

    private void changemetadata(ClientPrimaryDataEntity dataentry, Map<EnumDublinCoreElements, UntypedData> metadatavalue, boolean refreshversion) {
        if (metadatavalue != null) {
            try {
                MetaData fileMetaData = dataentry.getMetaData().clone();
                for (Map.Entry<EnumDublinCoreElements, UntypedData> entry : metadatavalue.entrySet()) {
                    EnumDublinCoreElements key = entry.getKey();
                    UntypedData val = entry.getValue();
                    fileMetaData.setElementValue(key, val);
                }
                dataentry.setMetaData(fileMetaData);
                this.buildDetail(this.detailpanelparent, dataentry, refreshversion);
            }
            catch (Exception re) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(re));
                ErrorDialog.showError(re);
            }
        }
    }

    private void checkpanelRightClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPanel panel = (JPanel)e.getComponent();
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            JPopupMenu popupMenu1 = new JPopupMenu();
            if (this.filelist.size() > 0 && this.filelist.get(this.fileselectindex) != null) {
                if (!PrincipalUtil.checkPermission(this.filelist.get(this.fileselectindex), this.username, CHANGEMETADATAMETHODNAME)) {
                    return;
                }
                popupMenu1.add(metadatamenu);
            } else if (this.currentdir != null) {
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    return;
                }
                popupMenu1.add(metadatamenu);
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex));
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                            EdalFileChooser.this.changemetadata((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), metadatavalue, true);
                        }
                    } else {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                            EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                        }
                    }
                }
            });
            popupMenu1.show(panel, e.getX(), e.getY());
        }
    }

    private void checktableRightClick(MouseEvent evt, final JTree tree) {
        if (evt.isPopupTrigger()) {
            final int rightclickrow = evt.getY() / this.filemetatable.getRowHeight();
            JMenuItem del = new JMenuItem("Delete");
            JMenuItem rename = new JMenuItem("Rename");
            JMenuItem permissionmenu = new JMenuItem("Change Permissions");
            JPopupMenu popupMenu = new JPopupMenu();
            if (this.savemodal) {
                popupMenu.add(del);
                popupMenu.add(rename);
            }
            if (this.filelist.size() > 0 && PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEPERMISSIONTHODNAME) && this.filelist.get(rightclickrow) != null) {
                popupMenu.add(permissionmenu);
            }
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            if (this.filelist.size() > 0 && this.filelist.get(this.fileselectindex) != null) {
                popupMenu.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.filelist.get(this.fileselectindex), this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            } else if (this.currentdir != null) {
                popupMenu.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex));
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                            EdalFileChooser.this.changemetadata((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), metadatavalue, true);
                        }
                    } else {
                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                        int returnVal = metadlg.showOpenDialog();
                        if (returnVal == 0) {
                            Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                            EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                        }
                    }
                }
            });
            del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block10: {
                        Object[] buttons = new String[]{"Yes", "No"};
                        int rc = JOptionPane.showOptionDialog(null, "Do you want to delete?", "e!DAL-FileChooser", 1, 0, null, buttons, buttons[1]);
                        if (rc == 0) {
                            try {
                                if (EdalFileChooser.this.filelist.size() <= 0) break block10;
                                boolean shouldfresh = false;
                                if (((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).isDirectory()) {
                                    shouldfresh = true;
                                }
                                ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).delete();
                                EdalFileChooser.this.filelist.remove(rightclickrow);
                                List<ClientPrimaryDataEntity> dirlist = null;
                                try {
                                    dirlist = EdalFileChooser.this.currentdir.listPrimaryDataEntities();
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                    ErrorDialog.showError((Exception)((Object)e1));
                                }
                                if (dirlist != null) {
                                    EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(dirlist);
                                    EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                                    EdalFileChooser.this.defaultModel.fireTableDataChanged();
                                    UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable, 631);
                                }
                                if (shouldfresh) {
                                    EdalFileChooser.this.currentnode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                                    EdalFileChooser.this.refreshtreenode(tree);
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError(e1);
                            }
                            catch (PrimaryDataEntityVersionException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError((Exception)((Object)e1));
                            }
                            catch (PrimaryDataDirectoryException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError((Exception)((Object)e1));
                            }
                        }
                    }
                }
            });
            rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block14: {
                        String s = null;
                        try {
                            s = JOptionPane.showInputDialog(null, "Please input directoy name:", ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).getName());
                        }
                        catch (RemoteException e2) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e2));
                            ErrorDialog.showError(e2);
                        }
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:[" + s.trim() + "] already exists!\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                        break block14;
                                    }
                                    try {
                                        ((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).rename(s.trim());
                                        List<ClientPrimaryDataEntity> dirlist = null;
                                        try {
                                            dirlist = EdalFileChooser.this.currentdir.listPrimaryDataEntities();
                                        }
                                        catch (PrimaryDataDirectoryException e1) {
                                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                            ErrorDialog.showError((Exception)((Object)e1));
                                        }
                                        if (dirlist != null) {
                                            EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(dirlist);
                                            EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                                            EdalFileChooser.this.defaultModel.fireTableDataChanged();
                                            UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable, 631);
                                        }
                                        if (((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow)).isDirectory()) {
                                            EdalFileChooser.this.refreshtreenode(tree);
                                        }
                                    }
                                    catch (PrimaryDataEntityVersionException e1) {
                                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                        ErrorDialog.showError((Exception)((Object)e1));
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                    ErrorDialog.showError((Exception)((Object)e1));
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError(e1);
                            }
                        }
                    }
                }
            });
            permissionmenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionDialog permission = new PermissionDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(rightclickrow), EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            });
            popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void checktreeRightClick(MouseEvent e) {
        if (e.isPopupTrigger()) {
            final JTree tree = (JTree)e.getComponent();
            TreePath path = tree.getPathForLocation(e.getX(), e.getY());
            tree.setSelectionPath(path);
            JMenuItem del = new JMenuItem("Delete Directory");
            JMenuItem rename = new JMenuItem("Rename Directory");
            JMenuItem newFile = new JMenuItem("New Directory");
            JMenuItem permissionmenu = new JMenuItem("Change Permissions");
            JMenuItem metadatamenu = new JMenuItem("Change Metadata");
            JPopupMenu popupMenu1 = new JPopupMenu();
            if (this.savemodal) {
                if (this.currentnode != null) {
                    popupMenu1.add(newFile);
                }
                if (path != null && path.getParentPath() != null) {
                    popupMenu1.add(del);
                    popupMenu1.add(rename);
                }
            }
            if (this.currentnode != null && PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEPERMISSIONTHODNAME)) {
                popupMenu1.add(permissionmenu);
            }
            permissionmenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionDialog permission = new PermissionDialog(EdalFileChooser.this.currentdir, EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            });
            if (this.currentdir != null) {
                popupMenu1.add(metadatamenu);
                if (!PrincipalUtil.checkPermission(this.currentdir, this.username, CHANGEMETADATAMETHODNAME)) {
                    metadatamenu.setEnabled(false);
                }
            }
            metadatamenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MetaDataSaveDialog metadlg = new MetaDataSaveDialog(EdalFileChooser.this.currentdir);
                    int returnVal = metadlg.showOpenDialog();
                    if (returnVal == 0) {
                        Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                        EdalFileChooser.this.changemetadata(EdalFileChooser.this.currentdir, metadatavalue, false);
                    }
                }
            });
            del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] buttons = new String[]{"Yes", "No"};
                    int rc = JOptionPane.showOptionDialog(null, "Do you want to delete current directory?", "e!DAL-FileChooser", 1, 0, null, buttons, buttons[1]);
                    if (rc == 0) {
                        try {
                            EdalFileChooser.this.currentdir.delete();
                            ((DefaultMutableTreeNode)EdalFileChooser.this.currentnode.getParent()).remove(EdalFileChooser.this.currentnode);
                            EdalFileChooser.this.cleartable();
                            tree.updateUI();
                        }
                        catch (RemoteException e1) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                            ErrorDialog.showError(e1);
                        }
                        catch (PrimaryDataEntityVersionException e1) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                            ErrorDialog.showError((Exception)((Object)e1));
                        }
                        catch (PrimaryDataDirectoryException e1) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                            ErrorDialog.showError((Exception)((Object)e1));
                        }
                    }
                }
            });
            newFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block14: {
                        String s = JOptionPane.showInputDialog("Please input directoy name:");
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory [" + s.trim() + "] already exists!\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                        break block14;
                                    }
                                    if (s.indexOf("\\") >= 0 || s.indexOf("/") >= 0 || s.indexOf(":") >= 0 || s.indexOf("?") >= 0 || s.indexOf(">") >= 0 || s.indexOf("<") >= 0 || s.indexOf("|") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("\\") >= 0) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory name cannot contain any of the following characters:\\ / : * ? \" < > | !\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                        break block14;
                                    }
                                    try {
                                        if (EdalFileChooser.this.isexistdeleteversion(EdalFileChooser.this.currentdir, s.trim())) {
                                            JOptionPane.showMessageDialog(null, "Error:A deleted directory [" + s.trim() + "] already exists!\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                            return;
                                        }
                                        ClientPrimaryDataDirectory childdir = EdalFileChooser.this.currentdir.createPrimaryDataDirectory(s.trim());
                                        MetaDataSaveDialog metadlg = new MetaDataSaveDialog(childdir);
                                        int returnVal = metadlg.showOpenDialog();
                                        Map<EnumDublinCoreElements, UntypedData> metadatavalue = returnVal == 0 ? metadlg.getMetaDataValues() : null;
                                        if (metadatavalue != null) {
                                            try {
                                                MetaData fileMetaData = childdir.getMetaData().clone();
                                                for (Map.Entry<EnumDublinCoreElements, UntypedData> entry : metadatavalue.entrySet()) {
                                                    EnumDublinCoreElements key = entry.getKey();
                                                    UntypedData val = entry.getValue();
                                                    fileMetaData.setElementValue(key, val);
                                                }
                                                childdir.setMetaData(fileMetaData);
                                            }
                                            catch (Exception re) {
                                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(re));
                                                ErrorDialog.showError(re);
                                            }
                                        }
                                        final EdalMutableTreeModel newChild = new EdalMutableTreeModel(new EdalNode(s.trim(), childdir.getPath()));
                                        EdalFileChooser.this.refreshtreenode(tree);
                                        EdalFileChooser.this.refreshtable();
                                        EdalFileChooser.this.selectedFile = childdir;
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                tree.expandPath(new TreePath(newChild.getPath()));
                                                EdalFileChooser.this.scrollPathToVisible(new TreePath(newChild.getPath()));
                                                tree.setSelectionPath(new TreePath(newChild.getPath()));
                                            }
                                        });
                                    }
                                    catch (AccessControlException se) {
                                        JOptionPane.showMessageDialog(null, "Can't create directory:" + se.getMessage(), "e!DAL-FileChooser", 0);
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                    ErrorDialog.showError((Exception)((Object)e1));
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError(e1);
                            }
                        }
                    }
                }
            });
            rename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block11: {
                        String s = null;
                        try {
                            s = JOptionPane.showInputDialog(null, "Please input directoy name:", EdalFileChooser.this.currentdir.getName());
                        }
                        catch (RemoteException e2) {
                            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e2));
                            ErrorDialog.showError(e2);
                        }
                        if (s != null && s.trim().length() > 0) {
                            try {
                                try {
                                    if (EdalFileChooser.this.currentdir.getParentDirectory().exist(s.trim())) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory [" + s.trim() + "] already exists!\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                        break block11;
                                    }
                                    if (s.indexOf("\\") >= 0 || s.indexOf("/") >= 0 || s.indexOf(":") >= 0 || s.indexOf("?") >= 0 || s.indexOf(">") >= 0 || s.indexOf("<") >= 0 || s.indexOf("|") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("\\") >= 0) {
                                        JOptionPane.showMessageDialog(null, "Error:Directory name cannot contain any of the following characters:\\ / : * ? \" < > | !\nPlease specify a different name.", "e!DAL-FileChooser", 0);
                                        break block11;
                                    }
                                    try {
                                        EdalFileChooser.this.currentdir.rename(s.trim());
                                        EdalNode mynode = (EdalNode)EdalFileChooser.this.currentnode.getUserObject();
                                        mynode.setName(s.trim());
                                        mynode.setPath(EdalFileChooser.this.currentdir.getPath());
                                        EdalFileChooser.this.currentnode.setUserObject(mynode);
                                        tree.updateUI();
                                    }
                                    catch (PrimaryDataEntityVersionException e1) {
                                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                        ErrorDialog.showError((Exception)((Object)e1));
                                    }
                                }
                                catch (PrimaryDataDirectoryException e1) {
                                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                    ErrorDialog.showError((Exception)((Object)e1));
                                }
                            }
                            catch (RemoteException e1) {
                                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                                ErrorDialog.showError(e1);
                            }
                        }
                    }
                }
            });
            popupMenu1.show(tree, e.getX(), e.getY());
        }
    }

    private void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.tree.makeVisible(treePath);
            this.tree.expandPath(treePath);
            Rectangle bounds = this.tree.getPathBounds(treePath);
            if (bounds != null) {
                bounds.x = 0;
                this.tree.scrollRectToVisible(bounds);
            }
        }
    }

    private void cleanbuttonevent(JButton button) {
        if (button != null) {
            for (ActionListener al : button.getActionListeners()) {
                button.removeActionListener(al);
            }
        }
    }

    private void cleartable() {
        if (this.defaultModel != null) {
            int irow = this.defaultModel.getRowCount();
            for (int i = 0; i < irow; ++i) {
                this.defaultModel.removeRow(0);
            }
        }
        this.filelist.clear();
        this.selectedFile = null;
    }

    private void disablemetadata() {
        this.metadatabutton.setVisible(false);
        this.permissionbutton.setVisible(false);
    }

    private String formattooltips(String tooltips) {
        if (tooltips == null) {
            return "";
        }
        if (tooltips.length() <= 20) {
            return tooltips;
        }
        return tooltips.substring(0, 20) + "...";
    }

    private MetaData getEntityVersionMetaData(ClientPrimaryDataEntity dataentity, ClientPrimaryDataEntityVersion version) {
        try {
            for (ClientPrimaryDataEntityVersion curr : dataentity.getVersions()) {
                if (curr.getRevision().longValue() != version.getRevision().longValue()) continue;
                return curr.getMetaData();
            }
            return dataentity.getMetaData();
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
            return null;
        }
    }

    public EdalAbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public ClientPrimaryDataEntity getSelectedFile() {
        if (!this.isSelected) {
            return null;
        }
        if (this.fileSelectionMode == 1) {
            try {
                if (this.selectedFile.isDirectory()) {
                    return this.selectedFile;
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
            return null;
        }
        if (this.fileSelectionMode == 0) {
            try {
                if (!this.selectedFile.isDirectory()) {
                    return this.selectedFile;
                }
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
            return null;
        }
        if (this.selectedFile != null) {
            return this.selectedFile;
        }
        return this.currentdir;
    }

    public ClientPrimaryDataEntity[] getSelectedFiles() {
        if (this.selectrows != null && this.filelist.size() > 0) {
            if (this.fileSelectionMode == 1) {
                ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[]{this.currentdir};
                return selectedFiles;
            }
            if (this.fileSelectionMode == 0) {
                ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[this.selectrows.length];
                for (int i = 0; i < selectedFiles.length; ++i) {
                    selectedFiles[i] = this.filelist.get(this.selectrows[i]);
                }
                return selectedFiles;
            }
            ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[this.selectrows.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                selectedFiles[i] = this.filelist.get(this.selectrows[i]);
            }
            return selectedFiles;
        }
        if (this.fileSelectionMode == 0) {
            return new ClientPrimaryDataFile[0];
        }
        ClientPrimaryDataEntity[] selectedFiles = new ClientPrimaryDataEntity[]{this.currentdir};
        return selectedFiles;
    }

    protected void init(ClientPrimaryDataDirectory rootDirectory) {
        this.currentdir = rootDirectory;
        JPanel maincontents = new JPanel();
        this.setContentPane(maincontents);
        maincontents.setLayout(new BorderLayout());
        maincontents.add((Component)this.centerPane, "Center");
        maincontents.add((Component)this.statusbar, "South");
        this.centerPane.removeAll();
        this.centerPane.setLayout((LayoutManager)new MigLayout("insets 1 1 1 1", "[35!][8%!][9%!][36%!][5%!][11!][grow,fill][10][5]", "[30]0[grow,fill]0[20]0"));
        if (rootDirectory != null) {
            this.pathlabel.setVerticalAlignment(0);
            this.pathlabel.setFont(FONT);
            this.centerPane.add((Component)this.pathlabel, "cell 0 0 1 1");
            this.pathtext.setFont(FONT);
            this.centerPane.add((Component)this.pathtext, "cell 1 0 4 1,width max(60%, 60%)");
            this.centerPane.add((Component)new XStatusSeparator(), "cell 5 0 1 1");
        }
        this.searchtext.setFont(FONT);
        if (rootDirectory != null) {
            this.centerPane.add((Component)this.searchtext, "cell 6 0 1 1,width max(100%, 100%)");
            this.searchtext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdalFileChooser.this.search(EdalFileChooser.this.searchtext.getText().trim());
                }
            });
        }
        JButton searchbutton = new JButton(this.searchAction);
        searchbutton.setFont(FONT);
        if (rootDirectory != null) {
            this.centerPane.add((Component)searchbutton, "cell 8 0 1 1");
        }
        this.detailpanelparent = new JPanel();
        this.detailpanelparent.setFont(FONT);
        this.detailpanelparent.setLayout(new BorderLayout());
        if (rootDirectory != null) {
            final ClientPrimaryDataDirectory f_rootDirectory = rootDirectory;
            this.tree = new JTree(this.addNodes(null, rootDirectory));
            EdalTreeCellRenderer renderer = new EdalTreeCellRenderer(this.tree.getCellRenderer());
            this.tree.setCellRenderer(renderer);
            this.tree.setOpaque(true);
            this.tree.setBackground(Color.white);
            UIDefaults treeDefaults = new UIDefaults();
            treeDefaults.put("Tree.selectionBackground", (Object)null);
            this.tree.putClientProperty("Nimbus.Overrides", treeDefaults);
            this.tree.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
            this.treepanelparent = new JScrollPane(this.tree);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    EdalFileChooser.this.isSelected = true;
                    EdalFileChooser.this.currentnode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                    EdalFileChooser.this.treenodeclick(EdalFileChooser.this.currentnode, f_rootDirectory);
                }
            });
            this.tree.addTreeWillExpandListener(new TreeWillExpandListenerAction(this.tree, rootDirectory));
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (EdalFileChooser.this.filemetatable != null) {
                        EdalFileChooser.this.filemetatable.clearSelection();
                        JTree ttree = (JTree)e.getComponent();
                        TreePath tpath = ttree.getPathForLocation(e.getX(), e.getY());
                        if (tpath != null && tpath.getLastPathComponent() != null) {
                            EdalFileChooser.this.currentnode = (DefaultMutableTreeNode)tpath.getLastPathComponent();
                            EdalNode mynode = (EdalNode)EdalFileChooser.this.currentnode.getUserObject();
                            EdalFileChooser.this.pathtext.setText(mynode.getPath());
                        }
                    }
                    EdalFileChooser.this.treenodeclick(EdalFileChooser.this.currentnode, f_rootDirectory);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    EdalFileChooser.this.checktreeRightClick(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    EdalFileChooser.this.checktreeRightClick(e);
                }
            });
            try {
                this.defaultModel = this.buildtable(rootDirectory.listPrimaryDataEntities());
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError(e1);
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            this.filemetatable = new EdalTable(this.defaultModel);
            if (this.multiSelectionEnabled) {
                this.filemetatable.setSelectionMode(2);
            } else {
                this.filemetatable.setSelectionMode(0);
            }
            this.filemetatable.getSelectionModel().addListSelectionListener(new TableRowModelListener(this.filemetatable, this.detailpanelparent));
            this.filemetatable.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point point = e.getPoint();
                    int x = EdalFileChooser.this.filemetatable.rowAtPoint(point);
                    int y = EdalFileChooser.this.filemetatable.columnAtPoint(point);
                    if (x != EdalFileChooser.this.row || y != EdalFileChooser.this.column) {
                        EdalFileChooser.this.row = x;
                        EdalFileChooser.this.column = y;
                    }
                    if (EdalFileChooser.this.tipsmap.containsKey(EdalFileChooser.this.row + 1 + "," + (EdalFileChooser.this.column + 1))) {
                        EdalFileChooser.this.filemetatable.setToolTipText(EdalFileChooser.this.formattooltips((String)EdalFileChooser.this.tipsmap.get(EdalFileChooser.this.row + 1 + "," + (EdalFileChooser.this.column + 1))));
                    } else if (EdalFileChooser.this.row > 0 && EdalFileChooser.this.column > 0) {
                        Object tip = EdalFileChooser.this.filemetatable.getValueAt(EdalFileChooser.this.row, EdalFileChooser.this.column);
                        EdalFileChooser.this.filemetatable.setToolTipText(EdalFileChooser.this.formattooltips(tip.toString()));
                    }
                }
            });
            this.filemetatable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    EdalFileChooser.this.checktableRightClick(evt, EdalFileChooser.this.tree);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    EdalFileChooser.this.checktableRightClick(evt, EdalFileChooser.this.tree);
                }
            });
            if (this.tablebackcolor == null) {
                this.tablebackcolor = this.filemetatable.getSelectionBackground();
            }
            JScrollPane filepanel = new JScrollPane(this.filemetatable);
            this.tableshowpane = new JSplitPane(0, filepanel, this.detailpanelparent);
            this.tableshowpane.setDividerSize(3);
            UiUtil.fitTableColumns(this.filemetatable, 631);
            if (this.currentdir != null) {
                this.buildDetail(this.detailpanelparent, this.currentdir, true);
            }
            this.tableshowpane.setDividerLocation(0.75);
            this.tableshowpane.setResizeWeight(1.0);
            this.tableshowpane.resetToPreferredSizes();
            this.dirshowpane = new JSplitPane(1, this.treepanelparent, this.tableshowpane);
            this.dirshowpane.setDividerSize(3);
            this.treepanelparent.setMinimumSize(new Dimension(250, 154));
            this.tableshowpane.setMinimumSize(new Dimension(500, 309));
            filepanel.setMinimumSize(new Dimension(180, 111));
            this.detailpanelparent.setMinimumSize(new Dimension(200, 100));
            this.centerPane.add((Component)this.dirshowpane, "cell 0 1 9 1,width max(100%, 100%)");
            this.detailpanelparent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    EdalFileChooser.this.checkpanelRightClick(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    EdalFileChooser.this.checkpanelRightClick(e);
                }
            });
        }
        this.configbutton = new JButton("Change Connection");
        this.configbutton.setFont(FONT);
        this.configbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EdalFileChooser.this.showlogindialog();
            }
        });
        this.permissionbutton = new JButton("Change Permissions");
        this.permissionbutton.setFont(FONT);
        this.permissionbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EdalFileChooser.this.selectedFile != null) {
                    PermissionDialog permission = new PermissionDialog(EdalFileChooser.this.selectedFile, EdalFileChooser.this.client);
                    permission.showOpenDialog();
                } else if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                    PermissionDialog permission = new PermissionDialog((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), EdalFileChooser.this.client);
                    permission.showOpenDialog();
                }
            }
        });
        this.metadatabutton = new JButton("Change Metadata");
        this.metadatabutton.setFont(FONT);
        this.metadatabutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetaDataSaveDialog metadlg;
                int returnVal;
                if (EdalFileChooser.this.selectedFile != null && (returnVal = (metadlg = new MetaDataSaveDialog(EdalFileChooser.this.selectedFile)).showOpenDialog()) == 0) {
                    Map<EnumDublinCoreElements, UntypedData> metadatavalue = metadlg.getMetaDataValues();
                    EdalFileChooser.this.changemetadata(EdalFileChooser.this.selectedFile, metadatavalue, false);
                }
            }
        });
        this.okbutton = new JButton("Ok");
        this.okbutton.setFont(FONT);
        this.okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EdalFileChooser.this.getSelectedFile() == null) {
                    return;
                }
                EdalFileChooser.this.returnvalue = 0;
                EdalFileChooser.this.dispose();
            }
        });
        JButton cancelbutton = new JButton(this.cancelAction);
        cancelbutton.setFont(FONT);
        JPanel functionButtons = new JPanel();
        functionButtons.setLayout(new FlowLayout(2));
        if (this.showconnbutton) {
            functionButtons.add(this.configbutton);
        }
        if (rootDirectory != null) {
            functionButtons.add(this.permissionbutton);
            functionButtons.add(this.metadatabutton);
            this.showmetabutton(rootDirectory);
            this.showpermissionbutton(rootDirectory);
        }
        functionButtons.add(this.okbutton);
        functionButtons.add(cancelbutton);
        this.centerPane.add((Component)functionButtons, "cell 0 2 9 1,align right ");
        this.setPreferredSize(new Dimension(950, 575));
        this.setMinimumSize(new Dimension(950, 575));
        if (rootDirectory != null) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    EdalFileChooser.this.dirshowpane.setDividerLocation(0.3);
                }
            });
        }
        this.statusbar.updateStatus(this.client.getServerAddress(), this.client.getRegistryPort(), this.username);
        maincontents.updateUI();
        this.pack();
        if (rootDirectory != null) {
            this.dirshowpane.setDividerLocation(0.3);
        }
    }

    protected void initViewers() {
        this.metadatatoshow.add("DATE");
        this.metadatatoshow.add("FORMAT");
        ViewerContainer.registerViewer(EnumDublinCoreElements.CHECKSUM, new CheckSumViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.CREATOR, new PersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.CONTRIBUTOR, new PersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.PUBLISHER, new LegalPersonInfoViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.RELATION, new IdentifierRelationViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.DATE, new DateEventsViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.COVERAGE, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.DESCRIPTION, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.FORMAT, new DataFormatViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.IDENTIFIER, new IdentifierViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.LANGUAGE, new LanguageViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.RIGHTS, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.SOURCE, new TextViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.SUBJECT, new SubjectViewer());
        ViewerContainer.registerViewer(EnumDublinCoreElements.TITLE, new TextViewer());
    }

    private void refreshtable() {
        this.cleartable();
        List<ClientPrimaryDataEntity> dirlist = null;
        try {
            dirlist = this.currentdir.listPrimaryDataEntities();
        }
        catch (PrimaryDataDirectoryException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError((Exception)((Object)e1));
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        if (dirlist != null) {
            this.defaultModel = this.buildtable(dirlist);
            this.filemetatable.setModel(this.defaultModel);
            this.defaultModel.fireTableDataChanged();
            UiUtil.fitTableColumns(this.filemetatable, 631);
        }
    }

    private void refreshtreenode(JTree tree) {
        if (this.currentnode != null) {
            this.currentnode.removeAllChildren();
            if (this.currentdir != null) {
                try {
                    List<ClientPrimaryDataEntity> dirlist = this.currentdir.listPrimaryDataEntities();
                    ArrayList<String> dirnamelist = new ArrayList<String>();
                    HashMap<String, ClientPrimaryDataEntity> dirnamemap = new HashMap<String, ClientPrimaryDataEntity>();
                    if (dirlist != null) {
                        for (ClientPrimaryDataEntity dir : dirlist) {
                            if (!dir.isDirectory() || dir.getCurrentVersion().isDeleted()) continue;
                            dirnamelist.add(dir.getName());
                            dirnamemap.put(dir.getName(), dir);
                        }
                    }
                    Collections.sort(dirnamelist, String.CASE_INSENSITIVE_ORDER);
                    for (String dirname : dirnamelist) {
                        EdalMutableTreeModel child = new EdalMutableTreeModel(new EdalNode(dirname, ((ClientPrimaryDataDirectory)dirnamemap.get(dirname)).getPath()));
                        this.currentnode.add(child);
                    }
                    tree.updateUI();
                }
                catch (RemoteException e1) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                    ErrorDialog.showError(e1);
                }
                catch (PrimaryDataDirectoryException e1) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                    ErrorDialog.showError((Exception)((Object)e1));
                }
            }
        }
    }

    private void search(final String keyword) {
        this.cleartable();
        final HashSet results = new HashSet();
        final ArrayList resultslist = new ArrayList();
        if (this.currentdir == null) {
            this.currentdir = this.rootDirectory;
        }
        final EdalFileChooser thisdialog = this;
        final Cursor cursor = thisdialog.getCursor();
        thisdialog.setCursor(new Cursor(3));
        final InfiniteProgressPanel glassPane = new InfiniteProgressPanel();
        glassPane.setWidth(this.getWidth());
        glassPane.setHeight(this.getHeight() - 150);
        this.setGlassPane(glassPane);
        glassPane.setText("search for:" + keyword);
        glassPane.start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClientPrimaryDataEntity[] result = EdalFileChooser.this.currentdir.searchByKeyword(keyword, true, true).toArray(new ClientPrimaryDataEntity[0]);
                    if (result != null) {
                        for (ClientPrimaryDataEntity data : result) {
                            results.add(data);
                        }
                    }
                    for (ClientPrimaryDataEntity data : results) {
                        resultslist.add(data);
                    }
                    EdalFileChooser.this.defaultModel = EdalFileChooser.this.buildtable(resultslist);
                    EdalFileChooser.this.filemetatable.setModel(EdalFileChooser.this.defaultModel);
                    EdalFileChooser.this.defaultModel.fireTableDataChanged();
                    UiUtil.fitTableColumns(EdalFileChooser.this.filemetatable, 631);
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError(e);
                }
                catch (PrimaryDataDirectoryException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError((Exception)((Object)e));
                }
                finally {
                    thisdialog.setCursor(cursor);
                    glassPane.stop();
                }
            }
        }.start();
    }

    public void setFileFilter(EdalAbstractFileFilter filter) {
        this.fileFilter = filter;
    }

    public void setFileSelectionMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Incorrect Mode for file selection: " + mode);
        }
        this.fileSelectionMode = mode;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelectionEnabled = b;
    }

    private int showlogindialog() {
        EdalConfigDialog eDALConfigUi = new EdalConfigDialog();
        int returnVal = eDALConfigUi.showOpenDialog();
        if (returnVal == 0) {
            return 0;
        }
        return 1;
    }

    private void showmetabutton(ClientPrimaryDataEntity dataentry) {
        if (!PrincipalUtil.checkPermission(dataentry, this.username, CHANGEMETADATAMETHODNAME)) {
            this.metadatabutton.setVisible(false);
        } else {
            this.metadatabutton.setVisible(true);
        }
    }

    public int showOpenDialog() {
        if (this.rootDirectory == null) {
            this.dispose();
            return -1;
        }
        try {
            this.initViewers();
            this.savemodal = false;
            this.setTitle("Open File");
            this.init(this.rootDirectory);
            if (this.client == null && 1 == this.showlogindialog()) {
                this.dispose();
                return this.returnvalue;
            }
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return this.returnvalue;
        }
        catch (Exception e) {
            this.dispose();
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
            return -1;
        }
    }

    private void showpermissionbutton(ClientPrimaryDataEntity dataentry) {
        if (!PrincipalUtil.checkPermission(dataentry, this.username, CHANGEPERMISSIONTHODNAME)) {
            this.permissionbutton.setVisible(false);
        } else {
            this.permissionbutton.setVisible(true);
        }
    }

    public int showSaveDialog() {
        if (this.rootDirectory == null) {
            this.dispose();
            return -1;
        }
        try {
            this.initViewers();
            this.savemodal = true;
            this.setTitle("Save File");
            this.init(this.rootDirectory);
            this.setModal(true);
            if (this.client == null && 1 == this.showlogindialog()) {
                this.dispose();
                return this.returnvalue;
            }
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            return this.returnvalue;
        }
        catch (Exception e) {
            this.dispose();
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
            return -1;
        }
    }

    public void showConnectionButton(boolean showconnbutton) {
        this.showconnbutton = showconnbutton;
    }

    private void switchversion(int versionidx) {
        if (this.selectedFile != null) {
            this.currentversion = this.versionlist.get(versionidx);
            try {
                String strdate = null;
                SimpleDateFormat dataformat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                if (this.currentversion.getRevisionDate() != null) {
                    strdate = dataformat.format(this.currentversion.getRevisionDate().getTime());
                }
                this.selectedFile.switchCurrentVersion(this.currentversion);
                this.currentversionmap.put(this.selectedFile.getPath(), this.currentversion);
                this.versionpanel.setTitle("Version " + this.currentversion.getRevision() + " :  " + strdate + (this.currentversion.isDeleted() ? " - deleted." : ""));
            }
            catch (RemoteException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
            catch (AccessControlException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            }
            catch (PrimaryDataEntityVersionException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            }
        }
    }

    private boolean isexistdeleteversion(ClientPrimaryDataDirectory parentdir, String newfoldername) {
        try {
            List<ClientPrimaryDataEntity> childdirlist = parentdir.listPrimaryDataEntities();
            if (childdirlist != null) {
                for (ClientPrimaryDataEntity dir : childdirlist) {
                    ClientPrimaryDataEntityVersion version = null;
                    try {
                        version = dir.getCurrentVersion();
                        if (!version.isDeleted() || !dir.getName().equals(newfoldername)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        catch (RemoteException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError(e);
        }
        catch (PrimaryDataDirectoryException e) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
            ErrorDialog.showError((Exception)((Object)e));
        }
        return false;
    }

    private void treenodeclick(DefaultMutableTreeNode currentnode, ClientPrimaryDataDirectory f_rootDirectory) {
        if (currentnode == null || currentnode.getUserObject() == null) {
            return;
        }
        EdalNode mynode = (EdalNode)currentnode.getUserObject();
        this.pathtext.setText(mynode.getPath());
        this.cleartable();
        try {
            try {
                this.currentdir = (ClientPrimaryDataDirectory)EdalFileHelper.getEntity(mynode.getPath(), f_rootDirectory);
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            List<ClientPrimaryDataEntity> dirlist = null;
            try {
                dirlist = this.currentdir.listPrimaryDataEntities();
            }
            catch (PrimaryDataDirectoryException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                ErrorDialog.showError((Exception)((Object)e1));
            }
            catch (AccessControlException e1) {
                ErrorDialog.showError(e1);
            }
            if (dirlist != null) {
                this.defaultModel = this.buildtable(dirlist);
                this.filemetatable.setModel(this.defaultModel);
                this.defaultModel.fireTableDataChanged();
                UiUtil.fitTableColumns(this.filemetatable, 631);
                if (this.detailpanel != null && !this.detailpanel.isCollapsed()) {
                    this.detailpanel.setCollapsed(true);
                    this.detailpanel.setScrollOnExpand(true);
                }
            }
            if (this.currentdir != null) {
                this.buildDetail(this.detailpanelparent, this.currentdir, true);
            }
            this.showmetabutton(this.currentdir);
            this.showpermissionbutton(this.currentdir);
        }
        catch (RemoteException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
        catch (NotBoundException e1) {
            ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
            ErrorDialog.showError(e1);
        }
    }

    static /* synthetic */ int[] access$502(EdalFileChooser x0, int[] x1) {
        x0.selectrows = x1;
        return x1;
    }

    private class TableRowModelListener
    implements ListSelectionListener {
        private final JTable table;
        private final JPanel detailpanelparent;

        public TableRowModelListener(JTable table, JPanel detailpanelparent) {
            this.table = table;
            this.detailpanelparent = detailpanelparent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            EdalFileChooser.this.isSelected = true;
            boolean b = this.table.getSelectionModel().getValueIsAdjusting();
            if (!b && this.table.getSelectedRow() > -1) {
                EdalFileChooser.access$502(EdalFileChooser.this, this.table.getSelectedRows());
                EdalFileChooser.this.fileselectindex = this.table.getSelectedRow();
                if (EdalFileChooser.this.selectrows.length == 1) {
                    EdalFileChooser.this.buildDetail(this.detailpanelparent, (ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(this.table.getSelectedRow()), true);
                    try {
                        EdalFileChooser.this.pathtext.setText(((ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(this.table.getSelectedRow())).getPath());
                    }
                    catch (RemoteException e1) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                        ErrorDialog.showError(e1);
                    }
                } else {
                    EdalFileChooser.this.disablemetadata();
                }
                if (EdalFileChooser.this.detailpanel != null && !EdalFileChooser.this.detailpanel.isCollapsed()) {
                    EdalFileChooser.this.detailpanel.setCollapsed(true);
                    EdalFileChooser.this.detailpanel.setScrollOnExpand(true);
                }
            }
        }
    }

    private class LinkMouseListener
    extends MouseAdapter {
        private final int versionidx;
        private final JPanel detailpanelparent;
        private final List<JVersionLabel> versionbuttonlist;

        public LinkMouseListener(List<JVersionLabel> versionbuttonlist, int versionidx, JPanel detailpanelparent) {
            this.versionidx = versionidx;
            this.detailpanelparent = detailpanelparent;
            this.versionbuttonlist = versionbuttonlist;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (this.versionbuttonlist != null) {
                for (int i = 0; i < this.versionbuttonlist.size(); ++i) {
                    if (i != this.versionidx) {
                        this.versionbuttonlist.get(i).setSelect(false);
                        continue;
                    }
                    this.versionbuttonlist.get(i).setSelect(true);
                }
            }
            EdalFileChooser.this.switchversion(this.versionidx);
            if (EdalFileChooser.this.selectedFile != null) {
                EdalFileChooser.this.buildDetail(this.detailpanelparent, EdalFileChooser.this.selectedFile, false);
            } else if (EdalFileChooser.this.filelist.size() > 0 && EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex) != null) {
                EdalFileChooser.this.buildDetail(this.detailpanelparent, (ClientPrimaryDataEntity)EdalFileChooser.this.filelist.get(EdalFileChooser.this.fileselectindex), false);
            }
        }
    }
}

