/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.ErrorDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.AbstractMetaDataEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.DateEventsEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.EdalLanguageEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.EditorContainer;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.IdentifierEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.IdentifierRelationEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.LegalPersonInfoEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.PersonInfoEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.SubjectsEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.TextEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.JLinkLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.MetaDescription;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class MetaDataSaveDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("Courier New", 0, 12);
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public int returnvalue;
    private Map<String, JTextField> detailmap = new HashMap<String, JTextField>();
    private Map<EnumDublinCoreElements, UntypedData> metadatavalue = new HashMap<EnumDublinCoreElements, UntypedData>();
    private JButton savebtn;
    private JButton cancelbtn;
    private ClientPrimaryDataEntity dataentry;
    private Action okAction = new AbstractAction("Ok"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataSaveDialog.this.returnvalue = 0;
            MetaDataSaveDialog.this.dispose();
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataSaveDialog.this.returnvalue = 1;
            MetaDataSaveDialog.this.dispose();
        }
    };

    public MetaDataSaveDialog() {
        this.metadatavalue.clear();
        this.initUi();
    }

    public MetaDataSaveDialog(ClientPrimaryDataEntity dataentry) {
        this.dataentry = dataentry;
        this.initUi();
    }

    public Map<EnumDublinCoreElements, UntypedData> getMetaDataValues() {
        return this.metadatavalue;
    }

    public int showOpenDialog() {
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.returnvalue;
    }

    private void initUi() {
        this.initEditors();
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        contents.setBorder(new TitledBorder(""));
        contents.add((Component)new JScrollPane(this.createeditpanel()), "Center");
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setPreferredSize(new Dimension(1050, 650));
        this.setMinimumSize(new Dimension(1050, 650));
        this.addWindowListener(this.createAppCloser());
    }

    private JPanel buildFormui() {
        ArrayList<String> columnlist = new ArrayList<String>();
        for (EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
            try {
                String dataName = elem.toString();
                try {
                    if (dataName.equalsIgnoreCase("title") && this.dataentry != null && this.dataentry.isDirectory()) {
                        continue;
                    }
                }
                catch (RemoteException e) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                    ErrorDialog.showError(e);
                }
                columnlist.add(dataName);
            }
            catch (UnsupportedOperationException e) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                ErrorDialog.showError(e);
            }
        }
        String[] columnNames = columnlist.toArray(new String[0]);
        int columnlen = columnNames.length;
        JPanel detialpanel = new JPanel();
        detialpanel.setFont(FONT);
        detialpanel.setLayout((LayoutManager)new MigLayout("", "[80!][90%!]", ""));
        for (int i = 0; i < columnlen; ++i) {
            JLinkLabel label1 = new JLinkLabel(columnNames[i].toString() + ":", 2);
            label1.setVerticalAlignment(0);
            label1.setToolTipText("<html>" + MetaDescription.getDescription(columnNames[i].toString()) + "</html>");
            label1.setFont(FONT);
            detialpanel.add(label1);
            JTextField text1 = new JTextField();
            text1.setFont(FONT);
            detialpanel.add((Component)text1, "wrap,growx");
            this.detailmap.put(columnNames[i].toString(), text1);
        }
        return detialpanel;
    }

    private JPanel createeditpanel() {
        JPanel detialpanel = this.buildFormui();
        if (this.dataentry != null) {
            try {
                MetaData filemetadata = this.dataentry.getCurrentVersion().getMetaData();
                try {
                    this.setTitle("Modify Metadata of '" + filemetadata.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString() + "'");
                }
                catch (Exception e1) {
                    ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                    ErrorDialog.showError(e1);
                }
                for (final EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                    final String dataName = elem.toString();
                    if (!this.detailmap.containsKey(dataName)) continue;
                    UntypedData data = null;
                    try {
                        data = filemetadata.getElementValue((Enum)elem);
                        String value = data.toString();
                        this.detailmap.get(dataName).setText(value);
                        this.detailmap.get(dataName).setCaretPosition(0);
                        if (value.trim().length() > 0) {
                            this.detailmap.get(dataName).setToolTipText(value);
                        }
                    }
                    catch (MetaDataException e) {
                        ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
                        ErrorDialog.showError((Exception)((Object)e));
                    }
                    this.metadatavalue.put(elem, data);
                    final AbstractMetaDataEditor editor = EditorContainer.getEditor(EnumDublinCoreElements.valueOf((String)dataName));
                    if (editor != null) {
                        for (MouseListener al : this.detailmap.get(dataName).getMouseListeners()) {
                            this.detailmap.get(dataName).removeMouseListener(al);
                        }
                        this.detailmap.get(dataName).addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() == 1) {
                                    editor.setTitle(dataName);
                                    editor.setValue((UntypedData)MetaDataSaveDialog.this.metadatavalue.get(elem));
                                    int ret = editor.showOpenDialog();
                                    if (ret == 0) {
                                        UntypedData untypedData = editor.getValue();
                                        MetaDataSaveDialog.this.metadatavalue.put(elem, untypedData);
                                        if (untypedData != null) {
                                            ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setText(untypedData.toString());
                                            ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setCaretPosition(0);
                                            if (untypedData.toString().trim().length() > 0) {
                                                ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setToolTipText(untypedData.toString());
                                            }
                                        }
                                    }
                                }
                            }
                        });
                        continue;
                    }
                    this.detailmap.get(dataName).setForeground(Color.GRAY);
                    this.detailmap.get(dataName).setEditable(false);
                }
            }
            catch (RemoteException e1) {
                ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e1));
                JOptionPane.showMessageDialog(null, "Call remote Edal server function exception:" + e1.getMessage(), "EdalFileChooser", 0);
            }
        } else {
            for (final EnumDublinCoreElements elem : EnumDublinCoreElements.values()) {
                final String dataName = elem.toString();
                if (!this.detailmap.containsKey(dataName)) continue;
                final AbstractMetaDataEditor editor = EditorContainer.getEditor(EnumDublinCoreElements.valueOf((String)dataName));
                if (editor != null) {
                    for (MouseListener al : this.detailmap.get(dataName).getMouseListeners()) {
                        this.detailmap.get(dataName).removeMouseListener(al);
                    }
                    this.detailmap.get(dataName).addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 1) {
                                editor.setValue(null);
                                int ret = editor.showOpenDialog();
                                if (ret == 0) {
                                    UntypedData untypedData = editor.getValue();
                                    MetaDataSaveDialog.this.metadatavalue.put(elem, untypedData);
                                    if (untypedData != null) {
                                        ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setText(untypedData.toString());
                                        ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setCaretPosition(0);
                                        if (untypedData.toString().trim().length() > 0) {
                                            ((JTextField)MetaDataSaveDialog.this.detailmap.get(dataName)).setToolTipText(untypedData.toString());
                                        }
                                    }
                                }
                            }
                        }
                    });
                    continue;
                }
                this.detailmap.get(dataName).setForeground(Color.GRAY);
                this.detailmap.get(dataName).setEditable(false);
            }
        }
        return detialpanel;
    }

    private JPanel createbuttonpanel() {
        this.savebtn = new JButton(this.okAction);
        this.cancelbtn = new JButton(this.cancelAction);
        JPanel buttonPane = new JPanel(new FlowLayout(1, 5, 5));
        buttonPane.add(this.savebtn);
        buttonPane.add(this.cancelbtn);
        this.getRootPane().setDefaultButton(this.savebtn);
        return buttonPane;
    }

    private void initEditors() {
        EditorContainer.registerEditor(EnumDublinCoreElements.CREATOR, new PersonInfoEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.CONTRIBUTOR, new PersonInfoEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.PUBLISHER, new LegalPersonInfoEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.RELATION, new IdentifierRelationEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.DATE, new DateEventsEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.COVERAGE, new TextEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.DESCRIPTION, new TextEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.IDENTIFIER, new IdentifierEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.LANGUAGE, new EdalLanguageEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.RIGHTS, new TextEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.SOURCE, new TextEditor());
        EditorContainer.registerEditor(EnumDublinCoreElements.SUBJECT, new SubjectsEditor());
    }

    private void focusEvt(WindowEvent evt) {
        this.savebtn.requestFocus();
    }

    private WindowListener createAppCloser() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                MetaDataSaveDialog.this.returnvalue = 1;
                MetaDataSaveDialog.this.dispose();
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                MetaDataSaveDialog.this.focusEvt(evt);
            }
        };
    }
}

