/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.NaturalPerson;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Person;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.editor.MetaDataEditDialog;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PersonTableCellEditor;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.PersonTableModel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ReadonlyTableCellEditor;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PersonsDialog
extends MetaDataEditDialog {
    private static final long serialVersionUID = 1L;
    private static final String NATURALPERSON = "NaturalPerson";
    private static final String LEGALPERSON = "LegalPerson";
    private static final String[] value = new String[]{"LegalPerson", "NaturalPerson"};
    private PersonTableModel model;
    private JTable table;
    private Persons persons;
    private static final JButton ADD_BUTTON = new JButton("Add Person");
    private static final JButton REMOVE_BUTTON = new JButton("Remove Person");
    private static final String[] DEFAULT_CONTRIBUTOR_VALUE = new String[]{value[0], "", "", "", "Corrensstra\u00dfe 3", "06466", "Germany"};
    private static final Set<Integer> legalrows = new HashSet<Integer>();

    public PersonsDialog(Persons persons, String title) {
        this.persons = persons;
        this.setTitle(title);
        JPanel contents = (JPanel)this.getContentPane();
        contents.setLayout(new BorderLayout());
        JPanel editPane = new JPanel(new BorderLayout());
        this.model = new PersonTableModel();
        this.model.addColumn("Persontype");
        this.model.addColumn("Givenname");
        this.model.addColumn("Surname");
        this.model.addColumn("Legalname");
        this.model.addColumn("Address");
        this.model.addColumn("Zip");
        this.model.addColumn("Country");
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.setRowHeight(24);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setCellEditor(new PersonTableCellEditor(value, true));
        col.setMinWidth(90);
        this.table.getColumnModel().getColumn(4).setMinWidth(150);
        this.model.setTable(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(ADD_BUTTON);
        buttonPanel.add(REMOVE_BUTTON);
        ADD_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonsDialog.this.model.insertRow(PersonsDialog.this.table.getSelectedRow() + 1, DEFAULT_CONTRIBUTOR_VALUE);
                PersonsDialog.this.table.getColumnModel().getColumn(1).setCellEditor(new ReadonlyTableCellEditor(false));
                PersonsDialog.this.table.getColumnModel().getColumn(2).setCellEditor(new ReadonlyTableCellEditor(false));
                PersonsDialog.this.table.getColumnModel().getColumn(3).setCellEditor(new ReadonlyTableCellEditor(true));
                PersonsDialog.this.refreshcolor();
            }
        });
        REMOVE_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PersonsDialog.this.model.getRowCount() != 0) {
                    if (PersonsDialog.this.table.getSelectedRow() != -1) {
                        PersonsDialog.this.model.removeRow(PersonsDialog.this.table.getSelectedRow());
                    } else {
                        PersonsDialog.this.model.removeRow(PersonsDialog.this.model.getRowCount() - 1);
                    }
                }
                PersonsDialog.this.refreshcolor();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        editPane.add((Component)scrollPane, "Center");
        editPane.add((Component)buttonPanel, "South");
        contents.add((Component)editPane, "Center");
        editPane.setBorder(BorderFactory.createTitledBorder(""));
        contents.add((Component)this.createbuttonpanel(), "South");
        this.setPreferredSize(new Dimension(720, 444));
        this.setMinimumSize(new Dimension(720, 444));
        this.initdata();
    }

    @Override
    public void initdata() {
        String[] locales = Locale.getISOCountries();
        Object[] countrynames = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            Locale obj = new Locale("", locales[i]);
            countrynames[i] = obj.getDisplayCountry();
        }
        TableColumn col = this.table.getColumnModel().getColumn(6);
        Arrays.sort(countrynames);
        col.setCellEditor(new PersonTableCellEditor((String[])countrynames, false));
        if (this.persons != null) {
            for (Person person : this.persons) {
                if (person instanceof NaturalPerson) {
                    this.model.insertRow(this.table.getRowCount(), new String[]{NATURALPERSON, ((NaturalPerson)person).getGivenName(), ((NaturalPerson)person).getSureName(), "", person.getAddressLine(), person.getZip(), person.getCountry()});
                    this.table.getColumnModel().getColumn(1).setCellEditor(new ReadonlyTableCellEditor(true));
                    this.table.getColumnModel().getColumn(2).setCellEditor(new ReadonlyTableCellEditor(true));
                    this.table.getColumnModel().getColumn(3).setCellEditor(new ReadonlyTableCellEditor(false));
                    continue;
                }
                int row = this.table.getRowCount();
                this.model.insertRow(row, new String[]{LEGALPERSON, "", "", ((LegalPerson)person).getLegalName(), person.getAddressLine(), person.getZip(), person.getCountry()});
                this.table.getColumnModel().getColumn(1).setCellEditor(new ReadonlyTableCellEditor(false));
                this.table.getColumnModel().getColumn(2).setCellEditor(new ReadonlyTableCellEditor(false));
                this.table.getColumnModel().getColumn(3).setCellEditor(new ReadonlyTableCellEditor(true));
            }
            this.refreshcolor();
        }
    }

    public Persons getPerson() {
        Persons persons = new Persons();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            LegalPerson person;
            if (this.model.getValueAt(i, 0).toString().equals(LEGALPERSON)) {
                person = new LegalPerson(this.model.getValueAt(i, 3).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString());
                persons.add((Person)person);
                continue;
            }
            person = new NaturalPerson(this.model.getValueAt(i, 1).toString(), this.model.getValueAt(i, 2).toString(), this.model.getValueAt(i, 4).toString(), this.model.getValueAt(i, 5).toString(), this.model.getValueAt(i, 6).toString());
            persons.add((Person)person);
        }
        return persons;
    }

    public void refreshcolor() {
        legalrows.clear();
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ReadonlyRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new ReadonlyRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new ReadonlyRenderer());
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (this.model.getValueAt(i, 0).toString().equals(LEGALPERSON)) {
                legalrows.add(i);
                this.model.setValueAt("", i, 1);
                this.model.setValueAt("", i, 2);
                continue;
            }
            this.model.setValueAt("", i, 3);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    private class ReadonlyRenderer
    extends DefaultTableCellRenderer
    implements Icon {
        private static final long serialVersionUID = 1L;
        private static final int SIZE = 32;
        private int row;
        private int column;

        public ReadonlyRenderer() {
            this.setIcon(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.row = row;
            this.column = column;
            return cell;
        }

        @Override
        protected void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (legalrows.contains(this.row)) {
                if (this.column == 1 || this.column == 2) {
                    this.drawreadonlyline(g, x, y);
                } else {
                    this.drawreadonlytext(g, x, y);
                }
            } else if (this.column == 3) {
                this.drawreadonlyline(g, x, y);
            } else {
                this.drawreadonlytext(g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return 32;
        }

        @Override
        public int getIconHeight() {
            return 32;
        }

        private void drawreadonlyline(Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.red);
            g2d.drawLine(x - 32, y, x + this.getWidth(), y + this.getHeight() + 2);
        }

        private void drawreadonlytext(Graphics g, int x, int y) {
        }
    }
}

