/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.ImageUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EdalTitlePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static String TITLEORIGINALSIZE = "title_original_size";
    private String title;
    private Image icon;
    private Window window;
    private boolean textInCenter = false;
    private int xGap = 1;
    private int yGap = 5;
    private JLabel titleLabel = new JLabel();
    private JLabel iconLabel = new JLabel();
    private int titleHeight = 24;
    private Point pressPoint;
    private JButton closeButton;
    private JButton resizeButton;
    private JButton minButton;
    private Icon restoreIcon = ImageUtil.createImageIcon("window_border_reset.png", "window_border_reset.png");
    private Icon maxIcon = ImageUtil.createImageIcon("window_border_max.png", "window_border_max.png");
    private Icon minIcon = ImageUtil.createImageIcon("window_border_min.png", "window_border_min.png");
    private Icon closeIcon = ImageUtil.createImageIcon("window_border_close.png", "window_border_close.png");
    private boolean resizable = true;
    private boolean maxed;

    public EdalTitlePanel(Window window) {
        this(window, null);
    }

    public EdalTitlePanel(final Window window, String title) {
        this.window = window;
        this.setTitle(title);
        this.installListener();
        this.closeButton = this.createButton(this.closeIcon);
        this.resizeButton = this.createButton(this.maxIcon);
        this.minButton = this.createButton(this.minIcon);
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == EdalTitlePanel.this.closeButton) {
                    window.setVisible(false);
                    window.dispose();
                } else if (e.getSource() == EdalTitlePanel.this.resizeButton) {
                    if (EdalTitlePanel.this.isMaxed()) {
                        EdalTitlePanel.this.resetWindow();
                    } else {
                        EdalTitlePanel.this.setWindowMax();
                    }
                } else if (e.getSource() == EdalTitlePanel.this.minButton) {
                    ((JFrame)window).setExtendedState(1);
                }
            }
        };
        this.closeButton.addActionListener(buttonListener);
        this.resizeButton.addActionListener(buttonListener);
        this.minButton.addActionListener(buttonListener);
        this.setLayout(new FlowLayout(2, 0, 1));
        if (window instanceof JFrame) {
            this.add(this.minButton);
        }
        this.add(this.resizeButton);
        this.add(this.closeButton);
    }

    public JButton createButton(Icon icon) {
        JButton button = new JButton(icon);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setContentAreaFilled(false);
        button.setBorderPainted(true);
        button.setFocusable(false);
        button.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        return button;
    }

    public boolean isMaxed() {
        return this.maxed;
    }

    public void setWindowMax() {
        this.maxed = true;
        this.resizeButton.setIcon(this.restoreIcon);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.height -= 30;
        this.putClientProperty(TITLEORIGINALSIZE, this.window.getBounds());
        this.setWindowBounds(new Rectangle(screenSize));
    }

    public void resetWindow() {
        this.maxed = false;
        this.resizeButton.setIcon(this.maxIcon);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = this.getOriginalBounds();
        if (rect == null) {
            rect = new Rectangle(screenSize.width / 4, screenSize.height / 4, screenSize.width / 2, screenSize.height / 2);
        }
        this.setWindowBounds(rect);
    }

    private void setWindowBounds(Rectangle rect) {
        this.putClientProperty(TITLEORIGINALSIZE, this.window.getBounds());
        this.window.setBounds(new Rectangle(rect));
    }

    private Rectangle getOriginalBounds() {
        Object obj = this.getClientProperty(TITLEORIGINALSIZE);
        if (obj != null) {
            return (Rectangle)obj;
        }
        return null;
    }

    private void installListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EdalTitlePanel.this.pressPoint = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                EdalTitlePanel.this.pressPoint = null;
                if (SwingUtilities.isRightMouseButton(e)) {
                    // empty if block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && EdalTitlePanel.this.isResizable()) {
                    if (EdalTitlePanel.this.isMaxed()) {
                        EdalTitlePanel.this.resetWindow();
                    } else {
                        EdalTitlePanel.this.setWindowMax();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                EdalTitlePanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (EdalTitlePanel.this.pressPoint != null && !EdalTitlePanel.this.isMaxed()) {
                    Point point = EdalTitlePanel.this.window.getLocation();
                    double xoffset = (double)e.getX() - EdalTitlePanel.this.pressPoint.getX();
                    double yoffset = (double)e.getY() - EdalTitlePanel.this.pressPoint.getY();
                    EdalTitlePanel.this.window.setLocation((int)(point.getX() + xoffset), (int)(point.getY() + yoffset));
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
        this.repaint();
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image iconImage) {
        this.icon = iconImage;
        if (iconImage != null) {
            ImageIcon icon = new ImageIcon(iconImage);
            this.iconLabel.setIcon(icon);
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int iconHeight;
        Dimension size = super.getPreferredSize();
        int labelHeight = this.titleLabel.getPreferredSize().height;
        int h = this.titleHeight;
        if (labelHeight > h) {
            h = labelHeight;
        }
        if (h < (iconHeight = this.iconLabel.getPreferredSize().height + this.yGap)) {
            h = iconHeight;
        }
        return new Dimension(size.width, this.titleHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        TexturePaint paint = ImageUtil.createTexturePaint("outlook_bar_background.png");
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle bounds = this.getBounds();
        int xOffset = this.xGap;
        if (this.icon != null) {
            Dimension imageSize = this.iconLabel.getPreferredSize();
            double y = bounds.height / 2 - imageSize.height / 2;
            SwingUtilities.paintComponent(g2d, this.iconLabel, this, this.xGap, (int)y, imageSize.width, imageSize.height);
            xOffset += imageSize.width;
        }
        if (this.getTitle() != null) {
            Dimension labelSize = this.titleLabel.getPreferredSize();
            double x = bounds.getX() + (double)xOffset;
            if (this.textInCenter) {
                x = bounds.getWidth() / 2.0 - (double)labelSize.width / 2.0;
            }
            double y = bounds.height / 2 - labelSize.height / 2;
            SwingUtilities.paintComponent(g2d, this.titleLabel, this, (int)x, (int)y, labelSize.width, labelSize.height);
        }
        g2d.dispose();
    }

    public boolean isTextInCenter() {
        return this.textInCenter;
    }

    public void setTextInCenter(boolean textInCenter) {
        this.textInCenter = textInCenter;
        this.repaint();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.resizeButton.setEnabled(resizable);
    }
}

