/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.util;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ToolTipUI;

public class HyperLinkToolTip
extends JToolTip {
    private static final long serialVersionUID = 1L;
    private JEditorPane theEditorPane;

    public HyperLinkToolTip() {
        this.setLayout(new BorderLayout());
        LookAndFeel.installBorder(this, "ToolTip.border");
        LookAndFeel.installColors(this, "ToolTip.background", "ToolTip.foreground");
        this.theEditorPane = new JEditorPane();
        this.theEditorPane.setContentType("text/html");
        this.theEditorPane.setEditable(false);
        this.theEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HyperLinkToolTip.this.openWebpage(e.getURL());
                }
            }
        });
        this.add(this.theEditorPane);
    }

    @Override
    public void setTipText(String tipText) {
        this.theEditorPane.setText(tipText);
    }

    private void openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void openWebpage(URL url) {
        try {
            this.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new ToolTipUI(){});
    }
}

