/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.sample.client;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.EdalException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataFileException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;

public class SampleClient {
    public static void main(String[] args) throws PrimaryDataDirectoryException, PrimaryDataEntityVersionException, PrimaryDataFileException, EdalAuthenticateException, NotBoundException, IOException, EdalException {
        String serveraddress = null;
        int registryPort = 0;
        String localdirectory = null;
        String username = null;
        String password = null;
        if (args.length != 5) {
            System.out.println("Usage:    de.ipk_gatersleben.bit.bi.edal.rmi.client.sample.SampleClient option(s)");
            System.out.println("Options:    the first parameter is servername, the second parametr is registryport, the third parameter is local directory that you want to upload, the fourth parameter is your username, the fifth parameter is your password ");
            System.exit(-1);
        } else {
            serveraddress = args[0].trim();
            String sport = args[1].trim();
            try {
                registryPort = Integer.parseInt(sport);
            }
            catch (Exception e) {
                System.out.println("Usage:    de.ipk_gatersleben.bit.bi.edal.rmi.client.sample.SampleClient option(s)");
                System.out.println("Options:    the first parameter is servername, the second parametr is serverport, the third parameter is local directory that you want to upload");
                System.exit(-1);
            }
            localdirectory = args[2].trim();
            username = args[3].trim();
            password = args[4].trim();
        }
        Authentication loginobj = new Authentication(EdalHelpers.authenticateUser(username, password));
        ClientDataManager client = new ClientDataManager(serveraddress, registryPort, loginobj);
        ClientPrimaryDataDirectory rootDirectory = client.getRootDirectory();
        SampleClient.uploaddir(rootDirectory, localdirectory);
    }

    private static void uploaddir(ClientPrimaryDataDirectory remotedir, String parentpath) throws PrimaryDataDirectoryException, PrimaryDataFileException, PrimaryDataEntityVersionException, IOException {
        File[] files;
        File curpath = new File(parentpath);
        for (File file : files = curpath.listFiles()) {
            if (file.isDirectory()) {
                ClientPrimaryDataDirectory dir = remotedir.createPrimaryDataDirectory(file.getName());
                SampleClient.uploaddir(dir, file.getAbsolutePath());
                continue;
            }
            ClientPrimaryDataFile remotefile = remotedir.createPrimaryDataFile(file.getName());
            FileInputStream in = new FileInputStream(file);
            remotefile.store(in);
            ((InputStream)in).close();
        }
    }
}

