/**
 * Copyright (c) 2020 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *
 * We have chosen to apply the Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
 * License (https://creativecommons.org/licenses/by-sa/4.0/legalcode) to the copyrightable parts of e!DAL,
 * which are the source code, the executable software, the training and documentation material. This means,
 * you must give appropriate credit, provide a link to the license, and indicate if changes were made.
 * You are free to copy and redistribute e!DAL in any medium or format. You are also free to adapt, remix,
 * transform, and build upon e!DAL for any purpose, even commercially.
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.net.InetSocketAddress;
import java.security.Principal;

import javax.security.auth.Subject;

import de.ipk_gatersleben.bit.bi.edal.primary_data.EdalConfiguration;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;

public class GoogleAuthenticationProcess extends AuthenticationProcess {
	public GoogleAuthenticationProcess() {

		InetSocketAddress proxy = EdalConfiguration.guessProxySettings();

		if (proxy != null) {

			Subject subject = null;
			try {
				subject = EdalHelpers.authenticateGoogleUser(proxy.getHostName(), proxy.getPort());

				if (subject != null) {
					this.setSubject(subject);

					for (Principal princpal : subject.getPrincipals()) {
						this.setUsername(princpal.getName());
						break;
					}
				}
			} catch (EdalAuthenticateException e) {
				this.setUsername("");
			}
		} else {
			Subject subject = null;
			try {
				subject = EdalHelpers.authenticateGoogleUser();
				if (subject != null) {
					this.setSubject(subject);

					for (Principal princpal : subject.getPrincipals()) {
						this.setUsername(princpal.getName());
						break;
					}
				}
			} catch (EdalAuthenticateException e) {
				this.setUsername("");
			}
		}

	}
}
