/**
 * Copyright (c) 2020 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *
 * We have chosen to apply the Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
 * License (https://creativecommons.org/licenses/by-sa/4.0/legalcode) to the copyrightable parts of e!DAL,
 * which are the source code, the executable software, the training and documentation material. This means,
 * you must give appropriate credit, provide a link to the license, and indicate if changes were made.
 * You are free to copy and redistribute e!DAL in any medium or format. You are also free to adapt, remix,
 * transform, and build upon e!DAL for any purpose, even commercially.
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import java.security.Principal;

import javax.security.auth.Subject;

import de.ipk_gatersleben.bit.bi.edal.primary_data.login.SamplePrincipal;
import de.ipk_gatersleben.bit.bi.edal.primary_data.security.EdalAuthenticateException;
import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;

public class JKIAuthenticationProcess extends AuthenticationProcess {

	public JKIAuthenticationProcess() {

		try {
			Subject tmpJKISubject = EdalHelpers.authenticateJKIKerberosUser(null);

			for (Principal principal : tmpJKISubject.getPrincipals()) {

				String name = principal.getName();

				String email = name.subSequence(0, name.indexOf("@")).toString() + "@julius-kuehn.de";

				Subject newSubject = new Subject();
				newSubject.getPrincipals().add(new SamplePrincipal(email));

				this.setSubject(newSubject);
				break;
			}
		} catch (EdalAuthenticateException e) {
			e.printStackTrace();
		}
	}
}