/**
 * Copyright (c) 2020 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *
 * We have chosen to apply the Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)
 * License (https://creativecommons.org/licenses/by-sa/4.0/legalcode) to the copyrightable parts of e!DAL,
 * which are the source code, the executable software, the training and documentation material. This means,
 * you must give appropriate credit, provide a link to the license, and indicate if changes were made.
 * You are free to copy and redistribute e!DAL in any medium or format. You are also free to adapt, remix,
 * transform, and build upon e!DAL for any purpose, even commercially.
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui.viewer;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.Persons;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.UntypedData;

/**
 * The <code>PersonInfoViewer</code> is a wrapper class for
 * <code>PersonviewDialog</code>, we can use it with a couple of lines of code:
 * 
 * <pre>
 * PersonInfoViewer personInfoViewer = new PersonInfoViewer();
 * personInfoViewer.setValue(person);
 * personInfoViewer.showOpenDialog();
 * </pre>
 * 
 * @version 1.0
 * @author Jinbo Chen
 */
public class PersonInfoViewer extends MetadataViewer {
	private Persons _persons;
	private String _title;

	/**
	 * set the Person value.
	 * 
	 * set the Person value.
	 */
	public void setValue(UntypedData persons) {
		if (persons != null) {
			this._persons = (Persons) persons;
		}
	}

	/**
	 * pop up a PersonviewDialog Dialog
	 */
	public int showOpenDialog() {
		PersonsViewDialog dlg = new PersonsViewDialog(this._persons, this._title);
		int returnVal = dlg.showOpenDialog();
		return returnVal;
	}

	@Override
	public void setTitle(String title) {
		_title = title;
	}
}
