/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication;

import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class PropertyLoader {
    public static final String PROGRAM_NAME = "IPK Data Publication System";
    public static final String AGREEMENT_PANEL_PROPERTY = "AGREEMENT_PANEL";
    public static final String AGREEMENT_PDF_PROPERTY = "AGREEMENT_PDF";
    private static Path userAttributeFile = Paths.get(System.getProperty("user.home"), ".eDAL", "attributes.txt");
    private static String propertyFile = null;
    public static URL PGP_CONTRACT_URL = null;
    public static URL ADOBE_GET_URL = null;
    public static Image EDAL_LOGO = null;
    public static Image EDAL_ICON = null;
    public static ImageIcon PDF_ICON = null;
    public static ImageIcon ADOBE_ICON = null;
    public static Properties props;
    public static Properties userValues;
    public static Path RUNNING_PATH;
    public static final Color HEADER_FOOTER_COLOR;
    public static final Color MAIN_BACKGROUND_COLOR;
    public static final Color LABEL_COLOR;
    public static final Color MAIN_FONT_COLOR;
    public static final Color DISABLED_FONT_COLOR;
    public static final Color OPEN_ACCESS_COLOR;
    public static final Color TABLE_HAS_VALUE_BACKGROUND_COLOR;
    public static final Font OPEN_ACCESS_FONT;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int ATTRIBUTE_LABEL_FONT_SIZE = 13;
    public static final int SMALL_BUTTON_FONT_SIZE = 11;
    public static final Font DEFAULT_FONT;
    public static final Font AGREEMENT_PANEL_FONT;
    public static final int TITLE_PANEL_HEIGHT = 24;
    public static final int SUBJECTS_PANEL_HEIGHT = 48;
    public static final int PUBLISHER_PANEL_HEIGHT = 60;
    public static final int AUTHOR_PANEL_HEIGHT = 60;
    public static final int EMBARGO_PANEL_HEIGHT = 132;
    public static final int LICENSE_PANEL_HEIGHT = 168;
    public static final int DESCRIPTION_PANEL_HEIGHT = 48;
    public static final int TWO_LINE_HEIGHT = 24;
    public static final Dimension MINIMUM_DIM_PUBLICATION_FRAME;
    public static final int ATTRIBUTE_PANEL_WIDTH = 680;
    public static final int ATTRIBUTE_LABEL_WIDTH = 120;
    public static List<String> SUPPORTED_LICENSES;
    public static List<String> SUPPORTED_LICENSES_LEGAL_CODE_URL;
    public static List<String> SUPPORTED_LICENSES_HUMAN_READABLE_URL;
    public static List<String> RESOURCE_TYPES;
    public static AttributeLabel UPLOADPATH_LABEL;
    public static AttributeLabel TITLE_LABEL;
    public static AttributeLabel DESCRIPTION_LABEL;
    public static AttributeLabel AUTHORS_LABEL;
    public static AttributeLabel SUBJECTS_LABEL;
    public static AttributeLabel LANGUAGE_LABEL;
    public static AttributeLabel LICENSE_LABEL;
    public static AttributeLabel PUBLISHER_LABEL;
    public static AttributeLabel EMBARGO_LABEL;
    public static AttributeLabel RESOURCE_LABEL;

    private static void initGraphicComponents() {
        UPLOADPATH_LABEL = new AttributeLabel(props.getProperty("UPLOAD_LABEL"), props.getProperty("UPLOAD_TOOLTIP"));
        TITLE_LABEL = new AttributeLabel(props.getProperty("TITLE_LABEL"), props.getProperty("TITLE_TOOLTIP"));
        DESCRIPTION_LABEL = new AttributeLabel(props.getProperty("DESCRIPTION_LABEL"), props.getProperty("DESCRIPTION_TOOLTIP"));
        AUTHORS_LABEL = new AttributeLabel(props.getProperty("AUTHORS_LABEL"), props.getProperty("AUTHORS_TOOLTIP"));
        SUBJECTS_LABEL = new AttributeLabel(props.getProperty("SUBJECTS_LABEL"), props.getProperty("SUBJECTS_TOOLTIP"));
        LANGUAGE_LABEL = new AttributeLabel(props.getProperty("LANGUAGE_LABEL"), props.getProperty("LANGUAGE_TOOLTIP"));
        LICENSE_LABEL = new AttributeLabel(props.getProperty("LICENSE_LABEL"), props.getProperty("LICENSE_TOOLTIP"));
        PUBLISHER_LABEL = new AttributeLabel(props.getProperty("PUBLISHER_LABEL"), props.getProperty("PUBLISHER_TOOLTIP"));
        EMBARGO_LABEL = new AttributeLabel(props.getProperty("EMBARGO_LABEL"), props.getProperty("EMBARGO_TOOLTIP"));
        RESOURCE_LABEL = new AttributeLabel(props.getProperty("RESOURCE_LABEL"), props.getProperty("RESOURCE_TOOLTIP"));
    }

    private static void loadEdalLogos() {
        EDAL_LOGO = new ImageIcon(PropertyLoader.class.getResource("edal_scaled.png")).getImage();
        EDAL_ICON = new ImageIcon(PropertyLoader.class.getResource("edal_icon.png")).getImage();
        PDF_ICON = new ImageIcon(PropertyLoader.class.getResource("pdf_icon.png"));
        Image image = PDF_ICON.getImage();
        Image newimg = image.getScaledInstance(15, 20, 4);
        PDF_ICON = new ImageIcon(newimg);
        ADOBE_ICON = new ImageIcon(PropertyLoader.class.getResource("adobe.png"));
        Image a_image = ADOBE_ICON.getImage();
        Image new_a_img = a_image.getScaledInstance(20, 20, 4);
        ADOBE_ICON = new ImageIcon(new_a_img);
    }

    private static void loadProperties() {
        props = new Properties();
        try {
            props.load(new InputStreamReader(PropertyLoader.class.getResourceAsStream(propertyFile), "UTF-8"));
        }
        catch (IOException | NullPointerException e) {
            JOptionPane.showMessageDialog(null, "Unable to load property file '" + propertyFile + "' : " + e.getMessage(), "ERROR", 0);
            System.exit(0);
        }
        SUPPORTED_LICENSES = new ArrayList<String>();
        SUPPORTED_LICENSES_LEGAL_CODE_URL = new ArrayList<String>();
        SUPPORTED_LICENSES_HUMAN_READABLE_URL = new ArrayList<String>();
        int i = 1;
        while (props.getProperty("LICENSE_" + i) != null) {
            SUPPORTED_LICENSES.add(props.getProperty("LICENSE_" + i));
            SUPPORTED_LICENSES_LEGAL_CODE_URL.add(props.getProperty("SUPPORTED_LICENSES_LEGAL_CODE_URL_" + i));
            SUPPORTED_LICENSES_HUMAN_READABLE_URL.add(props.getProperty("SUPPORTED_LICENSES_HUMAN_READABLE_URL_" + i));
            ++i;
        }
        RESOURCE_TYPES = new ArrayList<String>();
        i = 1;
        while (props.getProperty("RESOURCE_TYPE_" + i) != null) {
            RESOURCE_TYPES.add(props.getProperty("RESOURCE_TYPE_" + i));
            ++i;
        }
    }

    private static void loadRunnigPath() {
        try {
            RUNNING_PATH = Paths.get(PropertyLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (Exception e) {
            RUNNING_PATH = Paths.get(System.getProperty("user.home"), new String[0]);
        }
    }

    private static void loadUserValues() {
        userValues = new Properties();
        try {
            userValues.load(new FileInputStream(userAttributeFile.toFile()));
        }
        catch (IOException | NullPointerException e) {
            try {
                Files.createFile(userAttributeFile, new FileAttribute[0]);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "Unable to load/create user file '" + userAttributeFile + "' : " + e.getMessage(), "ERROR", 0);
                System.exit(0);
            }
        }
    }

    public static void initialize(String propsFile) {
        propertyFile = propsFile;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            ClientDataManager.logger.info("Use " + UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                ClientDataManager.logger.info("Use " + UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                e1.printStackTrace();
            }
        }
        Locale.setDefault(Locale.ENGLISH);
        try {
            PGP_CONTRACT_URL = new URL("http://edal-pgp.ipk-gatersleben.de/document/PGP-contract.pdf");
            ADOBE_GET_URL = new URL("https://get.adobe.com/de/reader/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        PropertyLoader.loadProperties();
        PropertyLoader.loadUserValues();
        PropertyLoader.loadRunnigPath();
        PropertyLoader.loadEdalLogos();
        PropertyLoader.initGraphicComponents();
        ToolTipManager.sharedInstance().setInitialDelay(0);
    }

    private static void saveUserValue() {
        try {
            FileOutputStream out = new FileOutputStream(userAttributeFile.toFile());
            userValues.store(out, "Update");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String loadSubjectsString() {
        String subjects = userValues.getProperty("SUBJECTS");
        if (subjects == null || subjects.isEmpty()) {
            return props.getProperty("DEFAULT_SUBJECTS_STRING");
        }
        return subjects;
    }

    public static String loadPublisherString() {
        String publisherString = userValues.getProperty("PUBLISHER");
        if (publisherString == null || publisherString.isEmpty()) {
            return props.getProperty("DEFAULT_PUBLISHER_STRING");
        }
        if (publisherString.equals(props.getProperty("DEFAULT_PUBLISHER_STRING"))) {
            StringBuffer buffer = new StringBuffer();
            String[] publisher = publisherString.split(";");
            for (int i = 0; i < publisher.length; ++i) {
                buffer.append(publisher[i]);
                if (i == publisher.length - 1) continue;
                buffer.append(", ");
            }
            return buffer.toString();
        }
        return props.getProperty("DEFAULT_PUBLISHER_STRING");
    }

    public static String loadAuthorsString() {
        String authorsString = userValues.getProperty("AUTHORS");
        if (authorsString == null || authorsString.isEmpty()) {
            return props.getProperty("DEFAULT_AUTHORS_STRING");
        }
        StringBuffer buffer = new StringBuffer();
        String[] authors = authorsString.split(";");
        for (int i = 0; i < authors.length; ++i) {
            String[] author = authors[i].split("@");
            if (author[0].equals("Creator") || author[0].equals("Contributor")) {
                if (!author[2].isEmpty() && !author[3].isEmpty()) {
                    buffer.append(author[3]);
                    buffer.append(", ");
                    buffer.append(author[2]);
                    if (i == authors.length - 1) continue;
                    buffer.append("; ");
                    continue;
                }
                if (author[4].isEmpty()) continue;
                buffer.append(author[4]);
                if (i == authors.length - 1) continue;
                buffer.append("; ");
                continue;
            }
            return props.getProperty("DEFAULT_AUTHORS_STRING");
        }
        return buffer.toString();
    }

    public static void setUserValue(String key, String value) {
        userValues.setProperty(key, value);
        PropertyLoader.saveUserValue();
    }

    public static String loadLanguageString() {
        String language = userValues.getProperty("LANGUAGE");
        if (language == null || language.isEmpty()) {
            return props.getProperty("DEFAULT_LANGUAGE_STRING");
        }
        return language;
    }

    public static String loadResourceString() {
        String resourceType = userValues.getProperty("RESOURCE_TYPE");
        if (resourceType == null || resourceType.isEmpty()) {
            return props.getProperty("DEFAULT_RESOURCE_STRING");
        }
        return resourceType;
    }

    public static String loadUploadPathString() {
        String uploadPath = userValues.getProperty("UPLOAD_PATH");
        if (uploadPath == null || uploadPath.isEmpty()) {
            return props.getProperty("DEFAULT_UPLOAD_PATH_STRING");
        }
        if (Files.exists(Paths.get(uploadPath, new String[0]), new LinkOption[0])) {
            return uploadPath;
        }
        PropertyLoader.setUserValue("UPLOAD_PATH", props.getProperty("DEFAULT_UPLOAD_PATH_STRING"));
        return props.getProperty("DEFAULT_UPLOAD_PATH_STRING");
    }

    static {
        RUNNING_PATH = null;
        HEADER_FOOTER_COLOR = new Color(210, 210, 210);
        MAIN_BACKGROUND_COLOR = Color.WHITE;
        LABEL_COLOR = new Color(0, 132, 184);
        MAIN_FONT_COLOR = Color.BLACK;
        DISABLED_FONT_COLOR = Color.LIGHT_GRAY;
        OPEN_ACCESS_COLOR = new Color(0, 128, 0);
        TABLE_HAS_VALUE_BACKGROUND_COLOR = (Color)UIManager.getDefaults().get("ComboBox.selectionBackground");
        OPEN_ACCESS_FONT = new Font("SansSerif", 1, 12);
        DEFAULT_FONT = new Font("SansSerif", 0, 12);
        AGREEMENT_PANEL_FONT = new Font("SansSerif", 1, 12);
        MINIMUM_DIM_PUBLICATION_FRAME = new Dimension(1024, 800);
        SUPPORTED_LICENSES = null;
        SUPPORTED_LICENSES_LEGAL_CODE_URL = null;
        SUPPORTED_LICENSES_HUMAN_READABLE_URL = null;
        RESOURCE_TYPES = null;
    }
}

