/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.LegalPerson;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLabel;
import de.ipk_gatersleben.bit.bi.edal.publication.AttributeLableAttributeTextAreaPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PropertyLoader;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationButtonLinePanel;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationFrame;
import de.ipk_gatersleben.bit.bi.edal.publication.PublicationMainPanel;
import de.ipk_gatersleben.bit.bi.edal.publication.SmallButton;
import de.ipk_gatersleben.bit.bi.edal.publication.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class PublisherPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8109825692298261311L;
    private static final AttributeLabel PUBLISHER_LABEL = new AttributeLabel(PropertyLoader.props.getProperty("PUBLISHER_LABEL"), PropertyLoader.props.getProperty("PUBLISHER_TOOLTIP"));
    private static final SmallButton OKAY_BUTTON = new SmallButton("OK");
    private JTable table = new JTable(new MyTableModel());
    private static final String[] DEFAULT_PUBLISHER = new String[]{"Leibniz Institute of Plant Genetics and Crop Plant Research (IPK)", "Stadt Seeland, OT Gatersleben, Corrensstra\u00dfe 3", "06466", "Germany"};
    private static final String[] COL_NAMES = new String[]{"Name", "Address", "Zip", "Country"};

    public PublisherPanel() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            ((DefaultCellEditor)this.table.getDefaultEditor(this.table.getColumnClass(i))).setClickCountToStart(1);
        }
        this.table.setFillsViewportHeight(true);
        this.table.setFont(PropertyLoader.DEFAULT_FONT);
        this.table.setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.table.getTableHeader().setFont(PropertyLoader.DEFAULT_FONT);
        this.table.getTableHeader().setForeground(PropertyLoader.MAIN_FONT_COLOR);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(60);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        buttonPanel.add(OKAY_BUTTON);
        OKAY_BUTTON.addActionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(680, 60));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel tablePanel = new JPanel(gridBagLayout);
        tablePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        tablePanel.setPreferredSize(new Dimension(680, 60));
        EmptyBorder inBorder = new EmptyBorder(2, 2, 0, 2);
        EmptyBorder outBorder = new EmptyBorder(2, 2, 0, 2);
        tablePanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        Utils.add(tablePanel, gridBagLayout, scrollPane, 0, 0, 1, 1, 1.0, 0.95, 1, 1);
        Utils.add(tablePanel, gridBagLayout, buttonPanel, 0, 1, 1, 1, 1.0, 0.05, 1, 1);
        JPanel attributePanel = new JPanel(new GridLayout());
        PUBLISHER_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
        attributePanel.add(PUBLISHER_LABEL);
        attributePanel.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        attributePanel.setPreferredSize(new Dimension(120, 60));
        this.setBackground(PropertyLoader.MAIN_BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)attributePanel, "West");
        this.add((Component)tablePanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(OKAY_BUTTON)) {
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null && cellEditor.getCellEditorValue() == null) {
                cellEditor.stopCellEditing();
            }
            this.table.clearSelection();
            PublicationMainPanel.publisherPanel = this;
            PublicationMainPanel.publisherField.setText(this.getTableContent());
            PublicationMainPanel.releaseAllBlockedFields();
            PublicationMainPanel.subjectsPublisherPanel.setRightComponent(null);
            PropertyLoader.PUBLISHER_LABEL.setForeground(PropertyLoader.LABEL_COLOR);
            PublicationMainPanel.subjectsPublisherPanel.setRightComponent(new AttributeLableAttributeTextAreaPanel(PropertyLoader.PUBLISHER_LABEL, PublicationMainPanel.publisherField, 60));
            PublicationFrame.updateUI();
            PublicationButtonLinePanel.getNextButton().requestFocus();
            this.saveUserValues();
        }
    }

    private void saveUserValues() {
        StringBuffer buffer = new StringBuffer();
        String seperator = new String(";");
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 0).toString())) {
            buffer.append(this.table.getValueAt(0, 0).toString());
        }
        buffer.append(seperator);
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 1).toString())) {
            buffer.append(this.table.getValueAt(0, 1).toString());
        }
        buffer.append(seperator);
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 2).toString())) {
            buffer.append(this.table.getValueAt(0, 2).toString());
        }
        buffer.append(seperator);
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 3).toString())) {
            buffer.append(this.table.getValueAt(0, 3).toString());
        }
        PropertyLoader.setUserValue("PUBLISHER", buffer.toString());
    }

    private String getTableContent() {
        String seperator = new String(", ");
        StringBuffer buffer = new StringBuffer("");
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 0).toString())) {
            buffer.append(this.table.getValueAt(0, 0).toString());
            buffer.append(seperator);
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 1).toString())) {
            buffer.append(this.table.getValueAt(0, 1).toString());
            buffer.append(seperator);
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 2).toString())) {
            buffer.append(this.table.getValueAt(0, 2).toString());
            buffer.append(seperator);
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 3).toString())) {
            buffer.append(this.table.getValueAt(0, 3).toString());
        }
        if (Utils.checkIfStringIsEmpty(buffer.toString())) {
            Object[][] data = new Object[][]{DEFAULT_PUBLISHER};
            ((MyTableModel)this.table.getModel()).setDataVector(data, COL_NAMES);
            return PropertyLoader.props.getProperty("DEFAULT_PUBLISHER_STRING");
        }
        return buffer.toString();
    }

    public LegalPerson getPublisher() {
        String legalName = "unkown";
        String addressLine = "unkown";
        String zip = "unkown";
        String country = "unkown";
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 0).toString())) {
            legalName = this.table.getValueAt(0, 0).toString();
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 1).toString())) {
            addressLine = this.table.getValueAt(0, 1).toString();
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 2).toString())) {
            zip = this.table.getValueAt(0, 2).toString();
        }
        if (!Utils.checkIfStringIsEmpty(this.table.getValueAt(0, 3).toString())) {
            country = this.table.getValueAt(0, 3).toString();
        }
        LegalPerson legalPerson = new LegalPerson(legalName, addressLine, zip, country);
        return legalPerson;
    }

    private class MyTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8557354261856948625L;

        public MyTableModel() {
            this.setDataVector(this.loadUserValues(), COL_NAMES);
        }

        private Object[][] loadUserValues() {
            String string = PropertyLoader.userValues.getProperty("PUBLISHER");
            if (string == null || string.isEmpty()) {
                String[] authors = PropertyLoader.props.getProperty("DEFAULT_PUBLISHER_STRING").split(";");
                Object[][] data = new Object[1][4];
                for (int i = 0; i < authors.length; ++i) {
                    data[0][i] = authors[i];
                }
                return data;
            }
            String[] authors = string.split(";");
            Object[][] data = new Object[1][4];
            for (int i = 0; i < authors.length; ++i) {
                data[0][i] = authors[i];
            }
            return data;
        }
    }
}

