/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.attribute.panel;

import de.ipk_gatersleben.bit.bi.edal.sample.EdalHelpers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class PushableTableHeader
extends JPanel {
    public PushableTableHeader(TableColumn column, JTableHeader header) {
        this.setLayout(new BorderLayout());
        ButtonHeaderRenderer renderer = new ButtonHeaderRenderer();
        column.setHeaderRenderer(renderer);
        header.addMouseListener(new HeaderListener(header, renderer));
    }

    public static void main(String[] args) {
    }

    private class ButtonHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 8797975701378444045L;
        int pushedColumn = -1;

        public ButtonHeaderRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setToolTipText("Please follow the link to learn more about ORCID");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            this.setForeground(Color.BLUE);
            boolean isPressed = column == this.pushedColumn;
            this.getModel().setPressed(isPressed);
            this.getModel().setArmed(isPressed);
            return this;
        }

        public void setPressedColumn(int col) {
            this.pushedColumn = col;
        }
    }

    public class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        ButtonHeaderRenderer renderer;

        HeaderListener(JTableHeader header, ButtonHeaderRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = this.header.getTable().columnAtPoint(e.getPoint());
            String name = this.header.getTable().getColumnName(col);
            if (col == 1 && name.equals("ORCID")) {
                EdalHelpers.openURL((String)"https://orcid.org");
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            int col = this.header.getTable().columnAtPoint(e.getPoint());
            String name = this.header.getTable().getColumnName(col);
            if (col == 1 && name.equals("ORCID")) {
                this.header.setCursor(new Cursor(12));
            }
        }
    }
}

