/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import de.ipk_gatersleben.bit.bi.edal.publication.metadata.FileProgressMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JProgressBar;

public class FileProgressInputStream
extends FilterInputStream {
    private FileProgressMonitor monitor;
    private long nread = 0L;
    private long size = 0L;
    private JProgressBar fileProgressBar;
    private long steps = 0L;
    private String filename;

    public FileProgressInputStream(JProgressBar fileProgressBar, InputStream inputStream, String filename, long length) {
        super(inputStream);
        this.fileProgressBar = fileProgressBar;
        this.filename = filename;
        this.size = length;
        this.monitor = new FileProgressMonitor(this.fileProgressBar, this.size);
    }

    public FileProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.fileProgressBar.setString(this.filename);
            this.monitor.setProgress(++this.nread);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.fileProgressBar.setString(this.filename);
            this.monitor.setProgress(this.nread += (long)nr);
        }
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        String label;
        String prepareCopy = "Prepare Copying : ";
        if ((long)this.in.available() == this.size) {
            label = this.fileProgressBar.getString();
            if (label.indexOf(prepareCopy) == -1) {
                this.fileProgressBar.setString(prepareCopy + label);
            }
            this.monitor.setProgress((int)this.steps);
        } else {
            label = this.fileProgressBar.getString();
            if (label.indexOf(prepareCopy) != -1) {
                this.fileProgressBar.setString(label.substring(label.indexOf(prepareCopy) + prepareCopy.length(), label.length()));
            }
            this.monitor.setProgress(this.size - (long)this.in.available());
        }
        int nr = this.in.read(b, off, len);
        ++this.steps;
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.monitor.setProgress(this.nread += nr);
        }
        return nr;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.monitor.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - (long)this.in.available();
        this.monitor.setProgress(this.nread);
    }
}

