/*
 * Decompiled with CFR 0.152.
 */
package de.ipk_gatersleben.bit.bi.edal.publication.metadata;

import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataDirectoryException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.file.PrimaryDataEntityVersionException;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.EnumDublinCoreElements;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaData;
import de.ipk_gatersleben.bit.bi.edal.primary_data.metadata.MetaDataException;
import de.ipk_gatersleben.bit.bi.edal.publication.metadata.FileStoreSwingWorker;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataEntity;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataFile;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JProgressBar;

public class PublicationDirectoryVisitorWithMetaDataRmi
implements FileVisitor<Path> {
    private static final List<String> FORBIDDEN_FILES = Arrays.asList("thumbs.db", ".DS_Store", "desktop.ini");
    private ClientPrimaryDataDirectory currentDirectory = null;
    private MetaData metaData;
    private ClientPrimaryDataDirectory directoryToPublish = null;
    private JProgressBar overallProgressBar;
    private JProgressBar fileProgressBar;
    private boolean updateEdalObject = false;
    private boolean createSeparateFolder = false;
    private CountDownLatch latch;
    private boolean alreadyVisitedRootFolder = false;

    public ClientPrimaryDataDirectory getRootDirectoryToPublish() {
        return this.directoryToPublish;
    }

    public PublicationDirectoryVisitorWithMetaDataRmi(JProgressBar overallProgressBar, JProgressBar fileProgressBar, ClientPrimaryDataDirectory currentDirectory, Path path, MetaData metaData, boolean updateEdalObject, boolean createSeparateFolder, CountDownLatch latch) {
        this.currentDirectory = currentDirectory;
        this.metaData = metaData;
        this.overallProgressBar = overallProgressBar;
        this.fileProgressBar = fileProgressBar;
        this.updateEdalObject = updateEdalObject;
        this.createSeparateFolder = createSeparateFolder;
        this.latch = latch;
        try {
            ClientPrimaryDataDirectory newCurrentDirectory = null;
            if (updateEdalObject && this.currentDirectory.exist(this.metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString())) {
                newCurrentDirectory = (ClientPrimaryDataDirectory)this.currentDirectory.getPrimaryDataEntity(this.metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString());
                this.setMetaData(newCurrentDirectory);
            } else if (this.createSeparateFolder) {
                newCurrentDirectory = this.currentDirectory.createPrimaryDataDirectory(this.metaData.getElementValue((Enum)EnumDublinCoreElements.TITLE).toString());
                this.setMetaData(newCurrentDirectory);
            } else {
                newCurrentDirectory = this.currentDirectory.createPrimaryDataDirectory(path.getFileName().toString());
                this.setMetaData(newCurrentDirectory);
            }
            this.currentDirectory = newCurrentDirectory;
            this.directoryToPublish = newCurrentDirectory;
        }
        catch (PrimaryDataDirectoryException | MetaDataException | RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.alreadyVisitedRootFolder) {
            try {
                ClientPrimaryDataDirectory newCurrentDirectory = null;
                newCurrentDirectory = this.updateEdalObject && this.currentDirectory.exist(dir.getFileName().toString()) ? (ClientPrimaryDataDirectory)this.currentDirectory.getPrimaryDataEntity(dir.getFileName().toString()) : this.currentDirectory.createPrimaryDataDirectory(dir.getFileName().toString());
                this.currentDirectory = newCurrentDirectory;
            }
            catch (PrimaryDataDirectoryException | AccessControlException e) {
                e.printStackTrace();
            }
            return FileVisitResult.CONTINUE;
        }
        this.alreadyVisitedRootFolder = true;
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        try {
            ClientPrimaryDataFile clientPrimaryDataFile = null;
            if (FORBIDDEN_FILES.contains(file.getFileName().toString())) {
                this.overallProgressBar.setValue(this.overallProgressBar.getValue() + 1);
                this.latch.countDown();
                return FileVisitResult.CONTINUE;
            }
            clientPrimaryDataFile = this.updateEdalObject && this.currentDirectory.exist(file.getFileName().toString()) ? (ClientPrimaryDataFile)this.currentDirectory.getPrimaryDataEntity(file.getFileName().toString()) : this.currentDirectory.createPrimaryDataFile(file.getFileName().toString());
            FileStoreSwingWorker worker = new FileStoreSwingWorker(this.fileProgressBar, this.overallProgressBar, file, clientPrimaryDataFile, this.latch);
            worker.execute();
        }
        catch (PrimaryDataDirectoryException | AccessControlException e) {
            e.printStackTrace();
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        try {
            this.currentDirectory = this.currentDirectory.getParentDirectory();
        }
        catch (PrimaryDataDirectoryException | AccessControlException e) {
            e.printStackTrace();
        }
        this.overallProgressBar.setValue(this.overallProgressBar.getValue() + 1);
        this.latch.countDown();
        return FileVisitResult.CONTINUE;
    }

    private void setMetaData(ClientPrimaryDataEntity entity) {
        try {
            MetaData m = entity.getMetaData().clone();
            m.setElementValue(EnumDublinCoreElements.CREATOR, this.metaData.getElementValue((Enum)EnumDublinCoreElements.CREATOR));
            m.setElementValue(EnumDublinCoreElements.CONTRIBUTOR, this.metaData.getElementValue((Enum)EnumDublinCoreElements.CONTRIBUTOR));
            m.setElementValue(EnumDublinCoreElements.COVERAGE, this.metaData.getElementValue((Enum)EnumDublinCoreElements.COVERAGE));
            m.setElementValue(EnumDublinCoreElements.SUBJECT, this.metaData.getElementValue((Enum)EnumDublinCoreElements.SUBJECT));
            m.setElementValue(EnumDublinCoreElements.LANGUAGE, this.metaData.getElementValue((Enum)EnumDublinCoreElements.LANGUAGE));
            m.setElementValue(EnumDublinCoreElements.DESCRIPTION, this.metaData.getElementValue((Enum)EnumDublinCoreElements.DESCRIPTION));
            m.setElementValue(EnumDublinCoreElements.PUBLISHER, this.metaData.getElementValue((Enum)EnumDublinCoreElements.PUBLISHER));
            m.setElementValue(EnumDublinCoreElements.RIGHTS, this.metaData.getElementValue((Enum)EnumDublinCoreElements.RIGHTS));
            m.setElementValue(EnumDublinCoreElements.SOURCE, this.metaData.getElementValue((Enum)EnumDublinCoreElements.SOURCE));
            entity.setMetaData(m);
        }
        catch (PrimaryDataEntityVersionException | MetaDataException | CloneNotSupportedException | RemoteException e) {
            e.printStackTrace();
        }
    }
}

